/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.compiler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.operations.generic.GenericTypeCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.generic.GenericTypeExtend;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.AbstractOperationCompiler;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class GenericOperationCompiler
extends AbstractOperationCompiler {
    public GenericOperationCompiler(IQueryRuntimeContext runtimeContext) {
        super(runtimeContext);
    }

    @Override
    protected void createCheck(TypeFilterConstraint typeConstraint, Map<PVariable, Integer> variableMapping) throws QueryProcessingException {
        IInputKey inputKey = typeConstraint.getInputKey();
        Tuple tuple = typeConstraint.getVariablesTuple();
        Integer[] positions = new Integer[tuple.getSize()];
        int i = 0;
        while (i < tuple.getSize()) {
            PVariable variable = (PVariable)tuple.get(i);
            positions[i] = variableMapping.get(variable);
            ++i;
        }
        this.operations.add(new GenericTypeCheck(inputKey, positions));
    }

    @Override
    protected void createCheck(TypeConstraint typeConstraint, Map<PVariable, Integer> variableMapping) throws QueryProcessingException {
        IInputKey inputKey = (IInputKey)typeConstraint.getSupplierKey();
        Tuple tuple = typeConstraint.getVariablesTuple();
        Integer[] positions = new Integer[tuple.getSize()];
        int i = 0;
        while (i < tuple.getSize()) {
            PVariable variable = (PVariable)tuple.get(i);
            positions[i] = variableMapping.get(variable);
            ++i;
        }
        this.operations.add(new GenericTypeCheck(inputKey, positions));
    }

    @Override
    protected void createExtend(TypeConstraint typeConstraint, Map<PVariable, Integer> variableMapping) {
        IInputKey inputKey = (IInputKey)typeConstraint.getSupplierKey();
        Tuple tuple = typeConstraint.getVariablesTuple();
        Integer[] positions = new Integer[tuple.getSize()];
        HashSet<Integer> boundVariables = new HashSet<Integer>();
        int i = 0;
        while (i < tuple.getSize()) {
            Integer position;
            PVariable variable = (PVariable)tuple.get(i);
            positions[i] = position = variableMapping.get(variable);
            if (((Set)this.variableBindings.get(typeConstraint)).contains(position)) {
                boundVariables.add(position);
            }
            ++i;
        }
        this.operations.add(new GenericTypeExtend(inputKey, positions, boundVariables));
    }
}

