/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.ApplicationRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.HostRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.StateMachineRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.StateRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.TransitionRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.TriggerRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PerJobFixedPriorityConflictResolver;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.scheduler.UpdateCompleteBasedScheduler;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CPS2DeploymentTransformationQrt {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.expl.incr");
    @Extension
    private CpsXformM2M cpsXformM2M = new Functions.Function0<CpsXformM2M>(){

        public CpsXformM2M apply() {
            try {
                CpsXformM2M _instance = CpsXformM2M.instance();
                return _instance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();
    private ExecutionSchema schema = null;
    private CPSToDeployment cps2dep;
    private ViatraQueryEngine engine;

    public void initialize(CPSToDeployment cps2dep, ViatraQueryEngine engine) {
        try {
            boolean _notEquals = !Objects.equal((Object)cps2dep, null);
            Preconditions.checkArgument((boolean)_notEquals, (Object)"Mapping cannot be null!");
            CyberPhysicalSystem _cps = cps2dep.getCps();
            boolean _notEquals_1 = !Objects.equal((Object)_cps, null);
            Preconditions.checkArgument((boolean)_notEquals_1, (Object)"CPS not defined in mapping!");
            Deployment _deployment = cps2dep.getDeployment();
            boolean _notEquals_2 = !Objects.equal((Object)_deployment, null);
            Preconditions.checkArgument((boolean)_notEquals_2, (Object)"Deployment not defined in mapping!");
            boolean _notEquals_3 = !Objects.equal((Object)engine, null);
            Preconditions.checkArgument((boolean)_notEquals_3, (Object)"Engine cannot be null!");
            this.cps2dep = cps2dep;
            this.engine = engine;
            this.logger.debug((Object)"Preparing queries on engine.");
            Stopwatch watch = Stopwatch.createStarted();
            this.cpsXformM2M.prepare(engine);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Prepared queries on engine (");
            long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder.append((Object)_elapsed);
            _builder.append((Object)" ms)");
            this.logger.info((Object)_builder);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void execute() {
        boolean _equals = Objects.equal((Object)this.schema, null);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Executing transformation on:");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"Cyber-physical system: ");
            String _identifier = this.cps2dep.getCps().getIdentifier();
            _builder.append((Object)_identifier, "\t");
            this.logger.info((Object)_builder);
            this.logger.debug((Object)"Preparing transformation rules.");
            Stopwatch watch = Stopwatch.createStarted();
            ImmutableSet.Builder rulesBuilder = ImmutableSet.builder();
            rulesBuilder.addAll(HostRules.getRules(this.engine));
            rulesBuilder.addAll(ApplicationRules.getRules(this.engine));
            rulesBuilder.addAll(StateMachineRules.getRules(this.engine));
            rulesBuilder.addAll(StateRules.getRules(this.engine));
            rulesBuilder.addAll(TransitionRules.getRules(this.engine));
            rulesBuilder.addAll(TriggerRules.getRules(this.engine));
            ImmutableSet rules = rulesBuilder.build();
            UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory schedulerFactory = Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)this.engine);
            this.schema = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)this.engine, (Scheduler.ISchedulerFactory)schedulerFactory);
            final PerJobFixedPriorityConflictResolver fpr = new PerJobFixedPriorityConflictResolver();
            Procedures.Procedure1<PriorityRuleSpecification<? extends BasePatternMatch>> _function = new Procedures.Procedure1<PriorityRuleSpecification<? extends BasePatternMatch>>(){

                public void apply(PriorityRuleSpecification<? extends BasePatternMatch> it) {
                    fpr.setPriority(it.getRuleSpecification(), it.getPriority());
                    CPS2DeploymentTransformationQrt.this.schema.addRule(it.getRuleSpecification());
                }
            };
            IterableExtensions.forEach((Iterable)rules, (Procedures.Procedure1)_function);
            this.schema.setConflictResolver((ConflictResolver)fpr);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Prepared transformation rules (");
            long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder_1.append((Object)_elapsed);
            _builder_1.append((Object)" ms)");
            this.logger.info((Object)_builder_1);
            this.logger.debug((Object)"Initial execution of transformation rules.");
            watch.reset().start();
            this.schema.startUnscheduledExecution();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"Initial execution of transformation rules finished (");
            long _elapsed_1 = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder_2.append((Object)_elapsed_1);
            _builder_2.append((Object)" ms)");
            this.logger.info((Object)_builder_2);
        }
    }

    public void dispose() {
        if (this.schema != null) {
            this.schema.dispose();
        }
    }
}

