/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.ConfigurationWizardElement;
import org.eclipse.team.internal.ui.wizards.ConfigureProjectWizard;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ProjectSelectionPage
extends WizardPage {
    private final IProject[] projects;
    private final ConfigurationWizardElement element;
    private Button shareButton;
    private TableViewer projectViewer;
    private AdaptableList projectList;

    protected ProjectSelectionPage(IProject[] projects, ConfigurationWizardElement element) {
        super("projectSelectionPage", NLS.bind((String)TeamUIMessages.ProjectSelectionPage_1, (Object)element.getLabel(null)), TeamUIPlugin.getImageDescriptor("wizban/share_wizban.png"));
        this.setDescription(NLS.bind((String)TeamUIMessages.ProjectSelectionPage_0, (Object)element.getLabel(null)));
        this.projects = projects;
        this.element = element;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite(parent, 1, 2);
        this.createProjectList(composite);
        this.createShareButton(composite);
        this.updateEnablements();
        this.setControl((Control)composite);
    }

    private void createProjectList(Composite composite) {
        this.projectViewer = new TableViewer(composite, 2052);
        this.projectViewer.getControl().setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.projectList = new AdaptableList((IAdaptable[])this.projects);
        this.projectViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.projectViewer.setInput((Object)this.projectList);
        this.projectViewer.getTable().select(0);
        this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionPage.this.updateEnablements();
            }
        });
    }

    private void createShareButton(Composite composite) {
        this.shareButton = new Button(composite, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        gridData.verticalAlignment = 128;
        this.shareButton.setLayoutData((Object)gridData);
        this.shareButton.setText(TeamUIMessages.ProjectSelectionPage_2);
        this.shareButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionPage.this.shareSelectedProject();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    void shareSelectedProject() {
        IProject project = this.getSelectedProject();
        if (project != null) {
            try {
                IConfigurationWizard wizard = (IConfigurationWizard)this.element.createExecutableExtension();
                wizard.init(PlatformUI.getWorkbench(), project);
                ConfigureProjectWizard.openWizard(this.getShell(), wizard);
                this.updateProjectList(project);
                this.projectList.size();
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
            }
        }
    }

    private void updateProjectList(IProject project) {
        if (RepositoryProvider.isShared((IProject)project)) {
            this.projectList.remove((IAdaptable)project);
            this.projectViewer.refresh();
            if (this.hasUnsharedProjects()) {
                this.projectViewer.getTable().select(0);
            }
            this.updateEnablements();
        }
    }

    void updateEnablements() {
        this.shareButton.setEnabled(this.getSelectedProject() != null);
    }

    private IProject getSelectedProject() {
        ISelection selection = this.projectViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return (IProject)ss.getFirstElement();
        }
        return null;
    }

    public boolean hasUnsharedProjects() {
        return this.projectList.size() > 0;
    }
}

