/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.quickfix;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.imports.OrganizeImportsHandler;
import org.eclipse.xtext.xbase.ui.quickfix.CreateJavaTypeQuickfixes;
import org.eclipse.xtext.xbase.ui.quickfix.JavaTypeQuickfixes;
import org.eclipse.xtext.xbase.ui.util.InsertionOffsets;
import org.eclipse.xtext.xbase.util.TypesOrderUtil;

public class XbaseQuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    private OrganizeImportsHandler organizeImportsHandler;
    @Inject
    protected JavaTypeQuickfixes javaTypeQuickfixes;
    @Inject
    private CreateJavaTypeQuickfixes createJavaTypeQuickfixes;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private TypesOrderUtil typesOrderUtil;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private InsertionOffsets insertionOffsets;

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.import_duplicate")
    public void fixDuplicateImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses")
    public void fixMissingParentheses(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add parentheses", "Add parentheses", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ReplacingAppendable appendable = (ReplacingAppendable)XbaseQuickfixProvider.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)element.eResource(), issue.getOffset() + issue.getLength(), 0);
                appendable.append("()");
                appendable.commitChanges();
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued")
    public void fixUnusedImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated")
    public void fixDuplicateWildcardUse(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.ambiguous_feature_call")
    public void fixAmbiguousMethodCall(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] data = issue.getData();
        if (data == null || data.length == 0) {
            return;
        }
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String replacement = stringArray[n2];
            String replaceLabel = "Change to '" + replacement + "'";
            acceptor.accept(issue, replaceLabel, replaceLabel, null, (IModification)new ReplaceModification(issue, replacement));
            ++n2;
        }
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_arguments_on_type_literal")
    public void fixTypeArguments(final Issue issue, IssueResolutionAcceptor acceptor) {
        String message = issue.getMessage();
        String fixup = "Remove invalid type arguments";
        if (message.contains("argument.")) {
            fixup = "Remove invalid type argument";
        }
        acceptor.accept(issue, fixup, fixup, null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument document = context.getXtextDocument();
                document.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast")
    public void fixObsoletCast(final Issue issue, IssueResolutionAcceptor acceptor) {
        String fixup = "Remove unnecessary cast";
        acceptor.accept(issue, fixup, fixup, null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument document = context.getXtextDocument();
                ReplaceRegion replacement = (ReplaceRegion)document.readOnly((IUnitOfWork)new IUnitOfWork<ReplaceRegion, XtextResource>(){

                    public ReplaceRegion exec(XtextResource state) throws Exception {
                        EObject type = state.getEObject(issue.getUriToProblem().fragment());
                        XCastedExpression cast = (XCastedExpression)EcoreUtil2.getContainerOfType((EObject)type, XCastedExpression.class);
                        ICompositeNode castNode = NodeModelUtils.findActualNodeFor((EObject)cast);
                        ICompositeNode targetNode = NodeModelUtils.findActualNodeFor((EObject)cast.getTarget());
                        return new ReplaceRegion(castNode.getTotalTextRegion(), targetNode.getText());
                    }
                });
                document.replace(replacement.getOffset(), replacement.getLength(), replacement.getText());
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature")
    public void fixInvisibleFeature(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length >= 1 && "subclass-context".equals(issue.getData()[0])) {
            String fixup = issue.getData().length == 1 ? "Add type cast." : "Add cast to " + issue.getData()[1] + ".";
            acceptor.accept(issue, fixup, fixup, null, new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    if (!(element instanceof XAbstractFeatureCall)) {
                        return;
                    }
                    XAbstractFeatureCall featureCall = (XAbstractFeatureCall)element;
                    if (!(featureCall.getFeature() instanceof JvmMember)) {
                        return;
                    }
                    JvmDeclaredType declaringType = ((JvmMember)featureCall.getFeature()).getDeclaringType();
                    if (featureCall instanceof XMemberFeatureCall) {
                        XbaseQuickfixProvider.this.addTypeCastToExplicitReceiver(featureCall, context, (JvmType)declaringType, XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET);
                    } else if (featureCall instanceof XAssignment) {
                        XbaseQuickfixProvider.this.addTypeCastToExplicitReceiver(featureCall, context, (JvmType)declaringType, XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE);
                    } else if (featureCall instanceof XFeatureCall) {
                        XbaseQuickfixProvider.this.addTypeCastToImplicitReceiver((XFeatureCall)featureCall, context, (JvmType)declaringType);
                    }
                }
            });
        }
    }

    private void addTypeCastToExplicitReceiver(XAbstractFeatureCall featureCall, IModificationContext context, JvmType declaringType, EReference structuralFeature) throws BadLocationException {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)featureCall, (EStructuralFeature)structuralFeature);
        if (nodes.isEmpty()) {
            return;
        }
        INode firstNode = (INode)IterableExtensions.head((Iterable)nodes);
        INode lastNode = (INode)IterableExtensions.last((Iterable)nodes);
        int offset = firstNode.getOffset();
        int length = lastNode.getEndOffset() - offset;
        ReplacingAppendable appendable = (ReplacingAppendable)this.appendableFactory.create(context.getXtextDocument(), (XtextResource)featureCall.eResource(), offset, length);
        appendable.append("(");
        ListIterator nodeIter = nodes.listIterator();
        while (nodeIter.hasNext()) {
            String text = ((INode)nodeIter.next()).getText();
            if (nodeIter.previousIndex() == 0) {
                appendable.append(Strings.removeLeadingWhitespace((String)text));
                continue;
            }
            if (nodeIter.nextIndex() == nodes.size()) {
                appendable.append(Strings.trimTrailingLineBreak((CharSequence)text));
                continue;
            }
            appendable.append(text);
        }
        appendable.append(" as ");
        appendable.append(declaringType);
        appendable.append(")");
        appendable.commitChanges();
    }

    private void addTypeCastToImplicitReceiver(XFeatureCall featureCall, IModificationContext context, JvmType declaringType) throws BadLocationException {
        if (!(featureCall.getImplicitReceiver() instanceof XAbstractFeatureCall)) {
            return;
        }
        String receiver = ((XAbstractFeatureCall)featureCall.getImplicitReceiver()).getFeature().getSimpleName();
        List nodes = NodeModelUtils.findNodesForFeature((EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        if (nodes.isEmpty()) {
            return;
        }
        INode firstNode = (INode)IterableExtensions.head((Iterable)nodes);
        int offset = firstNode.getOffset();
        ReplacingAppendable appendable = (ReplacingAppendable)this.appendableFactory.create(context.getXtextDocument(), (XtextResource)featureCall.eResource(), offset, 0);
        appendable.append("(");
        appendable.append(receiver);
        appendable.append(" as ");
        appendable.append(declaringType);
        appendable.append(").");
        appendable.commitChanges();
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.redundant_case")
    public void fixRedundantCase(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove redundant case.", "Remove redundant case.", null, (IModification)new ReplaceModification(issue, ""));
        acceptor.accept(issue, "Assign empty expression.", "Assign empty expression.", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XSwitchExpression switchExpression = (XSwitchExpression)EcoreUtil2.getContainerOfType((EObject)element, XSwitchExpression.class);
                if (switchExpression == null) {
                    return;
                }
                XCasePart casePart = (XCasePart)IterableExtensions.last((Iterable)switchExpression.getCases());
                if (casePart == null || !casePart.isFallThrough() || casePart.getThen() != null) {
                    return;
                }
                List nodes = NodeModelUtils.findNodesForFeature((EObject)casePart, (EStructuralFeature)XbasePackage.Literals.XCASE_PART__FALL_THROUGH);
                if (nodes.isEmpty()) {
                    return;
                }
                INode firstNode = (INode)IterableExtensions.head((Iterable)nodes);
                INode lastNode = (INode)IterableExtensions.last((Iterable)nodes);
                int offset = firstNode.getOffset();
                int length = lastNode.getEndOffset() - offset;
                ReplacingAppendable appendable = (ReplacingAppendable)XbaseQuickfixProvider.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)element.eResource(), offset, length);
                appendable.append(": {");
                appendable.increaseIndentation().newLine();
                appendable.decreaseIndentation().newLine().append((CharSequence)"}");
                appendable.commitChanges();
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.incomplete_cases_on_enum")
    public void fixIncompleteCasesOnEnum(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add 'default' case", "Add 'default' case", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XSwitchExpression switchExpression = (XSwitchExpression)EcoreUtil2.getContainerOfType((EObject)element, XSwitchExpression.class);
                if (switchExpression == null) {
                    return;
                }
                int insertOffset = XbaseQuickfixProvider.this.getInsertOffset(switchExpression);
                IXtextDocument document = context.getXtextDocument();
                ReplacingAppendable appendable = (ReplacingAppendable)XbaseQuickfixProvider.this.appendableFactory.create(document, (XtextResource)element.eResource(), insertOffset, 0);
                if (switchExpression.getCases().isEmpty()) {
                    appendable.increaseIndentation();
                }
                appendable.newLine();
                appendable.append("default: {");
                appendable.newLine().append((CharSequence)"}");
                appendable.commitChanges();
            }
        });
        acceptor.accept(issue, "Add missing cases", "Add missing cases", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XSwitchExpression switchExpression = (XSwitchExpression)EcoreUtil2.getContainerOfType((EObject)element, XSwitchExpression.class);
                if (switchExpression == null) {
                    return;
                }
                int insertOffset = XbaseQuickfixProvider.this.getInsertOffset(switchExpression);
                IXtextDocument document = context.getXtextDocument();
                ReplacingAppendable appendable = (ReplacingAppendable)XbaseQuickfixProvider.this.appendableFactory.create(document, (XtextResource)element.eResource(), insertOffset, 0);
                if (switchExpression.getCases().isEmpty()) {
                    appendable.increaseIndentation();
                }
                String[] stringArray = issue.getData();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String expectedEnumerationLiteral = stringArray[n2];
                    appendable.newLine().append((CharSequence)"case ").append((CharSequence)expectedEnumerationLiteral).append((CharSequence)": {");
                    appendable.newLine().append((CharSequence)"}");
                    ++n2;
                }
                appendable.commitChanges();
            }
        });
    }

    private int getInsertOffset(XSwitchExpression switchExpression) {
        EList cases = switchExpression.getCases();
        if (cases.isEmpty()) {
            return this.insertionOffsets.inEmpty((EObject)switchExpression);
        }
        XCasePart casePart = (XCasePart)IterableExtensions.last((Iterable)cases);
        return this.insertionOffsets.after((EObject)casePart);
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case")
    public void fixUnreachableCase(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove case", "Remove case", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XbaseQuickfixProvider.this.remove(element, XCasePart.class, context);
            }
        });
        acceptor.accept(issue, "Move case up", "Move case up", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XCasePart casePart = (XCasePart)EcoreUtil2.getContainerOfType((EObject)element, XCasePart.class);
                if (casePart == null) {
                    return;
                }
                ICompositeNode caseNode = NodeModelUtils.findActualNodeFor((EObject)casePart);
                if (caseNode == null) {
                    return;
                }
                XSwitchExpression switchExpression = (XSwitchExpression)EcoreUtil2.getContainerOfType((EObject)casePart, XSwitchExpression.class);
                if (switchExpression == null) {
                    return;
                }
                StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(XbaseQuickfixProvider.this.services, (EObject)switchExpression);
                LightweightTypeReference actualTypeReference = owner.toLightweightTypeReference(casePart.getTypeGuard());
                for (XCasePart previousCasePart : switchExpression.getCases()) {
                    if (previousCasePart == casePart) {
                        return;
                    }
                    JvmTypeReference typeGuard = previousCasePart.getTypeGuard();
                    if (typeGuard == null || previousCasePart.getCase() != null) continue;
                    LightweightTypeReference previousTypeReference = owner.toLightweightTypeReference(typeGuard);
                    if (!XbaseQuickfixProvider.this.typesOrderUtil.isHandled(actualTypeReference, previousTypeReference)) continue;
                    ICompositeNode previousCaseNode = NodeModelUtils.findActualNodeFor((EObject)previousCasePart);
                    if (previousCaseNode == null) {
                        return;
                    }
                    XbaseQuickfixProvider.this.moveUp(caseNode, previousCaseNode, context);
                    return;
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_catch_block")
    public void fixUnreachableCatchBlock(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove catch block", "Remove catch block", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XbaseQuickfixProvider.this.remove(element, XCatchClause.class, context);
            }
        });
        acceptor.accept(issue, "Move catch block up", "Move catch block up", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XCatchClause catchClause = (XCatchClause)EcoreUtil2.getContainerOfType((EObject)element, XCatchClause.class);
                if (catchClause == null) {
                    return;
                }
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)catchClause);
                if (node == null) {
                    return;
                }
                XTryCatchFinallyExpression tryCatchFinallyExpression = (XTryCatchFinallyExpression)EcoreUtil2.getContainerOfType((EObject)catchClause, XTryCatchFinallyExpression.class);
                if (tryCatchFinallyExpression == null) {
                    return;
                }
                StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(XbaseQuickfixProvider.this.services, (EObject)tryCatchFinallyExpression);
                LightweightTypeReference actualTypeReference = owner.toLightweightTypeReference(catchClause.getDeclaredParam().getParameterType());
                for (XCatchClause previousCatchClause : tryCatchFinallyExpression.getCatchClauses()) {
                    if (previousCatchClause == catchClause) {
                        return;
                    }
                    LightweightTypeReference previousTypeReference = owner.toLightweightTypeReference(previousCatchClause.getDeclaredParam().getParameterType());
                    if (!XbaseQuickfixProvider.this.typesOrderUtil.isHandled(actualTypeReference, previousTypeReference)) continue;
                    ICompositeNode previousNode = NodeModelUtils.findActualNodeFor((EObject)previousCatchClause);
                    if (previousNode == null) {
                        return;
                    }
                    XbaseQuickfixProvider.this.moveUp(node, previousNode, context);
                    return;
                }
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of")
    public void fixUnreachableIfBlock(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove if block", "Remove if block", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XIfExpression ifExpression = (XIfExpression)EcoreUtil2.getContainerOfType((EObject)element, XIfExpression.class);
                if (ifExpression == null) {
                    return;
                }
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)ifExpression);
                if (node == null) {
                    return;
                }
                int[] offsetAndLength = XbaseQuickfixProvider.this.getOffsetAndLength(ifExpression, node);
                context.getXtextDocument().replace(offsetAndLength[0], offsetAndLength[1], "");
            }
        });
        acceptor.accept(issue, "Move if block up", "Move if block up", null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                XIfExpression ifExpression = (XIfExpression)EcoreUtil2.getContainerOfType((EObject)element, XIfExpression.class);
                if (ifExpression == null) {
                    return;
                }
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)ifExpression);
                if (node == null) {
                    return;
                }
                XIfExpression firstIfExpression = this.getFirstIfExpression(ifExpression);
                if (firstIfExpression == null) {
                    return;
                }
                XInstanceOfExpression actualIfPart = (XInstanceOfExpression)ifExpression.getIf();
                XAbstractFeatureCall actualFeatureCall = (XAbstractFeatureCall)actualIfPart.getExpression();
                JvmIdentifiableElement actualFeature = actualFeatureCall.getFeature();
                StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(XbaseQuickfixProvider.this.services, (EObject)firstIfExpression);
                LightweightTypeReference actualTypeReference = owner.toLightweightTypeReference(actualIfPart.getType());
                List<XExpression> ifParts = this.collectIfParts(firstIfExpression, new ArrayList<XExpression>());
                for (XExpression previousIfPart : ifParts) {
                    XAbstractFeatureCall previousFeatureCall;
                    XInstanceOfExpression instanceOfExpression;
                    if (actualIfPart == previousIfPart) {
                        return;
                    }
                    if (!(previousIfPart instanceof XInstanceOfExpression) || !((instanceOfExpression = (XInstanceOfExpression)previousIfPart).getExpression() instanceof XAbstractFeatureCall) || (previousFeatureCall = (XAbstractFeatureCall)instanceOfExpression.getExpression()).getFeature() != actualFeature) continue;
                    LightweightTypeReference previousTypeReference = owner.toLightweightTypeReference(instanceOfExpression.getType());
                    if (!XbaseQuickfixProvider.this.typesOrderUtil.isHandled(actualTypeReference, previousTypeReference)) continue;
                    ICompositeNode previousNode = NodeModelUtils.findActualNodeFor((EObject)instanceOfExpression.eContainer());
                    if (previousNode == null) {
                        return;
                    }
                    int[] offsetAndLength = XbaseQuickfixProvider.this.getOffsetAndLength(ifExpression, node);
                    int offset = offsetAndLength[0];
                    int length = offsetAndLength[1];
                    int endOffset = offset + length;
                    String text = node.getRootNode().getText().substring(offset, endOffset).trim();
                    if (text.startsWith("else")) {
                        text = text.substring("else".length()).trim();
                    }
                    text = !text.endsWith("else") ? String.valueOf(text) + " else " : String.valueOf(text) + " ";
                    IXtextDocument document = context.getXtextDocument();
                    document.replace(offset, length, "");
                    document.replace(previousNode.getOffset(), 0, text);
                    return;
                }
            }

            private XIfExpression getFirstIfExpression(XIfExpression ifExpression) {
                XIfExpression parentIfExpression;
                EObject container = ifExpression.eContainer();
                if (container instanceof XIfExpression && (parentIfExpression = (XIfExpression)container).getElse() == ifExpression) {
                    return this.getFirstIfExpression(parentIfExpression);
                }
                return ifExpression;
            }

            private List<XExpression> collectIfParts(XIfExpression expression, List<XExpression> result) {
                result.add(expression.getIf());
                if (expression.getElse() instanceof XIfExpression) {
                    this.collectIfParts((XIfExpression)expression.getElse(), result);
                }
                return result;
            }
        });
    }

    protected int[] getOffsetAndLength(XIfExpression ifExpression, ICompositeNode node) {
        int offset = node.getOffset();
        int length = node.getLength();
        if (ifExpression.getElse() != null) {
            ICompositeNode elseNode = NodeModelUtils.findActualNodeFor((EObject)ifExpression.getElse());
            if (elseNode != null) {
                length = elseNode.getOffset() - offset;
            }
        } else {
            ICompositeNode thenNode;
            XIfExpression parentIfExpression = (XIfExpression)EcoreUtil2.getContainerOfType((EObject)ifExpression.eContainer(), XIfExpression.class);
            if (parentIfExpression != null && parentIfExpression.getElse() == ifExpression && (thenNode = NodeModelUtils.findActualNodeFor((EObject)parentIfExpression.getThen())) != null) {
                int endOffset = thenNode.getEndOffset();
                length += offset - endOffset;
                offset = endOffset;
            }
        }
        return new int[]{offset, length};
    }

    protected void moveUp(ICompositeNode node, ICompositeNode previousNode, IModificationContext context) throws BadLocationException {
        IXtextDocument document = context.getXtextDocument();
        String text = String.valueOf(node.getText()) + previousNode.getText();
        text = text.trim();
        this.remove(document, node);
        document.replace(previousNode.getOffset(), previousNode.getLength(), text);
    }

    protected <T extends EObject> void remove(EObject element, Class<T> type, IModificationContext context) throws BadLocationException {
        EObject container = EcoreUtil2.getContainerOfType((EObject)element, type);
        if (container == null) {
            return;
        }
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)container);
        if (node == null) {
            return;
        }
        this.remove(context.getXtextDocument(), node);
    }

    protected void remove(IXtextDocument document, ICompositeNode node) throws BadLocationException {
        int offset = node.getOffset();
        int length = node.getLength();
        if (node.hasPreviousSibling()) {
            INode previousSibling = node.getPreviousSibling();
            int endOffset = previousSibling.getEndOffset();
            length += offset - endOffset;
            offset = endOffset;
        }
        document.replace(offset, length, "");
    }

    protected void organizeImports(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Organize imports", "Organizes the whole import section. Removes wildcard imports as well as duplicates and unused ones.", this.getOrganizeImportsImage(), new IModification(){

            public void apply(IModificationContext context) throws Exception {
                XbaseQuickfixProvider.this.organizeImportsHandler.doOrganizeImports(context.getXtextDocument());
            }
        });
    }

    protected String getOrganizeImportsImage() {
        return "impc_obj.gif";
    }

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument != null) {
            xtextDocument.readOnly((IUnitOfWork)new CancelableUnitOfWork<Void, XtextResource>(){

                public Void exec(XtextResource state, CancelIndicator cancelIndicator) throws Exception {
                    try {
                        EObject target = state.getEObject(issue.getUriToProblem().fragment());
                        EReference reference = XbaseQuickfixProvider.this.getUnresolvedEReference(issue, target);
                        if (reference != null && reference.getEReferenceType() != null) {
                            XbaseQuickfixProvider.this.createLinkingIssueQuickfixes(issue, XbaseQuickfixProvider.this.getCancelableAcceptor(issueResolutionAcceptor, cancelIndicator), xtextDocument, state, target, reference);
                        }
                    }
                    catch (WrappedException wrappedException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    protected void createLinkingIssueQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource state, EObject target, EReference reference) throws Exception {
        this.javaTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, state, target, reference);
        this.createJavaTypeQuickfixes.addQuickfixes(issue, issueResolutionAcceptor, xtextDocument, state, target, reference);
    }

    protected EReference getUnresolvedEReference(Issue issue, EObject target) {
        EReference unresolvedEReference = super.getUnresolvedEReference(issue, target);
        if (unresolvedEReference == null && target instanceof XConstructorCall) {
            return XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
        }
        return unresolvedEReference;
    }
}

