/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.prefs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static void migratePreferences() {
        IEclipsePreferences pref = new ProfileScope(PreferenceInitializer.getDefaultAgentLocation(), "_SELF_").getNode("org.eclipse.equinox.p2.ui.sdk");
        try {
            if (pref.keys().length == 0) {
                IEclipsePreferences oldPref = InstanceScope.INSTANCE.getNode("org.eclipse.equinox.p2.ui.sdk");
                pref.put("allowNonOKPlan", oldPref.get("allowNonOKPlan", "prompt"));
                String showLatestVersionString = oldPref.get("showLatestVersion", null);
                if (showLatestVersionString != null) {
                    pref.putBoolean("showLatestVersion", Boolean.TRUE.toString().equalsIgnoreCase(showLatestVersionString));
                }
                pref.flush();
            }
        }
        catch (BackingStoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk", 0, ProvSDKMessages.PreferenceInitializer_Error, (Throwable)e), 1);
        }
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.equinox.p2.ui.sdk");
        node.putBoolean("showLatestVersion", true);
        node.put("allowNonOKPlan", "prompt");
    }

    private static IAgentLocation getDefaultAgentLocation() {
        ServiceReference reference = ProvSDKUIActivator.getContext().getServiceReference(IAgentLocation.class);
        if (reference == null) {
            return null;
        }
        IAgentLocation result = (IAgentLocation)ProvSDKUIActivator.getContext().getService(reference);
        ProvSDKUIActivator.getContext().ungetService(reference);
        return result;
    }
}

