/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.base.Objects;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ParallelFileSystemAccess
implements IFileSystemAccess2 {
    private final IFileSystemAccess2 delegate;
    private final IResourceDescription.Delta delta;
    private final FileSystemAccessQueue fileSystemAccessQueue;
    private final String sourceFolder;
    private final EclipseResourceFileSystemAccess2.IFileCallback fileCallback;

    @FinalFieldsConstructor
    public ParallelFileSystemAccess(IFileSystemAccess2 delegate, IResourceDescription.Delta delta, FileSystemAccessQueue fileSystemAccessQueue, String sourceFolder, EclipseResourceFileSystemAccess2.IFileCallback fileCallback) {
        this.delegate = delegate;
        this.delta = delta;
        this.fileSystemAccessQueue = fileSystemAccessQueue;
        this.sourceFolder = sourceFolder;
        this.fileCallback = fileCallback;
    }

    protected void sendAsync(final Procedures.Procedure1<? super IFileSystemAccess2> procedure) {
        URI _uri = this.delta.getUri();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                boolean _notEquals;
                if (ParallelFileSystemAccess.this.delegate instanceof EclipseResourceFileSystemAccess2) {
                    ((EclipseResourceFileSystemAccess2)ParallelFileSystemAccess.this.delegate).setPostProcessor(ParallelFileSystemAccess.this.fileCallback);
                }
                boolean bl = _notEquals = !Objects.equal((Object)ParallelFileSystemAccess.this.sourceFolder, null);
                if (_notEquals && ParallelFileSystemAccess.this.delegate instanceof AbstractFileSystemAccess) {
                    ((AbstractFileSystemAccess)ParallelFileSystemAccess.this.delegate).setCurrentSource(ParallelFileSystemAccess.this.sourceFolder);
                }
                procedure.apply((Object)ParallelFileSystemAccess.this.delegate);
            }
        };
        this.fileSystemAccessQueue.sendAsync(_uri, _function);
    }

    public void deleteFile(final String fileName) {
        Procedures.Procedure1<IFileSystemAccess2> _function = new Procedures.Procedure1<IFileSystemAccess2>(){

            public void apply(IFileSystemAccess2 it) {
                it.deleteFile(fileName);
            }
        };
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void generateFile(final String fileName, final CharSequence contents) {
        Procedures.Procedure1<IFileSystemAccess2> _function = new Procedures.Procedure1<IFileSystemAccess2>(){

            public void apply(IFileSystemAccess2 it) {
                it.generateFile(fileName, contents);
            }
        };
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void generateFile(final String fileName, final String outputConfigurationName, final CharSequence contents) {
        Procedures.Procedure1<IFileSystemAccess2> _function = new Procedures.Procedure1<IFileSystemAccess2>(){

            public void apply(IFileSystemAccess2 it) {
                it.generateFile(fileName, outputConfigurationName, contents);
            }
        };
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void deleteFile(final String fileName, final String outputConfigurationName) {
        Procedures.Procedure1<IFileSystemAccess2> _function = new Procedures.Procedure1<IFileSystemAccess2>(){

            public void apply(IFileSystemAccess2 it) {
                it.deleteFile(fileName, outputConfigurationName);
            }
        };
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public URI getURI(String path, String outputConfiguration) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, outputConfiguration, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.getURI(path, outputConfiguration);
    }

    public URI getURI(String path) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.getURI(path);
    }

    public void generateFile(final String fileName, final String outputCfgName, final InputStream content) throws RuntimeIOException {
        Procedures.Procedure1<IFileSystemAccess2> _function = new Procedures.Procedure1<IFileSystemAccess2>(){

            public void apply(IFileSystemAccess2 it) {
                it.generateFile(fileName, outputCfgName, content);
            }
        };
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public void generateFile(final String fileName, final InputStream content) throws RuntimeIOException {
        Procedures.Procedure1<IFileSystemAccess2> _function = new Procedures.Procedure1<IFileSystemAccess2>(){

            public void apply(IFileSystemAccess2 it) {
                it.generateFile(fileName, content);
            }
        };
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)_function);
    }

    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, outputCfgName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readBinaryFile(fileName, outputCfgName);
    }

    public InputStream readBinaryFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readBinaryFile(fileName);
    }

    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, outputCfgName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readTextFile(fileName, outputCfgName);
    }

    public CharSequence readTextFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.readTextFile(fileName);
    }

    public boolean isFile(String path, String outputConfigurationName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).isFile(path, outputConfigurationName, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.isFile(path, outputConfigurationName);
    }

    public boolean isFile(String path) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).isFile(path, (IProgressMonitor)_nullProgressMonitor);
        }
        return this.delegate.isFile(path);
    }
}

