/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Set;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MonitoredStateMachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.AbstractRule;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StateMachineUpdate
extends AbstractRule<MonitoredStateMachineMatch> {
    public StateMachineUpdate(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public RuleSpecification<MonitoredStateMachineMatch> getSpecification() {
        try {
            Job<MonitoredStateMachineMatch> _appearedJob = this.getAppearedJob();
            Job<MonitoredStateMachineMatch> _disappearedJob = this.getDisappearedJob();
            Job<MonitoredStateMachineMatch> _updatedJob = this.getUpdatedJob();
            return Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getMonitoredStateMachine(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _disappearedJob, _updatedJob})));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Job<MonitoredStateMachineMatch> getAppearedJob() {
        IMatchProcessor<MonitoredStateMachineMatch> _function = new IMatchProcessor<MonitoredStateMachineMatch>(){

            public void process(MonitoredStateMachineMatch match) {
                String smId = match.getStateMachine().getIdentifier();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Starting monitoring mapped state machine with ID: ");
                _builder.append((Object)smId);
                StateMachineUpdate.this.logger.debug((Object)_builder);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<MonitoredStateMachineMatch> getDisappearedJob() {
        IMatchProcessor<MonitoredStateMachineMatch> _function = new IMatchProcessor<MonitoredStateMachineMatch>(){

            public void process(MonitoredStateMachineMatch match) {
                String smId = match.getStateMachine().getIdentifier();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Stopped monitoring mapped state machine with ID: ");
                _builder.append((Object)smId);
                StateMachineUpdate.this.logger.debug((Object)_builder);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }

    private Job<MonitoredStateMachineMatch> getUpdatedJob() {
        IMatchProcessor<MonitoredStateMachineMatch> _function = new IMatchProcessor<MonitoredStateMachineMatch>(){

            public void process(MonitoredStateMachineMatch match) {
                try {
                    final String smId = match.getStateMachine().getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Updating mapped state machine with ID: ");
                    _builder.append((Object)smId);
                    StateMachineUpdate.this.logger.debug((Object)_builder);
                    Set<DeploymentBehavior> depSMs = StateMachineUpdate.this.cpsXformM2M.getMappedStateMachine(StateMachineUpdate.this.engine).getAllValuesOfdepBehavior(match.getStateMachine(), null, null);
                    Procedures.Procedure1<DeploymentBehavior> _function = new Procedures.Procedure1<DeploymentBehavior>(){

                        public void apply(DeploymentBehavior it) {
                            boolean _notEquals;
                            String _description = it.getDescription();
                            boolean bl = _notEquals = !Objects.equal((Object)_description, (Object)smId);
                            if (_notEquals) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"ID changed to ");
                                _builder.append((Object)smId);
                                (this).StateMachineUpdate.this.logger.trace((Object)_builder);
                                it.setDescription(smId);
                            }
                        }
                    };
                    IterableExtensions.forEach(depSMs, (Procedures.Procedure1)_function);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"Updated mapped state machine with ID: ");
                    _builder_1.append((Object)smId);
                    StateMachineUpdate.this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }
}

