/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.phases;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.generator.dtos.AppClass;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.operations.ActionGenerationOperation;
import org.eclipse.viatra.examples.cps.generator.queries.ReachableAppTypesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.TransitionsMatcher;
import org.eclipse.viatra.examples.cps.generator.utils.RandomUtils;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPhase;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CPSPhaseActionGeneration
implements IPhase<CPSFragment> {
    @Extension
    private RandomUtils randUtil = new RandomUtils();
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.generator.impl.CPSPhaseActionGeneration");
    public static String WAIT_METHOD_NAME = "waitForSignal";
    public static String SEND_METHOD_NAME = "sendSignal";

    public Iterable<IOperation<CPSFragment>> getOperations(CPSFragment fragment) {
        try {
            ArrayList operations = Lists.newArrayList();
            Set _keySet = fragment.getApplicationTypes().keySet();
            for (AppClass appClass : _keySet) {
                boolean _notEquals;
                Collection appTypes = fragment.getApplicationTypes().get((Object)appClass);
                boolean bl = _notEquals = !Objects.equal((Object)appTypes, null);
                if (!_notEquals) continue;
                for (ApplicationType appType : appTypes) {
                    Set<Transition> _transitionsOf = this.getTransitionsOf(appType, fragment);
                    for (Transition transition : _transitionsOf) {
                        boolean _randBooleanWithPercentageOfTrue = this.randUtil.randBooleanWithPercentageOfTrue(appClass.getProbabilityOfActionGeneration(), fragment.getRandom());
                        if (!_randBooleanWithPercentageOfTrue) continue;
                        boolean _randBooleanWithPercentageOfTrue_1 = this.randUtil.randBooleanWithPercentageOfTrue(appClass.getProbabilityOfSendAction(), fragment.getRandom());
                        if (_randBooleanWithPercentageOfTrue_1) {
                            boolean _notEquals_1;
                            boolean _not;
                            int signalNumber = this.randUtil.randIntOneToMax(fragment.getNumberOfSignals(), fragment.getRandom());
                            List possibleTypeList = IterableExtensions.toList(this.getPossibleAppTypesOf(appType, fragment));
                            possibleTypeList.remove(appType);
                            boolean _isEmpty = possibleTypeList.isEmpty();
                            boolean bl2 = _not = !_isEmpty;
                            if (!_not) continue;
                            ApplicationType targetAppType = (ApplicationType)this.randUtil.randElement(possibleTypeList, fragment.getRandom());
                            boolean bl3 = _notEquals_1 = !Objects.equal((Object)targetAppType, null);
                            if (_notEquals_1) {
                                String _identifier = targetAppType.getIdentifier();
                                String _plus = String.valueOf(SEND_METHOD_NAME) + "(" + _identifier;
                                String _plus_1 = String.valueOf(_plus) + ", ";
                                String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(signalNumber);
                                String action = String.valueOf(_plus_2) + ")";
                                this.logger.debug((Object)action);
                                ActionGenerationOperation _actionGenerationOperation = new ActionGenerationOperation(action, transition);
                                operations.add(_actionGenerationOperation);
                                continue;
                            }
                            String _identifier_1 = appType.getIdentifier();
                            String _plus_3 = "#Warning: Cannot find target application type for Action of " + _identifier_1;
                            this.logger.debug((Object)_plus_3);
                            continue;
                        }
                        int signalNumber_1 = this.randUtil.randIntOneToMax(fragment.getNumberOfSignals(), fragment.getRandom());
                        String action_1 = String.valueOf(WAIT_METHOD_NAME) + "(" + Integer.valueOf(signalNumber_1) + ")";
                        this.logger.debug((Object)action_1);
                        ActionGenerationOperation _actionGenerationOperation_1 = new ActionGenerationOperation(action_1, transition);
                        operations.add(_actionGenerationOperation_1);
                    }
                }
            }
            return operations;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<Transition> getTransitionsOf(ApplicationType type, CPSFragment fragment) {
        try {
            return TransitionsMatcher.on((ViatraQueryEngine)fragment.getEngine()).getAllValuesOft(type.getBehavior());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<ApplicationType> getPossibleAppTypesOf(ApplicationType type, CPSFragment fragment) {
        try {
            return ReachableAppTypesMatcher.on((ViatraQueryEngine)fragment.getEngine()).getAllValuesOfTo(type);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

