/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.util.CompilationUnitSorter;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class SortMembersOperation
implements IWorkspaceRunnable {
    private ICompilationUnit fCompilationUnit;
    private int[] fPositions;
    private final boolean fDoNotSortFields;

    public SortMembersOperation(ICompilationUnit cu, int[] positions, boolean doNotSortFields) {
        this.fCompilationUnit = cu;
        this.fPositions = positions;
        this.fDoNotSortFields = doNotSortFields;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        CompilationUnitSorter.sort((int)8, (ICompilationUnit)this.fCompilationUnit, (int[])this.fPositions, (Comparator)new DefaultJavaElementComparator(this.fDoNotSortFields), (int)0, (IProgressMonitor)monitor);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static class DefaultJavaElementComparator
    implements Comparator<BodyDeclaration> {
        private final Collator fCollator;
        private final MembersOrderPreferenceCache fMemberOrderCache;
        private final boolean fDoNotSortFields;

        public DefaultJavaElementComparator(boolean doNotSortFields) {
            this.fDoNotSortFields = doNotSortFields;
            this.fCollator = Collator.getInstance();
            this.fMemberOrderCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
        }

        private int category(BodyDeclaration bodyDeclaration) {
            switch (bodyDeclaration.getNodeType()) {
                case 31: {
                    MethodDeclaration method = (MethodDeclaration)bodyDeclaration;
                    if (method.isConstructor()) {
                        return 1;
                    }
                    int flags = method.getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return 7;
                    }
                    return 2;
                }
                case 23: {
                    if (JdtFlags.isStatic((BodyDeclaration)bodyDeclaration)) {
                        return 5;
                    }
                    return 3;
                }
                case 28: {
                    int flags = ((Initializer)bodyDeclaration).getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return 6;
                    }
                    return 4;
                }
                case 55: 
                case 71: 
                case 81: {
                    return 0;
                }
                case 72: {
                    return 8;
                }
                case 82: {
                    return 2;
                }
            }
            return 0;
        }

        private int getCategoryIndex(int category) {
            return this.fMemberOrderCache.getCategoryIndex(category);
        }

        @Override
        public int compare(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2) {
            int vis;
            boolean preserved1 = this.fDoNotSortFields && this.isSortPreserved(bodyDeclaration1);
            boolean preserved2 = this.fDoNotSortFields && this.isSortPreserved(bodyDeclaration2);
            int cat1 = this.category(bodyDeclaration1);
            if (preserved1) {
                cat1 = DefaultJavaElementComparator.sortPreservedCategory(cat1);
            }
            int cat2 = this.category(bodyDeclaration2);
            if (preserved2) {
                cat2 = DefaultJavaElementComparator.sortPreservedCategory(cat2);
            }
            if (cat1 != cat2) {
                return this.getCategoryIndex(cat1) - this.getCategoryIndex(cat2);
            }
            if (preserved1) {
                return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
            }
            if (this.fMemberOrderCache.isSortByVisibility()) {
                int flags1 = JdtFlags.getVisibilityCode((BodyDeclaration)bodyDeclaration1);
                int flags2 = JdtFlags.getVisibilityCode((BodyDeclaration)bodyDeclaration2);
                vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
                if (vis != 0) {
                    return vis;
                }
            }
            switch (bodyDeclaration1.getNodeType()) {
                case 31: {
                    String name2;
                    MethodDeclaration method1 = (MethodDeclaration)bodyDeclaration1;
                    MethodDeclaration method2 = (MethodDeclaration)bodyDeclaration2;
                    if (this.fMemberOrderCache.isSortByVisibility() && (vis = this.fMemberOrderCache.getVisibilityIndex(method1.getModifiers()) - this.fMemberOrderCache.getVisibilityIndex(method2.getModifiers())) != 0) {
                        return vis;
                    }
                    String name1 = method1.getName().getIdentifier();
                    int cmp = this.fCollator.compare(name1, name2 = method2.getName().getIdentifier());
                    if (cmp != 0) {
                        return cmp;
                    }
                    List parameters1 = method1.parameters();
                    List parameters2 = method2.parameters();
                    int length1 = parameters1.size();
                    int length2 = parameters2.size();
                    int len = Math.min(length1, length2);
                    int i = 0;
                    while (i < len) {
                        SingleVariableDeclaration param1 = (SingleVariableDeclaration)parameters1.get(i);
                        SingleVariableDeclaration param2 = (SingleVariableDeclaration)parameters2.get(i);
                        cmp = this.fCollator.compare(this.buildSignature(param1.getType()), this.buildSignature(param2.getType()));
                        if (cmp != 0) {
                            return cmp;
                        }
                        ++i;
                    }
                    if (length1 != length2) {
                        return length1 - length2;
                    }
                    return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
                }
                case 23: {
                    FieldDeclaration field1 = (FieldDeclaration)bodyDeclaration1;
                    FieldDeclaration field2 = (FieldDeclaration)bodyDeclaration2;
                    String name1 = ((VariableDeclarationFragment)field1.fragments().get(0)).getName().getIdentifier();
                    String name2 = ((VariableDeclarationFragment)field2.fragments().get(0)).getName().getIdentifier();
                    return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                }
                case 28: {
                    return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
                }
                case 55: 
                case 71: 
                case 81: {
                    AbstractTypeDeclaration type1 = (AbstractTypeDeclaration)bodyDeclaration1;
                    AbstractTypeDeclaration type2 = (AbstractTypeDeclaration)bodyDeclaration2;
                    String name1 = type1.getName().getIdentifier();
                    String name2 = type2.getName().getIdentifier();
                    return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                }
                case 72: {
                    EnumConstantDeclaration decl1 = (EnumConstantDeclaration)bodyDeclaration1;
                    EnumConstantDeclaration decl2 = (EnumConstantDeclaration)bodyDeclaration2;
                    String name1 = decl1.getName().getIdentifier();
                    String name2 = decl2.getName().getIdentifier();
                    return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                }
                case 82: {
                    AnnotationTypeMemberDeclaration decl1 = (AnnotationTypeMemberDeclaration)bodyDeclaration1;
                    AnnotationTypeMemberDeclaration decl2 = (AnnotationTypeMemberDeclaration)bodyDeclaration2;
                    String name1 = decl1.getName().getIdentifier();
                    String name2 = decl2.getName().getIdentifier();
                    return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                }
            }
            return 0;
        }

        private static int sortPreservedCategory(int category) {
            switch (category) {
                case 5: 
                case 6: {
                    return 5;
                }
                case 3: 
                case 4: {
                    return 3;
                }
            }
            return category;
        }

        private boolean isSortPreserved(BodyDeclaration bodyDeclaration) {
            switch (bodyDeclaration.getNodeType()) {
                case 23: 
                case 28: 
                case 72: {
                    return true;
                }
            }
            return false;
        }

        private int preserveRelativeOrder(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2) {
            int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
            int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
            return value1 - value2;
        }

        private int compareNames(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2, String name1, String name2) {
            int cmp = this.fCollator.compare(name1, name2);
            if (cmp != 0) {
                return cmp;
            }
            return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
        }

        private String buildSignature(Type type) {
            return ASTNodes.asString((ASTNode)type);
        }
    }
}

