/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.CallOperationHelper;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class BinaryTransitiveClosureCheck
extends CheckOperation {
    private final CallOperationHelper helper;
    private CallOperationHelper.PatternCall call;
    private final int sourcePosition;
    private final int targetPosition;

    public BinaryTransitiveClosureCheck(MatcherReference calledQuery, int sourcePosition, int targetPosition) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.helper = new CallOperationHelper(calledQuery, (Map<PParameter, Integer>)ImmutableMap.of((Object)((PParameter)calledQuery.getQuery().getParameters().get(0)), (Object)sourcePosition, (Object)((PParameter)calledQuery.getQuery().getParameters().get(1)), (Object)targetPosition));
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        super.onInitialize(frame, context);
        this.call = this.helper.createCall(context);
    }

    @Deprecated
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        return this.check(frame, null);
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        Object targetValue = frame.get(this.targetPosition);
        LinkedList<Object> sourcesToEvaluate = new LinkedList<Object>();
        sourcesToEvaluate.add(frame.get(this.sourcePosition));
        HashSet sourceEvaluated = new HashSet();
        while (!sourcesToEvaluate.isEmpty()) {
            Object currentValue = sourcesToEvaluate.poll();
            sourceEvaluated.add(currentValue);
            Object[] objectArray = new Object[2];
            objectArray[0] = currentValue;
            Object[] mappedFrame = objectArray;
            for (Tuple tuple : this.call.getAllMatches(mappedFrame)) {
                Object foundTarget = tuple.get(1);
                if (targetValue.equals(foundTarget)) {
                    return true;
                }
                if (sourceEvaluated.contains(foundTarget)) continue;
                sourcesToEvaluate.add(foundTarget);
            }
        }
        return false;
    }

    public String toString() {
        String c = this.helper.toString();
        int p = c.indexOf(40);
        return "check     find " + c.substring(0, p) + "+" + c.substring(p);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.sourcePosition, (Object)this.targetPosition, (Object[])new Integer[0]);
    }
}

