/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.generic;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class GenericTypeExtend
implements ISearchOperation,
IIteratingSearchOperation {
    private final IInputKey type;
    private final Integer[] positions;
    private final Set<Integer> unboundVariableIndex;
    private Iterator<Tuple> it;

    public GenericTypeExtend(IInputKey type, Integer[] positions, Set<Integer> adornment) {
        Preconditions.checkArgument((positions.length == type.getArity() ? 1 : 0) != 0, (String)"The type %s requires %s parameters, but %s positions are provided", (Object[])new Object[]{type.getPrettyPrintableName(), type.getArity(), positions.length});
        this.positions = positions;
        this.type = type;
        this.unboundVariableIndex = new HashSet<Integer>();
        Integer[] integerArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer position = integerArray[n2];
            if (!adornment.contains(position)) {
                this.unboundVariableIndex.add(position);
            }
            ++n2;
        }
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    @Override
    public void onBacktrack(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        for (Integer position : this.unboundVariableIndex) {
            frame.setValue(position, null);
        }
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        Object[] seed = new Object[this.positions.length];
        int i = 0;
        while (i < this.positions.length) {
            seed[i] = frame.get(this.positions[i]);
            ++i;
        }
        this.it = context.getRuntimeContext().enumerateTuples(this.type, Tuples.flatTupleOf((Object[])seed)).iterator();
    }

    @Override
    public boolean execute(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        if (this.it.hasNext()) {
            Tuple next = this.it.next();
            int i = 0;
            while (i < this.positions.length) {
                frame.setValue(this.positions[i], next.get(i));
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.positions);
    }

    public String toString() {
        Iterator parameterNames = Iterators.transform((Iterator)Iterators.forArray((Object[])this.positions), (Function)new Function<Integer, String>(){

            public String apply(Integer input) {
                return String.format("%s%d", GenericTypeExtend.this.unboundVariableIndex.contains(input) ? "-" : "+", input);
            }
        });
        return "extend    " + this.type.getPrettyPrintableName() + "(" + Joiner.on((String)", ").join(parameterNames) + ")";
    }
}

