/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.ResourceStorageProviderAdapter;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ResourceStorageFacade
implements IResourceStorageFacade {
    private static final Logger LOG = Logger.getLogger(ResourceStorageFacade.class);
    @Inject
    private IContextualOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private Provider<AbstractFileSystemAccess2> fileSystemAccessProvider;
    @Accessors
    private boolean storeNodeModel = false;

    @Override
    public boolean shouldLoadFromStorage(StorageAwareResource resource) {
        URI _uRI;
        ResourceSet _resourceSet = resource.getResourceSet();
        SourceLevelURIsAdapter adapter = SourceLevelURIsAdapter.findInstalledAdapter(_resourceSet);
        boolean _equals = Objects.equal((Object)((Object)adapter), null);
        if (_equals) {
            return false;
        }
        ImmutableSet<URI> _sourceLevelURIs = adapter.getSourceLevelURIs();
        boolean _contains = _sourceLevelURIs.contains((Object)(_uRI = resource.getURI()));
        if (_contains) {
            return false;
        }
        return this.doesStorageExist(resource);
    }

    @Override
    public ResourceStorageLoadable getOrCreateResourceStorageLoadable(StorageAwareResource resource) {
        try {
            Map _emptyMap;
            URI _uRI;
            URI _binaryStorageURI;
            boolean _notEquals;
            ResourceSet _resourceSet = resource.getResourceSet();
            EList _eAdapters = _resourceSet.eAdapters();
            Iterable _filter = Iterables.filter((Iterable)_eAdapters, ResourceStorageProviderAdapter.class);
            ResourceStorageProviderAdapter stateProvider = (ResourceStorageProviderAdapter)((Object)IterableExtensions.head((Iterable)_filter));
            boolean bl = _notEquals = !Objects.equal((Object)((Object)stateProvider), null);
            if (_notEquals) {
                boolean _notEquals_1;
                ResourceStorageLoadable inputStream = stateProvider.getResourceStorageLoadable(resource);
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)inputStream, null);
                if (_notEquals_1) {
                    return inputStream;
                }
            }
            InputStream _xifexpression = null;
            ResourceSet _resourceSet_1 = resource.getResourceSet();
            URIConverter _uRIConverter = _resourceSet_1.getURIConverter();
            boolean _exists = _uRIConverter.exists(_binaryStorageURI = this.getBinaryStorageURI(_uRI = resource.getURI()), _emptyMap = CollectionLiterals.emptyMap());
            if (_exists) {
                ResourceSet _resourceSet_2 = resource.getResourceSet();
                URIConverter _uRIConverter_1 = _resourceSet_2.getURIConverter();
                URI _uRI_1 = resource.getURI();
                URI _binaryStorageURI_1 = this.getBinaryStorageURI(_uRI_1);
                _xifexpression = _uRIConverter_1.createInputStream(_binaryStorageURI_1);
            } else {
                InputStream _xblockexpression = null;
                AbstractFileSystemAccess2 fsa = this.getFileSystemAccess(resource);
                String outputRelativePath = this.computeOutputPath(resource);
                _xifexpression = _xblockexpression = fsa.readBinaryFile(outputRelativePath);
            }
            InputStream inputStream_1 = _xifexpression;
            return this.createResourceStorageLoadable(inputStream_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void saveResource(StorageAwareResource resource, IFileSystemAccessExtension3 fsa) {
        String path = this.computeOutputPath(resource);
        MyByteArrayOutputStream bout = new MyByteArrayOutputStream();
        ResourceStorageWritable outStream = this.createResourceStorageWritable(bout);
        try {
            outStream.writeResource(resource);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                URI _uRI = resource.getURI();
                String _plus = "Cannot write storage for " + _uRI;
                LOG.warn((Object)_plus, (Throwable)e);
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        byte[] _byteArray = bout.toByteArray();
        int _length = bout.length();
        ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_byteArray, 0, _length);
        fsa.generateFile(path, _byteArrayInputStream);
    }

    @Override
    public ResourceStorageLoadable createResourceStorageLoadable(InputStream in) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new ResourceStorageLoadable(in, _isStoreNodeModel);
    }

    @Override
    public ResourceStorageWritable createResourceStorageWritable(OutputStream out) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new ResourceStorageWritable(out, _isStoreNodeModel);
    }

    protected boolean doesStorageExist(StorageAwareResource resource) {
        String outputRelativePath;
        Map _emptyMap;
        URI _uRI;
        URI _binaryStorageURI;
        ResourceSet _resourceSet = resource.getResourceSet();
        EList _eAdapters = _resourceSet.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, ResourceStorageProviderAdapter.class);
        ResourceStorageProviderAdapter stateProvider = (ResourceStorageProviderAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        if (!Objects.equal((Object)((Object)stateProvider), null) && !Objects.equal((Object)stateProvider.getResourceStorageLoadable(resource), null)) {
            return true;
        }
        ResourceSet _resourceSet_1 = resource.getResourceSet();
        URIConverter _uRIConverter = _resourceSet_1.getURIConverter();
        boolean _exists = _uRIConverter.exists(_binaryStorageURI = this.getBinaryStorageURI(_uRI = resource.getURI()), _emptyMap = CollectionLiterals.emptyMap());
        if (_exists) {
            return true;
        }
        URI _uRI_1 = resource.getURI();
        boolean _isArchive = _uRI_1.isArchive();
        if (_isArchive) {
            return false;
        }
        AbstractFileSystemAccess2 fsa = this.getFileSystemAccess(resource);
        URI uri = fsa.getURI(outputRelativePath = this.computeOutputPath(resource));
        return uri != null && resource.getResourceSet().getURIConverter().exists(uri, null);
    }

    protected AbstractFileSystemAccess2 getFileSystemAccess(StorageAwareResource resource) {
        AbstractFileSystemAccess2 fsa = (AbstractFileSystemAccess2)this.fileSystemAccessProvider.get();
        fsa.setContext((Object)resource);
        Set<OutputConfiguration> _outputConfigurations = this.outputConfigurationProvider.getOutputConfigurations((Resource)resource);
        Functions.Function1<OutputConfiguration, String> _function = new Functions.Function1<OutputConfiguration, String>(){

            public String apply(OutputConfiguration it) {
                return it.getName();
            }
        };
        Map _map = IterableExtensions.toMap(_outputConfigurations, (Functions.Function1)_function);
        fsa.setOutputConfigurations(_map);
        return fsa;
    }

    protected String computeOutputPath(StorageAwareResource resource) {
        URI srcContainerURI = this.getSourceContainerURI(resource);
        URI _uRI = resource.getURI();
        URI uri = this.getBinaryStorageURI(_uRI);
        URI _deresolve = uri.deresolve(srcContainerURI, false, false, true);
        String outputRelativePath = _deresolve.path();
        return outputRelativePath;
    }

    protected URI getSourceContainerURI(StorageAwareResource resource) {
        URI _uRI = resource.getURI();
        URI _trimSegments = _uRI.trimSegments(1);
        return _trimSegments.appendSegment("");
    }

    @Override
    public boolean hasStorageFor(URI uri) {
        ExtensibleURIConverterImpl _extensibleURIConverterImpl = new ExtensibleURIConverterImpl();
        URI _binaryStorageURI = this.getBinaryStorageURI(uri);
        Map _emptyMap = CollectionLiterals.emptyMap();
        return _extensibleURIConverterImpl.exists(_binaryStorageURI, _emptyMap);
    }

    protected URI getBinaryStorageURI(URI sourceURI) {
        URI _trimSegments = sourceURI.trimSegments(1);
        String _lastSegment = sourceURI.lastSegment();
        String _plus = "." + _lastSegment;
        String _plus_1 = String.valueOf(_plus) + "bin";
        return _trimSegments.appendSegment(_plus_1);
    }

    @Pure
    public boolean isStoreNodeModel() {
        return this.storeNodeModel;
    }

    public void setStoreNodeModel(boolean storeNodeModel) {
        this.storeNodeModel = storeNodeModel;
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream() {
        }

        @Override
        public byte[] toByteArray() {
            return this.buf;
        }

        public int length() {
            return this.count;
        }
    }
}

