/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement;

import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.LocalSearchDebugger;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.OperationStatus;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.SearchOperationViewerNode;

public class SearchPlanViewModel {
    private List<SearchOperationViewerNode> topLevelElements;
    private LocalSearchDebugger debugger;
    private SearchOperationViewerNode lastSelected;

    public SearchOperationViewerNode getLastSelected() {
        return this.lastSelected;
    }

    public SearchPlanViewModel(List<SearchOperationViewerNode> topLevelElements) {
        this.topLevelElements = topLevelElements;
    }

    public List<SearchOperationViewerNode> getTopLevelElements() {
        return this.topLevelElements;
    }

    public void setDebugger(LocalSearchDebugger localSearchDebugger) {
        this.debugger = localSearchDebugger;
    }

    public void insertForCurrent(List<SearchOperationViewerNode> viewNodeList) {
        boolean notInserted = true;
        while (notInserted) {
            if (this.lastSelected.isMatcherBased()) {
                this.lastSelected.setChildren(viewNodeList);
                notInserted = false;
                continue;
            }
            this.lastSelected = this.lastSelected.getParent();
        }
    }

    public void stepInto() {
        this.doStepInto(this.topLevelElements);
    }

    private void doStepInto(List<SearchOperationViewerNode> sameLevelElements) {
        if (sameLevelElements.size() == 0) {
            return;
        }
        SearchPlanExecutor planExecutor = sameLevelElements.get(0).getPlanExecutor();
        int currentOperation = planExecutor.getCurrentOperation();
        int i = 0;
        while (i < sameLevelElements.size()) {
            SearchOperationViewerNode currentNode = sameLevelElements.get(i);
            if (i < currentOperation) {
                currentNode.setOperationStatus(OperationStatus.EXECUTED);
            } else if (i == currentOperation) {
                if (this.becameCurrent(currentNode)) {
                    if (currentNode.isBreakpoint()) {
                        this.debugger.setHalted(true);
                    }
                    currentNode.setOperationStatus(OperationStatus.CURRENT);
                    this.lastSelected = currentNode;
                }
                this.doStepInto((List<SearchOperationViewerNode>)currentNode.getChildren());
            } else {
                currentNode.setOperationStatus(OperationStatus.QUEUED);
            }
            ++i;
        }
    }

    private boolean becameCurrent(SearchOperationViewerNode currentNode) {
        boolean fromQueued = currentNode.getOperationStatus().equals((Object)OperationStatus.QUEUED);
        boolean fromExecuted = currentNode.getOperationStatus().equals((Object)OperationStatus.EXECUTED);
        return fromQueued || fromExecuted;
    }

    public void stepBack() {
        this.doStepBack(this.topLevelElements);
    }

    private void doStepBack(List<SearchOperationViewerNode> sameLevelElements) {
        if (sameLevelElements.size() == 0) {
            return;
        }
        SearchOperationViewerNode firstNode = sameLevelElements.get(0);
        SearchPlanExecutor planExecutor = firstNode.getPlanExecutor();
        int currentOperation = planExecutor.getCurrentOperation();
        int i = 0;
        while (i < sameLevelElements.size()) {
            SearchOperationViewerNode currentNode = sameLevelElements.get(i);
            if (i < currentOperation) {
                currentNode.setOperationStatus(OperationStatus.EXECUTED);
            } else if (i == currentOperation) {
                this.doStepBack((List<SearchOperationViewerNode>)currentNode.getChildren());
                if (currentNode.getOperationStatus().equals((Object)OperationStatus.EXECUTED) && currentNode.isBreakpoint()) {
                    this.debugger.setHalted(true);
                }
                currentNode.setOperationStatus(OperationStatus.CURRENT);
                this.lastSelected = currentNode;
            } else {
                currentNode.setOperationStatus(OperationStatus.QUEUED);
            }
            ++i;
        }
    }

    public void stepOver() {
        throw new UnsupportedOperationException("This feature is a TODO");
    }
}

