/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.operations;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.generator.dtos.AppClass;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.dtos.MinMaxData;
import org.eclipse.viatra.examples.cps.generator.utils.CPSModelBuilderUtil;
import org.eclipse.viatra.examples.cps.generator.utils.RandomUtils;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;

public class ApplicationTypeStatisticsBasedGenerationOperation
implements IOperation<CPSFragment> {
    private final AppClass applicationClass;
    @Extension
    private CPSModelBuilderUtil modelBuilder;
    @Extension
    private RandomUtils randUtil;

    public ApplicationTypeStatisticsBasedGenerationOperation(AppClass applicationClass) {
        RandomUtils _randomUtils;
        CPSModelBuilderUtil _cPSModelBuilderUtil;
        this.applicationClass = applicationClass;
        this.modelBuilder = _cPSModelBuilderUtil = new CPSModelBuilderUtil();
        this.randUtil = _randomUtils = new RandomUtils();
    }

    public boolean execute(CPSFragment fragment) {
        try {
            boolean _xblockexpression = false;
            int numberOfAppTypes = this.randUtil.randInt(this.applicationClass.getNumberOfAppTypes(), fragment.getRandom());
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numberOfAppTypes, true);
            for (Integer i : _doubleDotLessThan) {
                boolean _greaterThan;
                String _name = this.applicationClass.getName();
                String _plus = "simple.cps.app." + _name;
                String appTypeId = String.valueOf(_plus) + i;
                ApplicationType appType = this.modelBuilder.prepareApplicationTypeWithId((CyberPhysicalSystem)fragment.modelRoot, appTypeId);
                fragment.addApplicationType(this.applicationClass, appType);
                int _randInt = this.randUtil.randInt(this.applicationClass.getNumberOfStates(), fragment.getRandom());
                boolean bl = _greaterThan = _randInt > 0;
                if (!_greaterThan) continue;
                String stateName = String.valueOf(appTypeId) + ".sm" + i;
                StateMachine sm = this.modelBuilder.prepareStateMachine(appType, stateName);
                int numberOfStates = this.randUtil.randInt(this.applicationClass.getNumberOfStates(), fragment.getRandom());
                ArrayList states = Lists.newArrayList();
                ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, numberOfStates, true);
                for (Integer s : _doubleDotLessThan_1) {
                    states.add(this.modelBuilder.prepareState(sm, String.valueOf(stateName) + ".s" + s));
                }
                if (!Objects.equal(states.get(0), null) && !Objects.equal((Object)sm, null)) {
                    State initState = (State)states.get(0);
                    sm.setInitial(initState);
                }
                int numberOfTransactions = this.randUtil.randInt(this.applicationClass.getNumberOfTrannsitions(), fragment.getRandom());
                ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, numberOfTransactions, true);
                for (Integer t : _doubleDotLessThan_2) {
                    int startNode = this.randUtil.randInt(new MinMaxData<Integer>(0, numberOfStates - 1), fragment.getRandom());
                    int endNode = this.randUtil.randIntExcept(new MinMaxData<Integer>(0, numberOfStates - 1), startNode, fragment.getRandom());
                    State _get = (State)states.get(startNode);
                    String _identifier = ((State)states.get(startNode)).getIdentifier();
                    String _plus_1 = String.valueOf(_identifier) + ".t";
                    String _plus_2 = String.valueOf(_plus_1) + t;
                    this.modelBuilder.prepareTransition(_get, _plus_2, (State)states.get(endNode));
                }
            }
            _xblockexpression = true;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

