/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.phases;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.generator.dtos.AppClass;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.dtos.HostClass;
import org.eclipse.viatra.examples.cps.generator.dtos.Percentage;
import org.eclipse.viatra.examples.cps.generator.exceptions.ModelGeneratorException;
import org.eclipse.viatra.examples.cps.generator.operations.ApplicationInstanceAllocationOperation;
import org.eclipse.viatra.examples.cps.generator.utils.CPSModelBuilderUtil;
import org.eclipse.viatra.examples.cps.generator.utils.MapUtil;
import org.eclipse.viatra.examples.cps.generator.utils.RandomUtils;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPhase;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CPSPhaseApplicationAllocation
implements IPhase<CPSFragment> {
    @Extension
    private RandomUtils randUtil = new RandomUtils();
    @Extension
    protected Logger logger = Logger.getLogger((String)"cps.generator.impl.CPSPhaseApplicationAllocation");

    public Iterable<IOperation<CPSFragment>> getOperations(CPSFragment fragment) {
        try {
            ArrayList operations = Lists.newArrayList();
            HashMultimap<HostClass, HostInstance> hostInstacesToClass = CPSModelBuilderUtil.calculateHostInstancesToHostClassMap(fragment);
            Set _keySet = fragment.getApplicationTypes().keySet();
            for (AppClass appClass : _keySet) {
                boolean _not;
                ArrayList<ApplicationInstance> appInstances = this.collectApplicationInstancesByAppClass(appClass, fragment);
                boolean _isEmpty = appInstances.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    int sumRatio = this.calculateSumRatio(appClass);
                    if (sumRatio != 0) {
                        boolean _lessThan;
                        HashMap<HostClass, Integer> allocNumbers = new HashMap<HostClass, Integer>();
                        int sumAllocatedApps = 0;
                        Set<HostClass> _keySet_1 = appClass.getAllocationRatios().keySet();
                        for (HostClass targetHostClass : _keySet_1) {
                            Integer hcRatio = appClass.getAllocationRatios().get(targetHostClass);
                            int _size = appInstances.size();
                            double div = (double)sumRatio / (double)_size;
                            double _floor = Math.floor((double)hcRatio.intValue() / div);
                            int hcAllocNumber = (int)_floor;
                            allocNumbers.put(targetHostClass, hcAllocNumber);
                            int _sumAllocatedApps = sumAllocatedApps;
                            sumAllocatedApps = _sumAllocatedApps + hcAllocNumber;
                        }
                        SortedSet sortedAllocNumbersMap = MapUtil.entriesSortedByValues(allocNumbers);
                        int _size = appInstances.size();
                        boolean bl2 = _lessThan = sumAllocatedApps < _size;
                        if (_lessThan) {
                            Iterator sortedIterator = sortedAllocNumbersMap.iterator();
                            while (sortedIterator.hasNext() && appInstances.size() - sumAllocatedApps != 0) {
                                Map.Entry act = (Map.Entry)sortedIterator.next();
                                HostClass _key = (HostClass)act.getKey();
                                Integer _value = (Integer)act.getValue();
                                int _plus = _value + 1;
                                allocNumbers.put(_key, _plus);
                                int _sumAllocatedApps = sumAllocatedApps;
                                sumAllocatedApps = _sumAllocatedApps + 1;
                            }
                        }
                        HashMultimap allocationMap = HashMultimap.create();
                        ArrayList appInstanceCopy = Lists.newArrayList(appInstances);
                        Set _keySet_2 = allocNumbers.keySet();
                        for (HostClass targetHc : _keySet_2) {
                            Integer _get = (Integer)allocNumbers.get(targetHc);
                            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _get.intValue(), true);
                            for (Integer i : _doubleDotLessThan) {
                                ApplicationInstance app = (ApplicationInstance)this.randUtil.randElement(appInstanceCopy, fragment.getRandom());
                                appInstanceCopy.remove(app);
                                HostInstance hostInstance = (HostInstance)this.randUtil.randElement(IterableExtensions.toList((Iterable)hostInstacesToClass.get((Object)targetHc)), fragment.getRandom());
                                String _identifier = app.getIdentifier();
                                String _plus = String.valueOf(_identifier) + " --> ";
                                String _identifier_1 = hostInstance.getIdentifier();
                                String _plus_1 = String.valueOf(_plus) + _identifier_1;
                                this.logger.debug((Object)_plus_1);
                                allocationMap.put((Object)hostInstance, (Object)app);
                            }
                        }
                        ApplicationInstanceAllocationOperation _applicationInstanceAllocationOperation = new ApplicationInstanceAllocationOperation((Multimap<HostInstance, ApplicationInstance>)allocationMap);
                        operations.add(_applicationInstanceAllocationOperation);
                        continue;
                    }
                    this.logger.debug((Object)"!!! Error: Sum ratio is zero");
                    throw new ModelGeneratorException("Sum ratio is zero");
                }
                this.logger.debug((Object)"#Warning#: ApplicationInstancesForAllocation is empty");
            }
            return operations;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public HashMap<HostClass, Integer> normalizeRatios(HashMap<HostClass, Double> ratios, int sumRatio, int appsSize) {
        HashMap<HostClass, Integer> normalizedRatios = new HashMap<HostClass, Integer>();
        int sumAllocCount = 0;
        Set<HostClass> _keySet = ratios.keySet();
        for (HostClass hostClass : _keySet) {
            double _floor = Math.floor(ratios.get(hostClass));
            int allocCount = (int)_floor;
            normalizedRatios.put(hostClass, allocCount);
            int _sumAllocCount = sumAllocCount;
            sumAllocCount = _sumAllocCount + allocCount;
        }
        this.logger.debug((Object)("SumApp: " + Integer.valueOf(appsSize) + ", FlooredAlloc: " + Integer.valueOf(sumAllocCount)));
        if (sumAllocCount < appsSize) {
            boolean _greaterThan;
            Set<HostClass> _keySet_1 = ratios.keySet();
            for (HostClass hostClass_1 : _keySet_1) {
                Double value = ratios.get(hostClass_1);
                double fraction = value - (double)((long)value.doubleValue());
                ratios.put(hostClass_1, fraction);
            }
            int remainder = appsSize - sumAllocCount;
            SortedSet<Map.Entry<HostClass, Double>> sortedMapEntires = MapUtil.entriesSortedByValues(ratios);
            int _size = normalizedRatios.size();
            boolean bl = _greaterThan = remainder > _size;
            if (_greaterThan) {
                this.logger.debug((Object)"#Warning#: The remainder is greater than the size of targets.");
            }
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, remainder, true);
            for (Integer index : _doubleDotLessThan) {
                Integer actualValue = normalizedRatios.get(((Map.Entry[])Conversions.unwrapArray(sortedMapEntires, Map.Entry.class))[index].getKey());
                normalizedRatios.put((HostClass)((Map.Entry[])Conversions.unwrapArray(sortedMapEntires, Map.Entry.class))[index].getKey(), actualValue + 1);
            }
        }
        return normalizedRatios;
    }

    public int calculateSumRatio(AppClass appClass) {
        int sumRatio = 0;
        Set<HostClass> _keySet = appClass.getAllocationRatios().keySet();
        for (HostClass hostClass : _keySet) {
            int _sumRatio = sumRatio;
            Integer _get = appClass.getAllocationRatios().get(hostClass);
            sumRatio = _sumRatio + _get;
        }
        return sumRatio;
    }

    public ArrayList<ApplicationInstance> collectApplicationInstancesByAppClass(AppClass appClass, CPSFragment fragment) {
        Collection appTypes = fragment.getApplicationTypes().get((Object)appClass);
        ArrayList appsForAllocateByAppClass = CollectionLiterals.newArrayList((Object[])new ApplicationInstance[0]);
        for (ApplicationType appType : appTypes) {
            appsForAllocateByAppClass.addAll(this.collectApplicationsForAllocation(appType, appClass, fragment));
        }
        return appsForAllocateByAppClass;
    }

    public ArrayList<ApplicationInstance> collectApplicationsForAllocation(ApplicationType appType, AppClass appClass, CPSFragment fragment) {
        try {
            long _round = Math.round(Percentage.value(appType.getInstances().size(), appClass.getPercentOfAllocatedInstances()));
            int numberOfAllocations = (int)_round;
            ArrayList appsForAllocate = CollectionLiterals.newArrayList((Object[])new ApplicationInstance[0]);
            ArrayList instances = Lists.newArrayList((Iterable)appType.getInstances());
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numberOfAllocations, true);
            for (Integer i : _doubleDotLessThan) {
                ApplicationInstance app = (ApplicationInstance)this.randUtil.randElement(instances, fragment.getRandom());
                appsForAllocate.add(app);
                instances.remove(app);
            }
            return appsForAllocate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

