/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.Tuple;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcObserver;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;

public class TransitiveClosureNode
extends SingleInputNode
implements Clearable,
ITcObserver<Object>,
NetworkStructureChangeSensitiveNode {
    private Graph<Object> graphDataSource = new Graph();
    private ITcDataSource<Object> transitiveClosureAlgorithm = new IncSCCAlg(this.graphDataSource);

    public TransitiveClosureNode(ReteContainer reteContainer) {
        super(reteContainer);
        this.transitiveClosureAlgorithm.attachObserver((ITcObserver)this);
        reteContainer.registerClearable(this);
    }

    @Override
    public void networkStructureChanged() {
        if (this.reteContainer.isTimelyEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
            throw new IllegalStateException(this.toString() + " cannot be used in recursive differential dataflow evaluation!");
        }
        super.networkStructureChanged();
    }

    public void reinitializeWith(Collection<org.eclipse.viatra.query.runtime.matchers.tuple.Tuple> tuples) {
        this.clear();
        for (org.eclipse.viatra.query.runtime.matchers.tuple.Tuple t : tuples) {
            this.graphDataSource.insertNode(t.get(0));
            this.graphDataSource.insertNode(t.get(1));
            this.graphDataSource.insertEdge(t.get(0), t.get(1));
        }
        this.transitiveClosureAlgorithm.attachObserver((ITcObserver)this);
    }

    @Override
    public void pullInto(Collection<org.eclipse.viatra.query.runtime.matchers.tuple.Tuple> collector, boolean flush) {
        for (Tuple tuple : ((IncSCCAlg)this.transitiveClosureAlgorithm).getTcRelation()) {
            collector.add(Tuples.staticArityFlatTupleOf((Object)tuple.getSource(), (Object)tuple.getTarget()));
        }
    }

    @Override
    public void pullIntoWithTimeline(Map<org.eclipse.viatra.query.runtime.matchers.tuple.Tuple, Timeline<Timestamp>> collector, boolean flush) {
        for (Tuple tuple : ((IncSCCAlg)this.transitiveClosureAlgorithm).getTcRelation()) {
            collector.put(Tuples.staticArityFlatTupleOf((Object)tuple.getSource(), (Object)tuple.getTarget()), Timestamp.INSERT_AT_ZERO_TIMELINE);
        }
    }

    @Override
    public void update(Direction direction, org.eclipse.viatra.query.runtime.matchers.tuple.Tuple updateElement, Timestamp timestamp) {
        if (updateElement.getSize() == 2) {
            Object source = updateElement.get(0);
            Object target = updateElement.get(1);
            if (direction == Direction.INSERT) {
                this.graphDataSource.insertNode(source);
                this.graphDataSource.insertNode(target);
                this.graphDataSource.insertEdge(source, target);
            }
            if (direction == Direction.DELETE) {
                this.graphDataSource.deleteEdgeIfExists(source, target);
                if (((IncSCCAlg)this.transitiveClosureAlgorithm).isIsolated(source)) {
                    this.graphDataSource.deleteNode(source);
                }
                if (!source.equals(target) && ((IncSCCAlg)this.transitiveClosureAlgorithm).isIsolated(target)) {
                    this.graphDataSource.deleteNode(target);
                }
            }
        }
    }

    public void clear() {
        this.transitiveClosureAlgorithm.dispose();
        this.graphDataSource = new Graph();
        this.transitiveClosureAlgorithm = new IncSCCAlg(this.graphDataSource);
    }

    public void tupleInserted(Object source, Object target) {
        org.eclipse.viatra.query.runtime.matchers.tuple.Tuple tuple = Tuples.staticArityFlatTupleOf((Object)source, (Object)target);
        this.propagateUpdate(Direction.INSERT, tuple, Timestamp.ZERO);
    }

    public void tupleDeleted(Object source, Object target) {
        org.eclipse.viatra.query.runtime.matchers.tuple.Tuple tuple = Tuples.staticArityFlatTupleOf((Object)source, (Object)target);
        this.propagateUpdate(Direction.DELETE, tuple, Timestamp.ZERO);
    }
}

