/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.views.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.api.GenericPatternMatch;
import org.eclipse.viatra.transformation.views.core.ViewModelManager;
import org.eclipse.viatra.transformation.views.traceability.Trace;
import org.eclipse.viatra.transformation.views.traceability.Traceability;
import org.eclipse.viatra.transformation.views.traceability.TraceabilityUtil;

public final class ViewModelUtil {
    private ViewModelUtil() {
    }

    public static <T extends EObject> T create(EClass eClass, EObject eContainer, EReference cReference) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        if (cReference.isMany()) {
            ((EList)eContainer.eGet((EStructuralFeature)cReference)).add((Object)eObject);
        } else {
            eContainer.eSet((EStructuralFeature)cReference, (Object)eObject);
        }
        return (T)eObject;
    }

    public static void trace(ViewModelManager manager, String id, Set<EObject> targets, Object ... sources) {
        Collection<EObject> eoList = ViewModelUtil.selectEObjects(sources);
        Collection<Object> oList = ViewModelUtil.selectObjects(sources);
        TraceabilityUtil.createTrace(manager.getTraceability(), id, eoList, oList, targets);
    }

    public static Collection<EObject> delete(GenericPatternMatch match) {
        Trace trace = (Trace)match.get("<trace>");
        ArrayList<EObject> ret = new ArrayList<EObject>((Collection<EObject>)trace.getTargets());
        if (trace.eContainer() instanceof Traceability) {
            ((Traceability)trace.eContainer()).getTraces().remove((Object)trace);
        } else {
            EcoreUtil.delete((EObject)trace);
        }
        return ret;
    }

    public static EObject target(GenericPatternMatch match) {
        Trace trace = (Trace)match.get("<trace>");
        return (EObject)trace.getTargets().get(0);
    }

    private static Collection<EObject> selectEObjects(Object[] sources) {
        return Arrays.stream(sources).filter(EObject.class::isInstance).map(EObject.class::cast).collect(Collectors.toList());
    }

    private static Collection<Object> selectObjects(Object[] sources) {
        return Arrays.stream(sources).filter(source -> !(source instanceof EObject)).collect(Collectors.toList());
    }

    public static ResourceSet getOrCreateResourceSet(Notifier baseNotifier) {
        if (baseNotifier instanceof EObject) {
            EObject eObject = (EObject)baseNotifier;
            Resource r = ViewModelUtil.createResourceForEObject(eObject);
            return r.getResourceSet();
        }
        if (baseNotifier instanceof Resource) {
            Resource r = (Resource)baseNotifier;
            return ViewModelUtil.createResourceSetForResource(r.getResourceSet(), r);
        }
        if (baseNotifier instanceof ResourceSet) {
            return (ResourceSet)baseNotifier;
        }
        throw new IllegalArgumentException("Cannot get or create ResourceSet for " + String.valueOf(baseNotifier.getClass()) + " type");
    }

    private static Resource createResourceForEObject(EObject root) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource r = resourceSet.createResource(URI.createURI((String)(root.getClass().getSimpleName() + "Resource")));
        r.getContents().add((Object)root);
        return r;
    }

    private static ResourceSet createResourceSetForResource(ResourceSet resourceSet, Resource r) {
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
            resourceSet.getResources().add((Object)r);
        }
        return resourceSet;
    }
}

