/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.base;

import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.DseIdPoolHelper;
import org.eclipse.viatra.dse.base.GlobalContext;
import org.eclipse.viatra.dse.base.ThreadContext;

public class ExplorerThread
implements Runnable {
    private final ThreadContext threadContext;
    private IStrategy strategy;

    public ExplorerThread(ThreadContext context) {
        this.threadContext = context;
        this.strategy = this.threadContext.getStrategy();
    }

    public void stopRunning() {
        this.strategy.interruptStrategy();
    }

    @Override
    public void run() {
        GlobalContext globalContext = this.threadContext.getGlobalContext();
        try {
            try {
                this.threadContext.init();
                this.strategy.initStrategy(this.threadContext);
                this.strategy.explore();
                this.threadContext.backtrackUntilRoot();
            }
            catch (Throwable e) {
                Logger.getLogger(IStrategy.class).error((Object)"Thread stopped unexpectedly!", e);
                globalContext.registerException(e);
                globalContext.strategyFinished(this);
                this.dispose();
            }
        }
        finally {
            globalContext.strategyFinished(this);
            this.dispose();
        }
    }

    public void dispose() {
        this.threadContext.getRuleEngine().dispose();
        DseIdPoolHelper.INSTANCE.disposeByThread();
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }
}

