/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.matcher.CallWithAdornment;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;

public class SearchPlanForBody {
    private final PBody body;
    private final Map<PVariable, Integer> variableKeys;
    private final int[] parameterKeys;
    private final SubPlan plan;
    private final List<ISearchOperation> compiledOperations;
    private final Collection<CallWithAdornment> dependencies;
    private final double cost;
    private final Object internalRepresentation;

    public SearchPlanForBody(PBody body, Map<PVariable, Integer> variableKeys, SubPlan plan, List<ISearchOperation> compiledOperations, Collection<CallWithAdornment> dependencies, Object internalRepresentation, double cost) {
        this.body = body;
        this.variableKeys = variableKeys;
        this.plan = plan;
        this.internalRepresentation = internalRepresentation;
        this.cost = cost;
        List parameters = body.getSymbolicParameterVariables();
        this.parameterKeys = new int[parameters.size()];
        int i = 0;
        while (i < parameters.size()) {
            this.parameterKeys[i] = variableKeys.get(parameters.get(i));
            ++i;
        }
        this.compiledOperations = new ArrayList<ISearchOperation>(compiledOperations.size() + 1);
        this.compiledOperations.addAll(compiledOperations);
        this.dependencies = new ArrayList<CallWithAdornment>(dependencies);
    }

    public PBody getBody() {
        return this.body;
    }

    public Map<PVariable, Integer> getVariableKeys() {
        return this.variableKeys;
    }

    public int[] getParameterKeys() {
        return Arrays.copyOf(this.parameterKeys, this.parameterKeys.length);
    }

    public List<ISearchOperation> getCompiledOperations() {
        return this.compiledOperations;
    }

    public SubPlan getPlan() {
        return this.plan;
    }

    public Collection<CallWithAdornment> getDependencies() {
        return this.dependencies;
    }

    public TupleMask calculateParameterMask() {
        return TupleMask.fromSelectedIndices((int)this.variableKeys.size(), (int[])this.parameterKeys);
    }

    public String toString() {
        return this.compiledOperations.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    public double getCost() {
        return this.cost;
    }

    public Object getInternalRepresentation() {
        return this.internalRepresentation;
    }
}

