/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.AbstractTimelyTrivialMaskedMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public final class TimelyIdentityMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends AbstractTimelyTrivialMaskedMemory<Timestamp> {
    public TimelyIdentityMaskedTupleMemory(TupleMask mask, Object owner, boolean isLazy) {
        super(mask, owner, isLazy);
        if (!mask.isIdentity()) {
            throw new IllegalArgumentException(mask.toString());
        }
    }

    @Override
    public int getKeysetSize() {
        return this.memory.size();
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return this.memory.keySet();
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        if (this.memory.getTuplesAtInfinity().contains(signature)) {
            return Collections.singleton(signature.toImmutable());
        }
        return null;
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getWithTimeline(ITuple signature) {
        Timeline value = this.memory.get(signature);
        if (value != null) {
            return Collections.singletonMap(signature.toImmutable(), value);
        }
        return null;
    }

    @Override
    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        try {
            return this.memory.remove(tuple, timestamp);
        }
        catch (IllegalStateException e) {
            throw this.raiseDuplicateDeletion(tuple);
        }
    }

    @Override
    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        return this.memory.put(tuple, timestamp);
    }

    @Override
    public boolean isPresentAtInfinity(ITuple signature) {
        return this.memory.isPresentAtInfinity(signature.toImmutable());
    }

    public Set<Tuple> getResumableSignatures() {
        if (this.memory.getResumableTimestamp() != null) {
            return this.memory.getResumableTuples();
        }
        return Collections.emptySet();
    }

    @Override
    public Map<Tuple, Map<Tuple, Diff<Timestamp>>> resumeAt(Timestamp timestamp) {
        Map<Tuple, Diff<Timestamp>> diffMap = this.memory.resumeAt(timestamp);
        Map<Tuple, Map<Tuple, Diff<Timestamp>>> result = CollectionsFactory.createMap();
        for (Map.Entry<Tuple, Diff<Timestamp>> entry : diffMap.entrySet()) {
            result.put(entry.getKey(), Collections.singletonMap(entry.getKey(), entry.getValue()));
        }
        return result;
    }
}

