/**
 * 
 *   Copyright (c) 2010-2015, Csaba Debreceni, Istvan Rath and Daniel Varro
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.transformation.views.traceability.patterns;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

/**
 * A pattern-specific query specification that can instantiate Matcher in a type-safe way.
 * 
 * <p>Original source:
 *         <code><pre>
 *         pattern trace(source : EObject, id : java String, target : EObject, trace : Trace, traceabilityId : java String) {
 *         	Trace.params(trace, source);
 *         	Trace.targets(trace, target);
 *         	Trace.id(trace,id);
 *         	Traceability.id(traceability,traceabilityId);
 *         	Traceability.traces(traceability,trace);
 *         } or {
 *         	Trace.objects(trace, source);
 *         	Trace.targets(trace, target);
 *         	Trace.id(trace,id);
 *         	Traceability.id(traceability,traceabilityId);
 *         	Traceability.traces(traceability,trace);
 *         }
 * </pre></code>
 * 
 * @see Matcher
 * @see Match
 * 
 */
@SuppressWarnings("all")
public final class Trace extends BaseGeneratedEMFQuerySpecification<Trace.Matcher> {
  /**
   * Pattern-specific match representation of the org.eclipse.viatra.transformation.views.traceability.patterns.trace pattern,
   * to be used in conjunction with {@link Matcher}.
   * 
   * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
   * Each instance is a (possibly partial) substitution of pattern parameters,
   * usable to represent a match of the pattern in the result of a query,
   * or to specify the bound (fixed) input parameters when issuing a query.
   * 
   * @see Matcher
   * 
   */
  public static abstract class Match extends BasePatternMatch {
    private EObject fSource;
    
    private String fId;
    
    private EObject fTarget;
    
    private org.eclipse.viatra.transformation.views.traceability.Trace fTrace;
    
    private String fTraceabilityId;
    
    private static List<String> parameterNames = makeImmutableList("source", "id", "target", "trace", "traceabilityId");
    
    private Match(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      this.fSource = pSource;
      this.fId = pId;
      this.fTarget = pTarget;
      this.fTrace = pTrace;
      this.fTraceabilityId = pTraceabilityId;
    }
    
    @Override
    public Object get(final String parameterName) {
      switch(parameterName) {
          case "source": return this.fSource;
          case "id": return this.fId;
          case "target": return this.fTarget;
          case "trace": return this.fTrace;
          case "traceabilityId": return this.fTraceabilityId;
          default: return null;
      }
    }
    
    @Override
    public Object get(final int index) {
      switch(index) {
          case 0: return this.fSource;
          case 1: return this.fId;
          case 2: return this.fTarget;
          case 3: return this.fTrace;
          case 4: return this.fTraceabilityId;
          default: return null;
      }
    }
    
    public EObject getSource() {
      return this.fSource;
    }
    
    public String getId() {
      return this.fId;
    }
    
    public EObject getTarget() {
      return this.fTarget;
    }
    
    public org.eclipse.viatra.transformation.views.traceability.Trace getTrace() {
      return this.fTrace;
    }
    
    public String getTraceabilityId() {
      return this.fTraceabilityId;
    }
    
    @Override
    public boolean set(final String parameterName, final Object newValue) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      if ("source".equals(parameterName) ) {
          this.fSource = (EObject) newValue;
          return true;
      }
      if ("id".equals(parameterName) ) {
          this.fId = (String) newValue;
          return true;
      }
      if ("target".equals(parameterName) ) {
          this.fTarget = (EObject) newValue;
          return true;
      }
      if ("trace".equals(parameterName) ) {
          this.fTrace = (org.eclipse.viatra.transformation.views.traceability.Trace) newValue;
          return true;
      }
      if ("traceabilityId".equals(parameterName) ) {
          this.fTraceabilityId = (String) newValue;
          return true;
      }
      return false;
    }
    
    public void setSource(final EObject pSource) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fSource = pSource;
    }
    
    public void setId(final String pId) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fId = pId;
    }
    
    public void setTarget(final EObject pTarget) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fTarget = pTarget;
    }
    
    public void setTrace(final org.eclipse.viatra.transformation.views.traceability.Trace pTrace) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fTrace = pTrace;
    }
    
    public void setTraceabilityId(final String pTraceabilityId) {
      if (!isMutable()) throw new java.lang.UnsupportedOperationException();
      this.fTraceabilityId = pTraceabilityId;
    }
    
    @Override
    public String patternName() {
      return "org.eclipse.viatra.transformation.views.traceability.patterns.trace";
    }
    
    @Override
    public List<String> parameterNames() {
      return Trace.Match.parameterNames;
    }
    
    @Override
    public Object[] toArray() {
      return new Object[]{fSource, fId, fTarget, fTrace, fTraceabilityId};
    }
    
    @Override
    public Trace.Match toImmutable() {
      return isMutable() ? newMatch(fSource, fId, fTarget, fTrace, fTraceabilityId) : this;
    }
    
    @Override
    public String prettyPrint() {
      StringBuilder result = new StringBuilder();
      result.append("\"source\"=" + prettyPrintValue(fSource) + ", ");
      result.append("\"id\"=" + prettyPrintValue(fId) + ", ");
      result.append("\"target\"=" + prettyPrintValue(fTarget) + ", ");
      result.append("\"trace\"=" + prettyPrintValue(fTrace) + ", ");
      result.append("\"traceabilityId\"=" + prettyPrintValue(fTraceabilityId));
      return result.toString();
    }
    
    @Override
    public int hashCode() {
      return Objects.hash(fSource, fId, fTarget, fTrace, fTraceabilityId);
    }
    
    @Override
    public boolean equals(final Object obj) {
      if (this == obj)
          return true;
      if (obj == null) {
          return false;
      }
      if ((obj instanceof Trace.Match)) {
          Trace.Match other = (Trace.Match) obj;
          return Objects.equals(fSource, other.fSource) && Objects.equals(fId, other.fId) && Objects.equals(fTarget, other.fTarget) && Objects.equals(fTrace, other.fTrace) && Objects.equals(fTraceabilityId, other.fTraceabilityId);
      } else {
          // this should be infrequent
          if (!(obj instanceof IPatternMatch)) {
              return false;
          }
          IPatternMatch otherSig  = (IPatternMatch) obj;
          return Objects.equals(specification(), otherSig.specification()) && Arrays.deepEquals(toArray(), otherSig.toArray());
      }
    }
    
    @Override
    public Trace specification() {
      return Trace.instance();
    }
    
    /**
     * Returns an empty, mutable match.
     * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
     * 
     * @return the empty match.
     * 
     */
    public static Trace.Match newEmptyMatch() {
      return new Mutable(null, null, null, null, null);
    }
    
    /**
     * Returns a mutable (partial) match.
     * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
     * 
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return the new, mutable (partial) match object.
     * 
     */
    public static Trace.Match newMutableMatch(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return new Mutable(pSource, pId, pTarget, pTrace, pTraceabilityId);
    }
    
    /**
     * Returns a new (partial) match.
     * This can be used e.g. to call the matcher with a partial match.
     * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return the (partial) match object.
     * 
     */
    public static Trace.Match newMatch(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return new Immutable(pSource, pId, pTarget, pTrace, pTraceabilityId);
    }
    
    private static final class Mutable extends Trace.Match {
      Mutable(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
        super(pSource, pId, pTarget, pTrace, pTraceabilityId);
      }
      
      @Override
      public boolean isMutable() {
        return true;
      }
    }
    
    private static final class Immutable extends Trace.Match {
      Immutable(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
        super(pSource, pId, pTarget, pTrace, pTraceabilityId);
      }
      
      @Override
      public boolean isMutable() {
        return false;
      }
    }
  }
  
  /**
   * Generated pattern matcher API of the org.eclipse.viatra.transformation.views.traceability.patterns.trace pattern,
   * providing pattern-specific query methods.
   * 
   * <p>Use the pattern matcher on a given model via {@link #on(ViatraQueryEngine)},
   * e.g. in conjunction with {@link ViatraQueryEngine#on(QueryScope)}.
   * 
   * <p>Matches of the pattern will be represented as {@link Match}.
   * 
   * <p>Original source:
   * <code><pre>
   * pattern trace(source : EObject, id : java String, target : EObject, trace : Trace, traceabilityId : java String) {
   * 	Trace.params(trace, source);
   * 	Trace.targets(trace, target);
   * 	Trace.id(trace,id);
   * 	Traceability.id(traceability,traceabilityId);
   * 	Traceability.traces(traceability,trace);
   * } or {
   * 	Trace.objects(trace, source);
   * 	Trace.targets(trace, target);
   * 	Trace.id(trace,id);
   * 	Traceability.id(traceability,traceabilityId);
   * 	Traceability.traces(traceability,trace);
   * }
   * </pre></code>
   * 
   * @see Match
   * @see Trace
   * 
   */
  public static class Matcher extends BaseMatcher<Trace.Match> {
    /**
     * Initializes the pattern matcher within an existing VIATRA Query engine.
     * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
     * 
     * @param engine the existing VIATRA Query engine in which this matcher will be created.
     * @throws ViatraQueryRuntimeException if an error occurs during pattern matcher creation
     * 
     */
    public static Trace.Matcher on(final ViatraQueryEngine engine) {
      // check if matcher already exists
      Matcher matcher = engine.getExistingMatcher(querySpecification());
      if (matcher == null) {
          matcher = (Matcher)engine.getMatcher(querySpecification());
      }
      return matcher;
    }
    
    /**
     * @throws ViatraQueryRuntimeException if an error occurs during pattern matcher creation
     * @return an initialized matcher
     * @noreference This method is for internal matcher initialization by the framework, do not call it manually.
     * 
     */
    public static Trace.Matcher create() {
      return new Matcher();
    }
    
    private static final int POSITION_SOURCE = 0;
    
    private static final int POSITION_ID = 1;
    
    private static final int POSITION_TARGET = 2;
    
    private static final int POSITION_TRACE = 3;
    
    private static final int POSITION_TRACEABILITYID = 4;
    
    private static final Logger LOGGER = ViatraQueryLoggingUtil.getLogger(Trace.Matcher.class);
    
    /**
     * Initializes the pattern matcher within an existing VIATRA Query engine.
     * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
     * 
     * @param engine the existing VIATRA Query engine in which this matcher will be created.
     * @throws ViatraQueryRuntimeException if an error occurs during pattern matcher creation
     * 
     */
    private Matcher() {
      super(querySpecification());
    }
    
    /**
     * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return matches represented as a Match object.
     * 
     */
    public Collection<Trace.Match> getAllMatches(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllMatches(new Object[]{pSource, pId, pTarget, pTrace, pTraceabilityId}).collect(Collectors.toSet());
    }
    
    /**
     * Returns a stream of all matches of the pattern that conform to the given fixed values of some parameters.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return a stream of matches represented as a Match object.
     * 
     */
    public Stream<Trace.Match> streamAllMatches(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllMatches(new Object[]{pSource, pId, pTarget, pTrace, pTraceabilityId});
    }
    
    /**
     * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
     * Neither determinism nor randomness of selection is guaranteed.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return a match represented as a Match object, or null if no match is found.
     * 
     */
    public Optional<Trace.Match> getOneArbitraryMatch(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawGetOneArbitraryMatch(new Object[]{pSource, pId, pTarget, pTrace, pTraceabilityId});
    }
    
    /**
     * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
     * under any possible substitution of the unspecified parameters (if any).
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return true if the input is a valid (partial) match of the pattern.
     * 
     */
    public boolean hasMatch(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawHasMatch(new Object[]{pSource, pId, pTarget, pTrace, pTraceabilityId});
    }
    
    /**
     * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return the number of pattern matches found.
     * 
     */
    public int countMatches(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawCountMatches(new Object[]{pSource, pId, pTarget, pTrace, pTraceabilityId});
    }
    
    /**
     * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
     * Neither determinism nor randomness of selection is guaranteed.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @param processor the action that will process the selected match.
     * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
     * 
     */
    public boolean forOneArbitraryMatch(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId, final Consumer<? super Trace.Match> processor) {
      return rawForOneArbitraryMatch(new Object[]{pSource, pId, pTarget, pTrace, pTraceabilityId}, processor);
    }
    
    /**
     * Returns a new (partial) match.
     * This can be used e.g. to call the matcher with a partial match.
     * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
     * @param pSource the fixed value of pattern parameter source, or null if not bound.
     * @param pId the fixed value of pattern parameter id, or null if not bound.
     * @param pTarget the fixed value of pattern parameter target, or null if not bound.
     * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
     * @param pTraceabilityId the fixed value of pattern parameter traceabilityId, or null if not bound.
     * @return the (partial) match object.
     * 
     */
    public Trace.Match newMatch(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return Trace.Match.newMatch(pSource, pId, pTarget, pTrace, pTraceabilityId);
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<EObject> rawStreamAllValuesOfsource(final Object[] parameters) {
      return rawStreamAllValues(POSITION_SOURCE, parameters).map(EObject.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<EObject> getAllValuesOfsource() {
      return rawStreamAllValuesOfsource(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<EObject> streamAllValuesOfsource() {
      return rawStreamAllValuesOfsource(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<EObject> streamAllValuesOfsource(final Trace.Match partialMatch) {
      return rawStreamAllValuesOfsource(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<EObject> streamAllValuesOfsource(final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllValuesOfsource(new Object[]{null, pId, pTarget, pTrace, pTraceabilityId});
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<EObject> getAllValuesOfsource(final Trace.Match partialMatch) {
      return rawStreamAllValuesOfsource(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for source.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<EObject> getAllValuesOfsource(final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllValuesOfsource(new Object[]{null, pId, pTarget, pTrace, pTraceabilityId}).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for id.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<String> rawStreamAllValuesOfid(final Object[] parameters) {
      return rawStreamAllValues(POSITION_ID, parameters).map(String.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for id.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<String> getAllValuesOfid() {
      return rawStreamAllValuesOfid(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for id.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<String> streamAllValuesOfid() {
      return rawStreamAllValuesOfid(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for id.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<String> streamAllValuesOfid(final Trace.Match partialMatch) {
      return rawStreamAllValuesOfid(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for id.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<String> streamAllValuesOfid(final EObject pSource, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllValuesOfid(new Object[]{pSource, null, pTarget, pTrace, pTraceabilityId});
    }
    
    /**
     * Retrieve the set of values that occur in matches for id.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<String> getAllValuesOfid(final Trace.Match partialMatch) {
      return rawStreamAllValuesOfid(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for id.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<String> getAllValuesOfid(final EObject pSource, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllValuesOfid(new Object[]{pSource, null, pTarget, pTrace, pTraceabilityId}).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<EObject> rawStreamAllValuesOftarget(final Object[] parameters) {
      return rawStreamAllValues(POSITION_TARGET, parameters).map(EObject.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<EObject> getAllValuesOftarget() {
      return rawStreamAllValuesOftarget(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<EObject> streamAllValuesOftarget() {
      return rawStreamAllValuesOftarget(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<EObject> streamAllValuesOftarget(final Trace.Match partialMatch) {
      return rawStreamAllValuesOftarget(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<EObject> streamAllValuesOftarget(final EObject pSource, final String pId, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllValuesOftarget(new Object[]{pSource, pId, null, pTrace, pTraceabilityId});
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<EObject> getAllValuesOftarget(final Trace.Match partialMatch) {
      return rawStreamAllValuesOftarget(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for target.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<EObject> getAllValuesOftarget(final EObject pSource, final String pId, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace, final String pTraceabilityId) {
      return rawStreamAllValuesOftarget(new Object[]{pSource, pId, null, pTrace, pTraceabilityId}).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<org.eclipse.viatra.transformation.views.traceability.Trace> rawStreamAllValuesOftrace(final Object[] parameters) {
      return rawStreamAllValues(POSITION_TRACE, parameters).map(org.eclipse.viatra.transformation.views.traceability.Trace.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<org.eclipse.viatra.transformation.views.traceability.Trace> getAllValuesOftrace() {
      return rawStreamAllValuesOftrace(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<org.eclipse.viatra.transformation.views.traceability.Trace> streamAllValuesOftrace() {
      return rawStreamAllValuesOftrace(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<org.eclipse.viatra.transformation.views.traceability.Trace> streamAllValuesOftrace(final Trace.Match partialMatch) {
      return rawStreamAllValuesOftrace(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<org.eclipse.viatra.transformation.views.traceability.Trace> streamAllValuesOftrace(final EObject pSource, final String pId, final EObject pTarget, final String pTraceabilityId) {
      return rawStreamAllValuesOftrace(new Object[]{pSource, pId, pTarget, null, pTraceabilityId});
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<org.eclipse.viatra.transformation.views.traceability.Trace> getAllValuesOftrace(final Trace.Match partialMatch) {
      return rawStreamAllValuesOftrace(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for trace.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<org.eclipse.viatra.transformation.views.traceability.Trace> getAllValuesOftrace(final EObject pSource, final String pId, final EObject pTarget, final String pTraceabilityId) {
      return rawStreamAllValuesOftrace(new Object[]{pSource, pId, pTarget, null, pTraceabilityId}).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for traceabilityId.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    protected Stream<String> rawStreamAllValuesOftraceabilityId(final Object[] parameters) {
      return rawStreamAllValues(POSITION_TRACEABILITYID, parameters).map(String.class::cast);
    }
    
    /**
     * Retrieve the set of values that occur in matches for traceabilityId.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<String> getAllValuesOftraceabilityId() {
      return rawStreamAllValuesOftraceabilityId(emptyArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for traceabilityId.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Stream<String> streamAllValuesOftraceabilityId() {
      return rawStreamAllValuesOftraceabilityId(emptyArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for traceabilityId.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<String> streamAllValuesOftraceabilityId(final Trace.Match partialMatch) {
      return rawStreamAllValuesOftraceabilityId(partialMatch.toArray());
    }
    
    /**
     * Retrieve the set of values that occur in matches for traceabilityId.
     * </p>
     * <strong>NOTE</strong>: It is important not to modify the source model while the stream is being processed.
     * If the match set of the pattern changes during processing, the contents of the stream is <strong>undefined</strong>.
     * In such cases, either rely on {@link #getAllMatches()} or collect the results of the stream in end-user code.
     *      
     * @return the Stream of all values or empty set if there are no matches
     * 
     */
    public Stream<String> streamAllValuesOftraceabilityId(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace) {
      return rawStreamAllValuesOftraceabilityId(new Object[]{pSource, pId, pTarget, pTrace, null});
    }
    
    /**
     * Retrieve the set of values that occur in matches for traceabilityId.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<String> getAllValuesOftraceabilityId(final Trace.Match partialMatch) {
      return rawStreamAllValuesOftraceabilityId(partialMatch.toArray()).collect(Collectors.toSet());
    }
    
    /**
     * Retrieve the set of values that occur in matches for traceabilityId.
     * @return the Set of all values or empty set if there are no matches
     * 
     */
    public Set<String> getAllValuesOftraceabilityId(final EObject pSource, final String pId, final EObject pTarget, final org.eclipse.viatra.transformation.views.traceability.Trace pTrace) {
      return rawStreamAllValuesOftraceabilityId(new Object[]{pSource, pId, pTarget, pTrace, null}).collect(Collectors.toSet());
    }
    
    @Override
    protected Trace.Match tupleToMatch(final Tuple t) {
      try {
          return Trace.Match.newMatch((EObject) t.get(POSITION_SOURCE), (String) t.get(POSITION_ID), (EObject) t.get(POSITION_TARGET), (org.eclipse.viatra.transformation.views.traceability.Trace) t.get(POSITION_TRACE), (String) t.get(POSITION_TRACEABILITYID));
      } catch(ClassCastException e) {
          LOGGER.error("Element(s) in tuple not properly typed!",e);
          return null;
      }
    }
    
    @Override
    protected Trace.Match arrayToMatch(final Object[] match) {
      try {
          return Trace.Match.newMatch((EObject) match[POSITION_SOURCE], (String) match[POSITION_ID], (EObject) match[POSITION_TARGET], (org.eclipse.viatra.transformation.views.traceability.Trace) match[POSITION_TRACE], (String) match[POSITION_TRACEABILITYID]);
      } catch(ClassCastException e) {
          LOGGER.error("Element(s) in array not properly typed!",e);
          return null;
      }
    }
    
    @Override
    protected Trace.Match arrayToMatchMutable(final Object[] match) {
      try {
          return Trace.Match.newMutableMatch((EObject) match[POSITION_SOURCE], (String) match[POSITION_ID], (EObject) match[POSITION_TARGET], (org.eclipse.viatra.transformation.views.traceability.Trace) match[POSITION_TRACE], (String) match[POSITION_TRACEABILITYID]);
      } catch(ClassCastException e) {
          LOGGER.error("Element(s) in array not properly typed!",e);
          return null;
      }
    }
    
    /**
     * @return the singleton instance of the query specification of this pattern
     * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
     * 
     */
    public static IQuerySpecification<Trace.Matcher> querySpecification() {
      return Trace.instance();
    }
  }
  
  private Trace() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
   * 
   */
  public static Trace instance() {
    try{
        return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
        throw processInitializerError(err);
    }
  }
  
  @Override
  protected Trace.Matcher instantiate(final ViatraQueryEngine engine) {
    return Trace.Matcher.on(engine);
  }
  
  @Override
  public Trace.Matcher instantiate() {
    return Trace.Matcher.create();
  }
  
  @Override
  public Trace.Match newEmptyMatch() {
    return Trace.Match.newEmptyMatch();
  }
  
  @Override
  public Trace.Match newMatch(final Object... parameters) {
    return Trace.Match.newMatch((org.eclipse.emf.ecore.EObject) parameters[0], (java.lang.String) parameters[1], (org.eclipse.emf.ecore.EObject) parameters[2], (org.eclipse.viatra.transformation.views.traceability.Trace) parameters[3], (java.lang.String) parameters[4]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link Trace} to be created 
   *     <b>not</b> at the class load time of the outer class, 
   *     but rather at the first call to {@link Trace#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private static final Trace INSTANCE = new Trace();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private static final Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternal();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private static final Trace.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_source = new PParameter("source", "org.eclipse.emf.ecore.EObject", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/emf/2002/Ecore", "EObject")), PParameterDirection.INOUT);
    
    private final PParameter parameter_id = new PParameter("id", "java.lang.String", new JavaTransitiveInstancesKey(java.lang.String.class), PParameterDirection.INOUT);
    
    private final PParameter parameter_target = new PParameter("target", "org.eclipse.emf.ecore.EObject", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/emf/2002/Ecore", "EObject")), PParameterDirection.INOUT);
    
    private final PParameter parameter_trace = new PParameter("trace", "org.eclipse.viatra.transformation.views.traceability.Trace", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")), PParameterDirection.INOUT);
    
    private final PParameter parameter_traceabilityId = new PParameter("traceabilityId", "java.lang.String", new JavaTransitiveInstancesKey(java.lang.String.class), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_source, parameter_id, parameter_target, parameter_trace, parameter_traceabilityId);
    
    private GeneratedPQuery() {
      super(PVisibility.PUBLIC);
    }
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.transformation.views.traceability.patterns.trace";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","id","target","trace","traceabilityId");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() {
      setEvaluationHints(new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.UNSPECIFIED));
      Set<PBody> bodies = new LinkedHashSet<>();
      {
          PBody body = new PBody(this);
          PVariable var_source = body.getOrCreateVariableByName("source");
          PVariable var_id = body.getOrCreateVariableByName("id");
          PVariable var_target = body.getOrCreateVariableByName("target");
          PVariable var_trace = body.getOrCreateVariableByName("trace");
          PVariable var_traceabilityId = body.getOrCreateVariableByName("traceabilityId");
          PVariable var_traceability = body.getOrCreateVariableByName("traceability");
          new TypeConstraint(body, Tuples.flatTupleOf(var_source), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_id), new JavaTransitiveInstancesKey(java.lang.String.class));
          new TypeConstraint(body, Tuples.flatTupleOf(var_target), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_traceabilityId), new JavaTransitiveInstancesKey(java.lang.String.class));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_source, parameter_source),
             new ExportedParameter(body, var_id, parameter_id),
             new ExportedParameter(body, var_target, parameter_target),
             new ExportedParameter(body, var_trace, parameter_trace),
             new ExportedParameter(body, var_traceabilityId, parameter_traceabilityId)
          ));
          // 	Trace.params(trace, source)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "params")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_0_, var_source);
          // 	Trace.targets(trace, target)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_1_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_1_, var_target);
          // 	Trace.id(trace,id)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "id")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_2_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EString")));
          new Equality(body, var__virtual_2_, var_id);
          // 	Traceability.id(traceability,traceabilityId)
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability")));
          PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability", "id")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_3_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EString")));
          new Equality(body, var__virtual_3_, var_traceabilityId);
          // 	Traceability.traces(traceability,trace)
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability")));
          PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability", "traces")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_4_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new Equality(body, var__virtual_4_, var_trace);
          bodies.add(body);
      }
      {
          PBody body = new PBody(this);
          PVariable var_source = body.getOrCreateVariableByName("source");
          PVariable var_id = body.getOrCreateVariableByName("id");
          PVariable var_target = body.getOrCreateVariableByName("target");
          PVariable var_trace = body.getOrCreateVariableByName("trace");
          PVariable var_traceabilityId = body.getOrCreateVariableByName("traceabilityId");
          PVariable var_traceability = body.getOrCreateVariableByName("traceability");
          new TypeConstraint(body, Tuples.flatTupleOf(var_source), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_id), new JavaTransitiveInstancesKey(java.lang.String.class));
          new TypeConstraint(body, Tuples.flatTupleOf(var_target), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new TypeFilterConstraint(body, Tuples.flatTupleOf(var_traceabilityId), new JavaTransitiveInstancesKey(java.lang.String.class));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_source, parameter_source),
             new ExportedParameter(body, var_id, parameter_id),
             new ExportedParameter(body, var_target, parameter_target),
             new ExportedParameter(body, var_trace, parameter_trace),
             new ExportedParameter(body, var_traceabilityId, parameter_traceabilityId)
          ));
          // 	Trace.objects(trace, source)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "objects")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_0_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EJavaObject")));
          new Equality(body, var__virtual_0_, var_source);
          // 	Trace.targets(trace, target)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "targets")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_1_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EObject")));
          new Equality(body, var__virtual_1_, var_target);
          // 	Trace.id(trace,id)
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace", "id")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_2_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EString")));
          new Equality(body, var__virtual_2_, var_id);
          // 	Traceability.id(traceability,traceabilityId)
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability")));
          PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability", "id")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_3_), new EDataTypeInSlotsKey((EDataType)getClassifierLiteral("http://www.eclipse.org/emf/2002/Ecore", "EString")));
          new Equality(body, var__virtual_3_, var_traceabilityId);
          // 	Traceability.traces(traceability,trace)
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability")));
          PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
          new TypeConstraint(body, Tuples.flatTupleOf(var_traceability, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Traceability", "traces")));
          new TypeConstraint(body, Tuples.flatTupleOf(var__virtual_4_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/viatra/transformation/views/traceability/1.0", "Trace")));
          new Equality(body, var__virtual_4_, var_trace);
          bodies.add(body);
      }
      return bodies;
    }
  }
}
