/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.metamodel.code.generator;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.patternlanguage.emf.parser.antlr.internal.InternalEMFPatternLanguageLexer;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.AggregatedValue;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.BooleanLiteral;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.CallableRelation;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.CalledParameter;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.CheckConstraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.ClosureType;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.CompareConstraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.CompareFeature;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Constraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.EClassifierReference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.EnumValue;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Expression;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.FunctionEvaluationValue;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.GraphPattern;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.GraphPatternBody;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.JavaClassReference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.ListLiteral;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.NumberLiteral;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Parameter;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.ParameterDirection;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.ParameterRef;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PathExpressionConstraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PatternCall;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PatternCompositionConstraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.PatternPackage;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Reference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.ReferenceType;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.StringLiteral;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.UnaryType;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Variable;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class VqlCodeGenerator {
    private static final String INDENTATION = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("    ");
            return _builder.toString();
        }
    }.apply();

    public String generate(PatternPackage patternPackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _packageName = patternPackage.getPackageName();
        _builder.append(_packageName);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<EPackage> _packageImports = patternPackage.getPackageImports();
        for (EPackage packageImport : _packageImports) {
            CharSequence _packageImportCode = this.packageImportCode(packageImport);
            _builder.append((Object)_packageImportCode);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList<GraphPattern> _patterns = patternPackage.getPatterns();
        for (GraphPattern graphPattern : _patterns) {
            CharSequence _graphPatternCode = this.graphPatternCode(graphPattern);
            _builder.append((Object)_graphPatternCode);
            _builder.newLineIfNotEmpty();
        }
        String patternPackageCode = _builder.toString();
        return patternPackageCode;
    }

    private CharSequence packageImportCode(EPackage ePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import \"");
        String _nsURI = ePackage.getNsURI();
        _builder.append(_nsURI);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence graphPatternCode(GraphPattern graphPattern) {
        StringConcatenation _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("} or {");
        String bodySeperator = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        boolean _isPrivate = graphPattern.isPrivate();
        if (_isPrivate) {
            _builder_1.append("private ");
        }
        _builder_1.append("pattern ");
        String _name = graphPattern.getName();
        _builder_1.append(_name);
        _builder_1.append("(");
        _builder_1.newLineIfNotEmpty();
        CharSequence _parameterListCode = this.parameterListCode(graphPattern);
        _builder_1.append((Object)_parameterListCode);
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(") {");
        _builder_1.newLine();
        EList<GraphPatternBody> _bodies = graphPattern.getBodies();
        boolean _hasElements = false;
        for (GraphPatternBody body : _bodies) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder_1.appendImmediate((Object)bodySeperator, "");
            }
            CharSequence _patternBodyCode = this.patternBodyCode(body);
            _builder_1.append((Object)_patternBodyCode);
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.newLine();
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    private CharSequence parameterListCode(GraphPattern graphPattern) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Parameter> _parameters = graphPattern.getParameters();
        boolean _hasElements = false;
        for (Parameter parameter : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.newLineIfNotEmpty();
            _builder.append(INDENTATION);
            CharSequence _parameterCode = this.parameterCode(parameter);
            _builder.append((Object)_parameterCode);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence parameterCode(Parameter parameter) {
        StringConcatenation _xblockexpression = null;
        String _switchResult = null;
        ParameterDirection _direction = parameter.getDirection();
        if (_direction != null) {
            switch (_direction) {
                case IN: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("in ");
                    _switchResult = _builder.toString();
                    break;
                }
                case OUT: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("out ");
                    _switchResult = _builder_1.toString();
                    break;
                }
                case INOUT: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _switchResult = _builder_2.toString();
                    break;
                }
            }
        }
        String direction = _switchResult;
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append(direction);
        String _name = parameter.getName();
        _builder_3.append(_name);
        _builder_3.append(": ");
        CharSequence _typeCode = this.getTypeCode((UnaryType)IterableExtensions.head(parameter.getTypes()));
        _builder_3.append((Object)_typeCode);
        _xblockexpression = _builder_3;
        return _xblockexpression;
    }

    private CharSequence getTypeCode(UnaryType type) {
        StringConcatenation _builder;
        CharSequence _xblockexpression = null;
        if (type == null) {
            this.errorCode("Missing type declaration.");
        }
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (type instanceof EClassifierReference) {
            boolean _tripleNotEquals;
            _matched = true;
            _builder = new StringConcatenation();
            EClassifier _classifier = ((EClassifierReference)type).getClassifier();
            boolean bl = _tripleNotEquals = _classifier != null;
            if (_tripleNotEquals) {
                String _escapeTypeString = this.escapeTypeString(((EClassifierReference)type).getClassifier().getName());
                _builder.append(_escapeTypeString);
            } else {
                CharSequence _errorCode = this.errorCode("EClassifierReference's classifier is undeclared.");
                _builder.append((Object)_errorCode);
            }
            _switchResult = _builder;
        }
        if (!_matched && type instanceof JavaClassReference) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("java ");
            String _escapeTypeString = this.escapeTypeString(((JavaClassReference)type).getClassName());
            _builder.append(_escapeTypeString);
            _switchResult = _builder;
        }
        if (!_matched) {
            _switchResult = this.errorCode("Unexpected type declaration.");
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private String escapeTypeString(String typeString) {
        Functions.Function1 _function = name -> {
            boolean _tripleNotEquals;
            ANTLRStringStream _aNTLRStringStream = new ANTLRStringStream(name);
            InternalEMFPatternLanguageLexer lexer = new InternalEMFPatternLanguageLexer((CharStream)_aNTLRStringStream);
            int _type = lexer.nextToken().getType();
            boolean bl = _tripleNotEquals = _type != 5;
            if (_tripleNotEquals) {
                return "^" + name;
            }
            return name;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)typeString.split("\\."))), (Functions.Function1)_function), (CharSequence)".");
    }

    private CharSequence patternBodyCode(GraphPatternBody body) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _filter = Iterables.filter(body.getNodes(), Variable.class);
        for (Variable variable : _filter) {
            if (variable instanceof ParameterRef && variable.getTypes().isEmpty() && !((ParameterRef)variable).getReferredParam().getTypes().isEmpty()) {
                _builder.append(INDENTATION);
                CharSequence _typeCode = this.getTypeCode((UnaryType)((ParameterRef)variable).getReferredParam().getTypes().get(0));
                _builder.append((Object)_typeCode);
                _builder.append("(");
                String _expressionCode = this.expressionCode(variable);
                _builder.append(_expressionCode);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            EList<UnaryType> _types = variable.getTypes();
            for (UnaryType type : _types) {
                _builder.append(INDENTATION);
                CharSequence _typeCode_1 = this.getTypeCode(type);
                _builder.append((Object)_typeCode_1);
                _builder.append("(");
                String _expressionCode_1 = this.expressionCode(variable);
                _builder.append(_expressionCode_1);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        EList<Constraint> _constraints = body.getConstraints();
        for (Constraint constraint : _constraints) {
            _builder.append(INDENTATION);
            String _constraintCode = this.constraintCode(constraint);
            _builder.append(_constraintCode);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        EList<Expression> _nodes = body.getNodes();
        for (Expression node : _nodes) {
            if (!(node instanceof FunctionEvaluationValue) && !(node instanceof AggregatedValue)) continue;
            _builder.append(INDENTATION);
            CharSequence _complexExpressionCode = this.complexExpressionCode(node);
            _builder.append((Object)_complexExpressionCode);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String _constraintCode(CheckConstraint constraint) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("check(");
        String _expression = constraint.getExpression();
        _builder.append(_expression);
        _builder.append(")");
        return _builder.toString();
    }

    private String _constraintCode(PatternCompositionConstraint constraint) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNegative = constraint.isNegative();
        if (_isNegative) {
            _builder.append("neg ");
        }
        String _callableRelationCode = this.callableRelationCode(constraint.getCall());
        _builder.append(_callableRelationCode);
        return _builder.toString();
    }

    private String _constraintCode(CompareConstraint constraint) {
        StringConcatenation _builder = new StringConcatenation();
        String _expressionCode = this.expressionCode(constraint.getLeftOperand().getExpression());
        _builder.append(_expressionCode);
        _builder.append(" ");
        CompareFeature _feature = constraint.getFeature();
        _builder.append((Object)_feature);
        _builder.append(" ");
        String _expressionCode_1 = this.expressionCode(constraint.getRightOperand().getExpression());
        _builder.append(_expressionCode_1);
        return _builder.toString();
    }

    private String _constraintCode(PathExpressionConstraint constraint) {
        String _xblockexpression = null;
        ReferenceType edgeType = constraint.getEdgeType();
        if (edgeType == null) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _errorCode = this.errorCode("PathExpressionConstraint should have one edgeType at least.");
            _builder.append((Object)_errorCode);
            return _builder.toString();
        }
        EStructuralFeature feature = edgeType.getRefname();
        if (feature == null || feature.eIsProxy()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _errorCode_1 = this.errorCode("Unresolvable edge type.");
            _builder_1.append((Object)_errorCode_1);
            return _builder_1.toString();
        }
        EObject _eContainer = feature.eContainer();
        String mainClass = ((EClass)_eContainer).getName();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(mainClass);
        _builder_2.append(".");
        String _name = feature.getName();
        _builder_2.append(_name);
        _builder_2.append("(");
        String _expressionCode = this.expressionCode(constraint.getSrc().getExpression());
        _builder_2.append(_expressionCode);
        _builder_2.append(", ");
        String _expressionCode_1 = this.expressionCode(constraint.getDst().getExpression());
        _builder_2.append(_expressionCode_1);
        _builder_2.append(")");
        _xblockexpression = _builder_2.toString();
        return _xblockexpression;
    }

    private String expressionCode(Expression exp) {
        String _computeIndex;
        String _value;
        String _name;
        StringConcatenation _builder_1;
        String _xblockexpression = null;
        if (exp == null) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _errorCode = this.errorCode("Undeclared expression");
            _builder.append((Object)_errorCode);
            return _builder.toString();
        }
        String _switchResult = null;
        boolean _matched = false;
        if (exp instanceof EnumValue) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            String _literal = ((EnumValue)exp).getLiteral().getLiteral();
            _builder_1.append(_literal);
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof ParameterRef) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            _name = ((ParameterRef)exp).getReferredParam().getName();
            _builder_1.append(_name);
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof Variable) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            _name = ((Variable)exp).getName();
            _builder_1.append(_name);
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof StringLiteral) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            _builder_1.append("\"");
            _value = ((StringLiteral)exp).getValue();
            _builder_1.append(_value);
            _builder_1.append("\"");
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof NumberLiteral) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            _value = ((NumberLiteral)exp).getValue();
            _builder_1.append(_value);
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof BooleanLiteral) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            String _string = Boolean.valueOf(((BooleanLiteral)exp).isValue()).toString();
            _builder_1.append(_string);
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof ListLiteral) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            EList<Reference> _values = ((ListLiteral)exp).getValues();
            boolean _hasElements = false;
            for (Reference ref : _values) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_1.appendImmediate((Object)", ", "");
                }
                String _expressionCode = this.expressionCode(ref.getExpression());
                _builder_1.append(_expressionCode);
            }
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof FunctionEvaluationValue) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            _computeIndex = this.computeIndex(exp);
            _builder_1.append(_computeIndex);
            _switchResult = _builder_1.toString();
        }
        if (!_matched && exp instanceof AggregatedValue) {
            _matched = true;
            _builder_1 = new StringConcatenation();
            _computeIndex = this.computeIndex(exp);
            _builder_1.append(_computeIndex);
            _switchResult = _builder_1.toString();
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private CharSequence complexExpressionCode(Expression exp) {
        StringConcatenation _xifexpression = null;
        if (exp instanceof FunctionEvaluationValue) {
            StringConcatenation _builder = new StringConcatenation();
            String _computeIndex = this.computeIndex(exp);
            _builder.append(_computeIndex);
            _builder.append(" == eval(");
            String _expression = ((FunctionEvaluationValue)exp).getExpression();
            _builder.append(_expression);
            _builder.append(")");
            _xifexpression = _builder;
        } else {
            StringConcatenation _xifexpression_1 = null;
            if (exp instanceof AggregatedValue) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _computeIndex_1 = this.computeIndex(exp);
                _builder_1.append(_computeIndex_1);
                _builder_1.append(" == ");
                String _aggregatorClassName = ((AggregatedValue)exp).getAggregatorClassName();
                _builder_1.append(_aggregatorClassName);
                _builder_1.append(" ");
                String _callableRelationCode = this.callableRelationCode(((AggregatedValue)exp).getCall());
                _builder_1.append(_callableRelationCode);
                _xifexpression_1 = _builder_1;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String computeIndex(Expression exp) {
        EObject _eContainer = exp.eContainer();
        GraphPatternBody patternBody = (GraphPatternBody)_eContainer;
        int index = patternBody.getNodes().indexOf((Object)exp);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("expression");
        _builder.append((Object)index);
        return _builder.toString();
    }

    private String callableRelationCode(CallableRelation callableRelation) {
        StringConcatenation _builder_3;
        String _xblockexpression = null;
        String _switchResult = null;
        ClosureType _transitive = callableRelation.getTransitive();
        if (_transitive != null) {
            switch (_transitive) {
                case ORIGINAL: {
                    StringConcatenation _builder = new StringConcatenation();
                    _switchResult = _builder.toString();
                    break;
                }
                case REFLEXIVE_TRANSITIVE: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("*");
                    _switchResult = _builder_1.toString();
                    break;
                }
                case TRANSITIVE: {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("+");
                    _switchResult = _builder_2.toString();
                    break;
                }
            }
        }
        String closureType = _switchResult;
        String _switchResult_1 = null;
        boolean _matched = false;
        if (callableRelation instanceof PathExpressionConstraint) {
            _matched = true;
            _builder_3 = new StringConcatenation();
            _builder_3.append(closureType);
            String _constraintCode = this.constraintCode((Constraint)((Object)callableRelation));
            _builder_3.append(_constraintCode);
            _switchResult_1 = _builder_3.toString();
        }
        if (!_matched && callableRelation instanceof PatternCall) {
            _matched = true;
            _builder_3 = new StringConcatenation();
            CharSequence _PatternCallCode = this.PatternCallCode((PatternCall)callableRelation, closureType);
            _builder_3.append((Object)_PatternCallCode);
            _switchResult_1 = _builder_3.toString();
        }
        _xblockexpression = _switchResult_1;
        return _xblockexpression;
    }

    private CharSequence PatternCallCode(PatternCall patternCall, String closureType) {
        StringConcatenation _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        EList<CalledParameter> _parameters = patternCall.getParameters();
        boolean _hasElements = false;
        for (CalledParameter parameterCall : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _ParameterCallCode = this.ParameterCallCode(parameterCall);
            _builder.append(_ParameterCallCode);
        }
        String parameterList = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("find ");
        String _name = patternCall.getPatternRef().getName();
        _builder_1.append(_name);
        _builder_1.append(closureType);
        _builder_1.append("(");
        _builder_1.append(parameterList);
        _builder_1.append(")");
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    private String ParameterCallCode(CalledParameter parameterCall) {
        boolean _tripleEquals;
        String _xifexpression = null;
        Expression _expression = parameterCall.getExpression();
        boolean bl = _tripleEquals = _expression == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("_");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _expressionCode = this.expressionCode(parameterCall.getExpression());
            _builder_1.append(_expressionCode);
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    private CharSequence errorCode(String description) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<<<<<<<");
        _builder.append(description);
        _builder.append(">>>>>>>");
        return _builder;
    }

    private String constraintCode(Constraint constraint) {
        if (constraint instanceof CheckConstraint) {
            return this._constraintCode((CheckConstraint)constraint);
        }
        if (constraint instanceof CompareConstraint) {
            return this._constraintCode((CompareConstraint)constraint);
        }
        if (constraint instanceof PathExpressionConstraint) {
            return this._constraintCode((PathExpressionConstraint)constraint);
        }
        if (constraint instanceof PatternCompositionConstraint) {
            return this._constraintCode((PatternCompositionConstraint)constraint);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constraint).toString());
    }
}

