/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import org.eclipse.virgo.util.osgi.manifest.RequiredBundle;
import org.eclipse.virgo.util.osgi.manifest.Resolution;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.eclipse.virgo.util.osgi.manifest.internal.BaseCompoundHeaderEntry;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;

public class StandardRequiredBundle
extends BaseCompoundHeaderEntry
implements RequiredBundle {
    StandardRequiredBundle(HeaderParser parser, String name) {
        super(parser, name);
    }

    @Override
    public String getBundleSymbolicName() {
        return this.name;
    }

    @Override
    public Resolution getResolution() {
        String value = (String)this.getDirectives().get("resolution");
        if ("optional".equals(value)) {
            return Resolution.OPTIONAL;
        }
        return Resolution.MANDATORY;
    }

    @Override
    public RequiredBundle.Visibility getVisibility() {
        String value = (String)this.getDirectives().get("visibility");
        if ("reexport".equals(value)) {
            return RequiredBundle.Visibility.REEXPORT;
        }
        return RequiredBundle.Visibility.PRIVATE;
    }

    @Override
    public void setBundleSymbolicName(String bundleSymbolicName) {
        if (bundleSymbolicName == null) {
            throw new IllegalArgumentException("bundleSymbolicName must not be null");
        }
        this.name = bundleSymbolicName;
    }

    @Override
    public void setResolution(Resolution resolution) {
        if (resolution == null) {
            this.getDirectives().remove("resolution");
        } else {
            switch (resolution) {
                case OPTIONAL: {
                    this.getDirectives().put("resolution", "optional");
                    break;
                }
                default: {
                    this.getDirectives().remove("resolution");
                }
            }
        }
    }

    @Override
    public void setVisibility(RequiredBundle.Visibility visibility) {
        if (visibility == null) {
            this.getDirectives().remove("visibility");
        } else {
            switch (visibility) {
                case REEXPORT: {
                    this.getDirectives().put("visibility", "reexport");
                    break;
                }
                default: {
                    this.getDirectives().remove("visibility");
                }
            }
        }
    }

    @Override
    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        return parser.parseRequireBundleHeader(parseString).get(0);
    }

    @Override
    public VersionRange getBundleVersion() {
        return new VersionRange((String)this.getAttributes().get("bundle-version"));
    }

    @Override
    public void setBundleVersion(VersionRange versionRange) {
        if (versionRange == null) {
            this.getAttributes().remove("bundle-version");
        } else {
            this.getAttributes().put("bundle-version", versionRange.toParseString());
        }
    }
}

