/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.ui;

import java.lang.reflect.Method;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;

public class ServerEditorPageContentProvider
implements ITreeContentProvider {
    private IEditorPart[] pageParts;
    private ServerEditor editor;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ServerEditor) {
            this.editor = (ServerEditor)newInput;
            this.pageParts = new IEditorPart[this.getPageCount()];
            int i = 0;
            while (i < this.pageParts.length) {
                this.pageParts[i] = this.getEditor(i);
                ++i;
            }
        }
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        return element == this.editor && this.pageParts.length > 0;
    }

    public Object getParent(Object element) {
        IEditorPart[] iEditorPartArray = this.pageParts;
        int n = this.pageParts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart part = iEditorPartArray[n2];
            if (part == element) {
                return this.editor;
            }
            ++n2;
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this.editor) {
            return this.pageParts;
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.editor) {
            return this.pageParts;
        }
        return new Object[0];
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    private IEditorPart getEditor(int index) {
        try {
            Method method = MultiPageEditorPart.class.getDeclaredMethod("getEditor", Integer.TYPE);
            method.setAccessible(true);
            Object result = method.invoke((Object)this.editor, index);
            return (IEditorPart)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getPageCount() {
        try {
            Method method = MultiPageEditorPart.class.getDeclaredMethod("getPageCount", new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke((Object)this.editor, new Object[0]);
            return (Integer)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

