/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.ui.views;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProject;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProjectManager;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFileSelection;
import org.eclipse.virgo.ide.runtime.ui.views.CommonView;
import org.eclipse.wst.server.core.IServer;

public abstract class ServerFileCommonView
extends CommonView
implements ISelectionListener {
    private Collection<IFile> currentFiles;
    protected IResourceChangeListener resourceListener;

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (ServerFileCommonView.this.getServers().size() > 0) {
                    if (event.getType() != 1) {
                        return;
                    }
                    IResourceDelta rootDelta = event.getDelta();
                    boolean refresh = false;
                    block2: for (IServer server : ServerFileCommonView.this.getServers()) {
                        ServerProject project = ServerProjectManager.getInstance().getProject(server);
                        if (project == null) continue;
                        String[] stringArray = ServerFileCommonView.this.getManagedDirs();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String dir = stringArray[n2];
                            if (project.getWorkspaceProject() != null) {
                                IFolder folder = project.getWorkspaceProject().getFolder(dir);
                                IResourceDelta docDelta = rootDelta.findMember(folder.getFullPath());
                                if (docDelta == null) {
                                    return;
                                }
                                DeltaVisitor visitor = new DeltaVisitor();
                                try {
                                    docDelta.accept((IResourceDeltaVisitor)visitor);
                                }
                                catch (CoreException coreException) {}
                                if (visitor.change) {
                                    refresh = true;
                                    continue block2;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (refresh) {
                        ServerFileCommonView.this.refreshView();
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.currentFiles = new HashSet<IFile>();
    }

    protected void update() {
        this.currentFiles = new HashSet<IFile>();
        for (IServer server : this.getServers()) {
            Object[] elements;
            Object[] objectArray = elements = ((ITreeContentProvider)this.getCommonViewer().getContentProvider()).getElements((Object)server);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ServerFileSelection) {
                    this.currentFiles.add(((ServerFileSelection)object).getFile());
                }
                if (object instanceof IFile) {
                    this.currentFiles.add((IFile)object);
                }
                ++n2;
            }
        }
        super.update();
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
    }

    public abstract String[] getManagedDirs();

    private final class DeltaVisitor
    implements IResourceDeltaVisitor {
        boolean change;

        private DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (this.change) {
                return false;
            }
            if (delta.getKind() != 4) {
                return true;
            }
            if ((delta.getFlags() & 0x100) == 0) {
                return true;
            }
            IResource resource = delta.getResource();
            if (ServerFileCommonView.this.currentFiles.contains(resource)) {
                this.change = true;
            }
            return true;
        }
    }
}

