/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.LinkedList;
import org.apache.felix.cm.impl.ConfigurationManager;

public class UpdateThread
extends Thread {
    private ConfigurationManager configurationManager;
    private LinkedList updateTasks;

    public UpdateThread(ConfigurationManager configurationManager) {
        super("Configuration Updater");
        this.configurationManager = configurationManager;
        this.updateTasks = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Runnable task;
            LinkedList linkedList = this.updateTasks;
            synchronized (linkedList) {
                while (this.updateTasks.isEmpty()) {
                    try {
                        this.updateTasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                task = (Runnable)this.updateTasks.removeFirst();
            }
            if (task == this) {
                return;
            }
            try {
                this.configurationManager.log(4, "Running task " + task, null);
                task.run();
                continue;
            }
            catch (Throwable t) {
                this.configurationManager.log(1, "Unexpected problem executing task", t);
                continue;
            }
            break;
        }
    }

    void terminate() {
        this.schedule(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable update) {
        LinkedList linkedList = this.updateTasks;
        synchronized (linkedList) {
            this.configurationManager.log(4, "Scheduling task " + update, null);
            this.updateTasks.add(update);
            this.updateTasks.notifyAll();
        }
    }
}

