/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.war.deployer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.virgo.kernel.core.KernelConfig;
import org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.SimpleDeployer;
import org.eclipse.virgo.nano.deployer.StandardDeploymentIdentity;
import org.eclipse.virgo.nano.deployer.util.BundleInfosUpdater;
import org.eclipse.virgo.nano.war.deployer.NanoWARDeployerLogEvents;
import org.eclipse.virgo.nano.war.deployer.WebBundleUtils;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.io.JarUtils;
import org.eclipse.virgo.util.io.PathReference;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WARDeployer
implements SimpleDeployer {
    private static final String WAR = "war";
    private static final boolean STATUS_OK = true;
    private static final boolean STATUS_ERROR = false;
    private static final String PICKUP_DIR = "pickup";
    private static final String INSTALL_BY_REFERENCE_PREFIX = "reference:file:";
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private static final char DOT = '.';
    private static final char NEW_LINE = '\n';
    private static final String SUCCESS_MARK = "ok";
    private static final String ERROR_MARK = "error";
    private static final String OP_DEPLOY = "deploy";
    private static final String OP_UNDEPLOY = "undeploy";
    private static final String FEEDBACK_FILE_NAME = ".state";
    private static final String BUNDLE_ID_RECORD = "bundle-id";
    static final String LAST_MODIFIED = "last-modified";
    private static final String DELIMITER = "=";
    static final String EMPTY_STRING = "";
    private static final String WEBAPPS_DIR = "webapps";
    private static final String WEBBUNDLE_PROTOCOL = "webbundle";
    private static final String FILE_PROTOCOL = "file";
    private static final String UNKNOWN = "unknown";
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    private static final String HEADER_BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private EventLogger eventLogger;
    private BundleInfosUpdater bundleInfosUpdaterUtil;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private PackageAdmin packageAdmin;
    private WebBundleManifestTransformer webBundleManifestTransformer;
    private long largeFileCopyTimeout = 4000L;
    private File pickupDir;
    private File webAppsDir;
    private KernelConfig kernelConfig;

    public WARDeployer() {
        this.warDeployerInternalInit(null);
    }

    public WARDeployer(BundleContext bundleContext, PackageAdmin packageAdmin, WebBundleManifestTransformer webBundleManifestTransformer, EventLogger eventLogger, KernelConfig kernelConfig) {
        this.warDeployerInternalInit(bundleContext);
        this.packageAdmin = packageAdmin;
        this.webBundleManifestTransformer = webBundleManifestTransformer;
        this.eventLogger = eventLogger;
        this.kernelConfig = kernelConfig;
    }

    public void activate(ComponentContext context) {
        this.warDeployerInternalInit(context.getBundleContext());
    }

    public final boolean deploy(URI path) {
        Bundle installed;
        this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_INSTALLING, new Object[]{new File(path).toString()});
        String warName = this.extractWarNameFromString(path.toString());
        File deployedFile = new File(path);
        File warDir = new File(this.webAppsDir, warName);
        this.deleteStatusFile(warName, this.pickupDir);
        long bundleId = -1L;
        long lastModified = deployedFile.lastModified();
        if (!this.canWrite(path)) {
            this.logger.error("Cannot open the file " + path + " for writing. The configured timeout is " + this.largeFileCopyTimeout + ".");
            this.createStatusFile(warName, OP_DEPLOY, false, bundleId, lastModified);
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{path});
            return false;
        }
        try {
            JarUtils.unpackTo((PathReference)new PathReference(deployedFile), (PathReference)new PathReference(warDir));
            this.transformUnpackedManifest(warDir, warName);
            installed = this.bundleContext.installBundle(this.createInstallLocation(warDir));
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_INSTALLING_ERROR, (Throwable)e, new Object[]{path});
            this.createStatusFile(warName, OP_DEPLOY, false, bundleId, lastModified);
            return false;
        }
        this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_INSTALLED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_WEB_STARTING, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        try {
            installed.start();
            if (!this.isWebAppEnabled(installed)) {
                throw new Exception("Failed to enable application.");
            }
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_STARTING_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            this.createStatusFile(warName, OP_DEPLOY, false, bundleId, lastModified);
            return false;
        }
        this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_WEB_STARTED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        bundleId = installed.getBundleId();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Bundles info will be updated for war with path '" + path + "'.");
        }
        try {
            if (this.bundleInfosUpdaterUtil != null && this.bundleInfosUpdaterUtil.isAvailable()) {
                this.registerToBundlesInfo(installed);
            }
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            this.createStatusFile(warName, OP_DEPLOY, false, bundleId, lastModified);
            return false;
        }
        this.createStatusFile(warName, OP_DEPLOY, true, bundleId, lastModified);
        return true;
    }

    private boolean isWebAppEnabled(Bundle installed) throws InterruptedException {
        int counter = 0;
        int retries = Integer.valueOf(this.kernelConfig.getProperty("application.init.timeout"));
        while (counter < retries) {
            ServiceReference[] refs = installed.getRegisteredServices();
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    if (((String[])ref.getProperty("objectClass"))[0].equals(ServletContext.class.getCanonicalName())) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++counter;
            Thread.sleep(1000L);
        }
        return false;
    }

    public boolean isDeployFileValid(File file) {
        try {
            new JarFile(file);
        }
        catch (IOException iOException) {
            this.logger.error("The deployed file '" + file.getAbsolutePath() + "' is an invalid zip file.");
            return false;
        }
        return true;
    }

    private String createInstallLocation(File warDir) {
        return INSTALL_BY_REFERENCE_PREFIX + warDir.getAbsolutePath();
    }

    private String extractWarNameFromString(String path) {
        String warName = path.substring(path.lastIndexOf(47) + 1, path.length() - 4);
        return warName;
    }

    public final boolean undeploy(Bundle bundle) {
        String warName = bundle.getSymbolicName();
        File warDir = new File(this.webAppsDir, warName);
        this.deleteStatusFile(warName, this.pickupDir);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Removing bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
            }
            if (this.bundleInfosUpdaterUtil != null && this.bundleInfosUpdaterUtil.isAvailable()) {
                this.unregisterToBundlesInfo(bundle);
                this.logger.info("Successfully removed bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
            } else {
                this.logger.error("BundleInfosUpdater not available. Failed to remove bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
            }
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_STOPPING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            bundle.stop();
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_STOPPED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_UNINSTALLING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            bundle.uninstall();
            FileSystemUtils.deleteRecursively((File)warDir);
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_UNINSTALLED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
        }
        catch (BundleException e) {
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_UNDEPLOY_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            return false;
        }
        this.createStatusFile(warName, OP_UNDEPLOY, true, bundle.getBundleId(), bundle.getLastModified());
        return true;
    }

    public final boolean update(URI path) {
        String warName = this.extractWarNameFromString(path.toString());
        File updatedFile = new File(path);
        File warDir = new File(this.webAppsDir, warName);
        if (!warDir.exists()) {
            this.logger.info("Can't update artifact for path '" + path + "'. It is not deployed.");
        }
        this.deleteStatusFile(warName, this.pickupDir);
        long lastModified = updatedFile.lastModified();
        if (!this.canWrite(path)) {
            this.logger.error("Cannot open the file [" + path + "] for writing. Timeout is [" + this.largeFileCopyTimeout + "].");
            this.createStatusFile(warName, OP_DEPLOY, false, -1L, lastModified);
            this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_UPDATING_ERROR, new Object[]{path});
            return false;
        }
        Bundle bundle = this.bundleContext.getBundle(this.createInstallLocation(warDir));
        if (bundle != null) {
            try {
                JarUtils.unpackTo((PathReference)new PathReference(updatedFile), (PathReference)new PathReference(warDir));
                this.transformUnpackedManifest(warDir, warName);
                this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_UPDATING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                bundle.update();
                if (!this.isWebAppEnabled(bundle)) {
                    throw new Exception("Failed to enable application.");
                }
                if (this.packageAdmin != null) {
                    this.packageAdmin.refreshPackages(new Bundle[]{bundle});
                    this.logger.info("Update of file with path [" + path + "] is successful.");
                }
                this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_UPDATED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoWARDeployerLogEvents.NANO_UPDATE_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                this.createStatusFile(warName, OP_DEPLOY, false, -1L, lastModified);
                return false;
            }
            this.createStatusFile(warName, OP_DEPLOY, true, -1L, lastModified);
        } else {
            this.deploy(path);
        }
        return true;
    }

    public void setLargeFileCopyTimeout(long timeout) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("setLargeFileCopyTimeout(" + timeout + ")");
        }
        this.largeFileCopyTimeout = timeout;
    }

    private void createStatusFile(String warName, String operation, boolean status, long bundleId, long lastModified) {
        block6: {
            File stateDir = new File(this.pickupDir, FEEDBACK_FILE_NAME);
            if (!stateDir.exists() && !stateDir.mkdirs()) {
                this.logger.error("Cannot create directory [" + stateDir.getAbsolutePath() + "]. Status file for the operation cannot be created.");
                return;
            }
            File statusFile = new File(stateDir, String.valueOf(warName) + '.' + operation + '.' + (status ? SUCCESS_MARK : ERROR_MARK));
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(statusFile, true);
                    fw.write("bundle-id=" + bundleId);
                    fw.write(10);
                    fw.write("last-modified=" + lastModified);
                    fw.write(10);
                    fw.flush();
                }
                catch (IOException e) {
                    this.logger.error("Cannot update the status of operation.", (Throwable)e);
                    IOUtils.closeQuietly((Closeable)fw);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fw);
        }
    }

    private void deleteStatusFile(String warName, File pickupDir) {
        File stateDir = new File(pickupDir, FEEDBACK_FILE_NAME);
        if (stateDir.exists()) {
            File statusFile = new File(stateDir, String.valueOf(warName) + '.' + OP_DEPLOY + '.' + SUCCESS_MARK);
            if (statusFile.exists() && !statusFile.delete()) {
                this.logger.error("Cannot delete file [" + statusFile.getAbsolutePath() + "].");
            }
            if ((statusFile = new File(stateDir, String.valueOf(warName) + '.' + OP_DEPLOY + '.' + ERROR_MARK)).exists() && !statusFile.delete()) {
                this.logger.error("Cannot delete file [" + statusFile.getAbsolutePath() + "].");
            }
            if ((statusFile = new File(stateDir, String.valueOf(warName) + '.' + OP_UNDEPLOY + '.' + SUCCESS_MARK)).exists() && !statusFile.delete()) {
                this.logger.error("Cannot delete file [" + statusFile.getAbsolutePath() + "].");
            }
            if ((statusFile = new File(stateDir, String.valueOf(warName) + '.' + OP_UNDEPLOY + '.' + ERROR_MARK)).exists() && !statusFile.delete()) {
                this.logger.error("Cannot delete file [" + statusFile.getAbsolutePath() + "].");
            }
        }
    }

    private boolean canWrite(URI path) {
        int tries = -1;
        boolean isWritable = false;
        long timeout = this.largeFileCopyTimeout / 500L;
        while ((long)tries < timeout) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(path));
                isWritable = true;
            }
            catch (FileNotFoundException e) {
                block7: {
                    try {
                        if (!this.logger.isInfoEnabled()) break block7;
                        this.logger.info("File is still locked.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)fis);
            }
            IOUtils.closeQuietly((Closeable)fis);
            break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.error("InterruptedException occurred.", (Throwable)e);
            }
            ++tries;
        }
        return isWritable;
    }

    private final void transformUnpackedManifest(File srcFile, String warName) throws IOException {
        BundleManifest manifest;
        FileInputStream mfIS;
        FileOutputStream fos;
        File destFile;
        block7: {
            if (srcFile == null) {
                throw new NullPointerException("Source file is null.");
            }
            if (!srcFile.isDirectory() || !srcFile.canRead()) {
                throw new IllegalArgumentException("Source file must be a readable directory [" + srcFile + "].");
            }
            destFile = new File(srcFile, "META-INF/MANIFEST.MF");
            if (!destFile.exists()) {
                destFile.getParentFile().mkdirs();
                destFile.createNewFile();
            }
            if (!destFile.isFile() || !destFile.canRead()) {
                throw new IllegalArgumentException("Destination file must be a readable file [" + destFile + "].");
            }
            fos = null;
            mfIS = null;
            try {
                mfIS = new FileInputStream(srcFile + File.separator + "META-INF/MANIFEST.MF");
                manifest = BundleManifestFactory.createBundleManifest((Reader)new InputStreamReader(mfIS));
                if (!WebBundleUtils.isWebApplicationBundle(manifest)) break block7;
                this.logger.info("Skipping transformation of application '" + warName + "' because it is already a web bundle.");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(mfIS);
                throw throwable;
            }
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly((Closeable)mfIS);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        this.prepareInstallationOptions(warName, manifest, map);
        this.webBundleManifestTransformer.transform(manifest, srcFile.toURI().toURL(), new InstallationOptions(map), false);
        fos = new FileOutputStream(destFile);
        this.toManifest(manifest.toDictionary()).write(fos);
        IOUtils.closeQuietly((Closeable)fos);
        IOUtils.closeQuietly((Closeable)mfIS);
    }

    private void prepareInstallationOptions(String warName, BundleManifest manifest, Map<String, String> map) {
        String bundleSymbolicNameHeader;
        String webContextPathHeader = manifest.getHeader(HEADER_WEB_CONTEXT_PATH);
        if (webContextPathHeader == null || webContextPathHeader.trim().length() == 0) {
            map.put(HEADER_WEB_CONTEXT_PATH, warName);
        }
        if ((bundleSymbolicNameHeader = manifest.getHeader(HEADER_BUNDLE_SYMBOLIC_NAME)) == null || bundleSymbolicNameHeader.trim().length() == 0) {
            map.put(HEADER_BUNDLE_SYMBOLIC_NAME, warName);
        }
    }

    private final Manifest toManifest(Dictionary<String, String> headers) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        Enumeration<String> names = headers.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String value = headers.get(name);
            attributes.putValue(name, value);
        }
        return manifest;
    }

    private final void registerToBundlesInfo(Bundle bundle) throws URISyntaxException, IOException, BundleException {
        String location = bundle.getLocation().replace('\\', '/');
        if (!location.contains(WEBBUNDLE_PROTOCOL)) {
            String symbolicName;
            String scheme = new URI(location = location.replaceAll(" ", "%20")).getScheme();
            if (scheme != null && !scheme.equals(FILE_PROTOCOL)) {
                location = new URI(location).getRawSchemeSpecificPart();
            }
            this.bundleInfosUpdaterUtil.addBundleToBundlesInfo((symbolicName = bundle.getSymbolicName()) == null ? UNKNOWN : symbolicName, new URI(location), bundle.getVersion().toString(), 5, true);
            this.bundleInfosUpdaterUtil.updateBundleInfosRepository();
        }
    }

    private final void unregisterToBundlesInfo(Bundle bundle) {
        try {
            String location = bundle.getLocation().replace('\\', '/');
            if (!location.contains(WEBBUNDLE_PROTOCOL)) {
                String symbolicName;
                String scheme = new URI(location = location.replaceAll(" ", "%20")).getScheme();
                if (scheme != null && !scheme.equals(FILE_PROTOCOL)) {
                    location = new URI(location).getRawSchemeSpecificPart();
                }
                this.bundleInfosUpdaterUtil.removeBundleFromBundlesInfo((symbolicName = bundle.getSymbolicName()) == null ? UNKNOWN : symbolicName, new URI(location), bundle.getVersion().toString(), 5, true);
                this.bundleInfosUpdaterUtil.updateBundleInfosRepository();
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot update bundles info while unregistering [" + bundle.getSymbolicName() + "].", (Throwable)e);
        }
    }

    public boolean canServeFileType(String fileType) {
        return fileType.toLowerCase().equals(WAR);
    }

    public boolean isDeployed(URI path) {
        String warName = this.extractWarNameFromString(path.toString());
        File warDir = new File(this.webAppsDir, warName);
        if (!warDir.exists()) {
            return false;
        }
        return this.bundleContext.getBundle(this.createInstallLocation(warDir)) != null;
    }

    public DeploymentIdentity getDeploymentIdentity(URI path) {
        String warName = this.extractWarNameFromString(path.toString());
        File warDir = new File(this.webAppsDir, warName);
        if (!warDir.exists()) {
            return null;
        }
        Bundle bundle = this.bundleContext.getBundle(this.createInstallLocation(warDir));
        if (bundle == null) {
            return null;
        }
        return new StandardDeploymentIdentity(WAR, bundle.getSymbolicName(), bundle.getVersion().toString());
    }

    public List<String> getAcceptedFileTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(WAR);
        return types;
    }

    private void warDeployerInternalInit(BundleContext bundleContext) {
        String kernelHome = System.getProperty("org.eclipse.virgo.kernel.home");
        File kernelHomeFile = new File(kernelHome);
        File bundlesInfoFile = new File(kernelHomeFile, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        this.pickupDir = new File(kernelHomeFile, PICKUP_DIR);
        this.webAppsDir = new File(kernelHomeFile, WEBAPPS_DIR);
        this.bundleContext = bundleContext;
        this.bundleInfosUpdaterUtil = new BundleInfosUpdater(bundlesInfoFile, kernelHomeFile);
    }

    public void bindWebBundleManifestTransformer(WebBundleManifestTransformer transformer) {
        this.webBundleManifestTransformer = transformer;
    }

    public void unbindWebBundleManifestTransformer(WebBundleManifestTransformer transformer) {
        this.webBundleManifestTransformer = null;
    }

    public void bindEventLogger(EventLogger logger) {
        this.eventLogger = logger;
    }

    public void unbindEventLogger(EventLogger logger) {
        this.eventLogger = null;
    }

    public void bindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public void unbindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = null;
    }

    public void bindKernelConfig(KernelConfig kernelConfig) {
        this.kernelConfig = kernelConfig;
    }

    public void unbindKernelConfig(KernelConfig kernelConfig) {
        this.kernelConfig = null;
    }
}

