/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal.ovf;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.config.internal.ovf.OvfEnvironmentPropertiesReader;
import org.eclipse.virgo.nano.diagnostics.KernelLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.BundleContext;

public final class OvfPropertiesSource
implements PropertiesSource {
    static final String FRAMEWORK_PROPERTY_OVF = "org.eclipse.virgo.nano.config.ovf";
    private static final String PROPERTY_PREFIX = "cm:";
    private static final String PROPERTY_DELIMITER = ":";
    private final BundleContext bundleContext;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public OvfPropertiesSource(BundleContext bundleContext, EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.bundleContext = bundleContext;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, Properties> getConfigurationProperties() {
        try {
            Properties sourceProperties = this.readSourceProperties();
            if (sourceProperties != null) {
                return this.translateProperties(sourceProperties);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Map<String, Properties> translateProperties(Properties sourceProperties) {
        try {
            HashMap<String, Properties> hashMap;
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                HashMap<String, Properties> result = new HashMap<String, Properties>();
                Set<String> propertyNames = sourceProperties.stringPropertyNames();
                for (String propertyName : propertyNames) {
                    ConfigAdminProperty prop = this.tryReadConfigAdminProperty(propertyName);
                    if (prop == null) continue;
                    Properties p = (Properties)result.get(prop.pid);
                    if (p == null) {
                        p = new Properties();
                        result.put(prop.pid, p);
                    }
                    p.setProperty(prop.key, sourceProperties.getProperty(propertyName));
                }
                hashMap = result;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return hashMap;
        }
        catch (Throwable throwable) {
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private ConfigAdminProperty tryReadConfigAdminProperty(String propertyName) {
        try {
            ConfigAdminProperty configAdminProperty;
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                ConfigAdminProperty result = null;
                if (propertyName.startsWith(PROPERTY_PREFIX)) {
                    String parsed = propertyName.substring(PROPERTY_PREFIX.length());
                    String[] components = parsed.split(PROPERTY_DELIMITER);
                    if (components.length != 2) {
                        throw new IllegalArgumentException("Invalid configuration admin property '" + propertyName + "' found in OVF.");
                    }
                    result = new ConfigAdminProperty(null);
                    result.pid = components[0];
                    result.key = components[1];
                }
                configAdminProperty = result;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return configAdminProperty;
        }
        catch (Throwable throwable) {
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private Properties readSourceProperties() {
        try {
            Properties properties;
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                Properties result = null;
                File ovfFile = this.determineOvfFile();
                if (ovfFile != null) {
                    if (!ovfFile.exists()) {
                        this.eventLogger.log((LogEvent)KernelLogEvents.OVF_CONFIGURATION_FILE_DOES_NOT_EXIST, new Object[]{ovfFile.getAbsolutePath()});
                    } else {
                        result = this.readOvfFile(ovfFile);
                    }
                }
                properties = result;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return properties;
        }
        catch (Throwable throwable) {
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private File determineOvfFile() {
        try {
            File file;
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                File result = null;
                String path = this.bundleContext.getProperty(FRAMEWORK_PROPERTY_OVF);
                if (path != null) {
                    result = new File(path);
                }
                file = result;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return file;
        }
        catch (Throwable throwable) {
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private Properties readOvfFile(File ovfFile) {
        try {
            Properties properties;
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                Properties result;
                block9: {
                    result = null;
                    FileReader reader = null;
                    try {
                        try {
                            reader = new FileReader(ovfFile);
                            OvfEnvironmentPropertiesReader ovfReader = new OvfEnvironmentPropertiesReader();
                            result = ovfReader.readProperties(reader);
                        }
                        catch (IOException ex) {
                            this.eventLogger.log((LogEvent)KernelLogEvents.OVF_READ_ERROR, (Throwable)ex, new Object[]{ovfFile.getAbsolutePath()});
                            IOUtils.closeQuietly((Closeable)reader);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)reader);
                }
                properties = result;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return properties;
        }
        catch (Throwable throwable) {
            OvfPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("OvfPropertiesSource.java", Class.forName("org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "translateProperties", "org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource", "java.util.Properties:", "sourceProperties:", "", "java.util.Map"), 81);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "tryReadConfigAdminProperty", "org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource", "java.lang.String:", "propertyName:", "", "org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource$ConfigAdminProperty"), 105);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readSourceProperties", "org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource", "", "", "", "java.util.Properties"), 121);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineOvfFile", "org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource", "", "", "", "java.io.File"), 135);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readOvfFile", "org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource", "java.io.File:", "ovfFile:", "", "java.util.Properties"), 146);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource");
    }

    private static class ConfigAdminProperty {
        String pid;
        String key;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        private ConfigAdminProperty() {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ ConfigAdminProperty(ConfigAdminProperty configAdminProperty) {
            ConfigAdminProperty ajc$aspectInstance = this;
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource$ConfigAdminProperty");
        }
    }
}

