/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.res.StringManager;

public class SingleSignOn
extends ValveBase
implements SessionListener {
    protected Map<String, SingleSignOnEntry> cache = new HashMap<String, SingleSignOnEntry>();
    protected static final String info = "org.apache.catalina.authenticator.SingleSignOn";
    private boolean requireReauthentication = false;
    protected Map<Session, String> reverse = new HashMap<Session, String>();
    @Deprecated
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");
    private String cookieDomain;

    public SingleSignOn() {
        super(true);
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain != null && cookieDomain.trim().length() == 0 ? null : cookieDomain;
    }

    public boolean getRequireReauthentication() {
        return this.requireReauthentication;
    }

    public void setRequireReauthentication(boolean required) {
        this.requireReauthentication = required;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType()) && !"passivateSession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Process session destroyed on " + session));
        }
        String ssoId = null;
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            ssoId = this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        if (session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getThisAccessedTimeInternal() >= (long)(session.getMaxInactiveInterval() * 1000) || "passivateSession".equals(event.getType())) {
            this.removeSession(ssoId, session);
        } else {
            this.deregister(ssoId);
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Process request for '" + request.getRequestURI() + "'"));
        }
        if (request.getUserPrincipal() != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)(" Principal '" + request.getUserPrincipal().getName() + "' has already been authenticated"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!Constants.SINGLE_SIGN_ON_COOKIE.equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)" SSO cookie is not present");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)(" Checking for cached principal for " + cookie.getValue()));
        }
        if ((entry = this.lookup(cookie.getValue())) != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)(" Found cached principal '" + (entry.getPrincipal() != null ? entry.getPrincipal().getName() : "") + "' with auth type '" + entry.getAuthType() + "'"));
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (!this.getRequireReauthentication()) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(entry.getPrincipal());
            }
        } else {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associate(String ssoId, Session session) {
        SingleSignOnEntry sso;
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Associate sso id " + ssoId + " with session " + session));
        }
        if ((sso = this.lookup(ssoId)) != null) {
            sso.addSession(this, session);
        }
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            this.reverse.put(session, ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso == null) {
            return;
        }
        sso.removeSession(session);
        Session[] sessions = sso.findSessions();
        if (sessions == null || sessions.length == 0) {
            Map<String, SingleSignOnEntry> map2 = this.cache;
            synchronized (map2) {
                this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Deregistering sso id '" + ssoId + "'"));
        }
        SingleSignOnEntry sso = null;
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            sso = this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        Session[] sessions = sso.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)(" Invalidating session " + sessions[i]));
            }
            Map<Session, String> map2 = this.reverse;
            synchronized (map2) {
                this.reverse.remove(sessions[i]);
            }
            sessions[i].expire();
        }
    }

    protected boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.lookup(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Registering sso id '" + ssoId + "' for user '" + (principal != null ? principal.getName() : "") + "' with auth type '" + authType + "'"));
        }
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(String ssoId, Principal principal, String authType, String username, String password) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Update sso id " + ssoId + " to auth type " + authType));
            }
            SingleSignOnEntry singleSignOnEntry = sso;
            synchronized (singleSignOnEntry) {
                sso.updateCredentials(principal, authType, username, password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            return this.cache.get(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Removing session " + session.toString() + " from sso id " + ssoId));
        }
        if ((entry = this.lookup(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        Map<Session, String> map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        if (entry.findSessions().length == 0) {
            this.deregister(ssoId);
        }
    }
}

