/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.geronimo.connector.ConnectionReleaser;
import org.apache.geronimo.connector.ConnectorTransactionContext;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.TxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCachingInterceptor
implements ConnectionInterceptor,
ConnectionReleaser {
    protected static Logger log = LoggerFactory.getLogger((String)TransactionCachingInterceptor.class.getName());
    private final ConnectionInterceptor next;
    private final TransactionManager transactionManager;

    public TransactionCachingInterceptor(ConnectionInterceptor next, TransactionManager transactionManager) {
        this.next = next;
        this.transactionManager = transactionManager;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        Transaction transaction = TxUtil.getTransactionIfActive(this.transactionManager);
        if (transaction != null) {
            ManagedConnectionInfos managedConnectionInfos = ConnectorTransactionContext.get(transaction, this);
            if (connectionInfo.isUnshareable()) {
                if (!managedConnectionInfos.containsUnshared(connectionInfo.getManagedConnectionInfo())) {
                    this.next.getConnection(connectionInfo);
                    managedConnectionInfos.addUnshared(connectionInfo.getManagedConnectionInfo());
                    if (log.isTraceEnabled()) {
                        log.trace("Enlisting connection already associated with handle " + this.infoString(connectionInfo));
                    }
                }
            } else {
                ManagedConnectionInfo managedConnectionInfo = managedConnectionInfos.getShared();
                if (managedConnectionInfo != null) {
                    ManagedConnectionInfo previousMci = connectionInfo.getManagedConnectionInfo();
                    if (previousMci != null && previousMci != managedConnectionInfo && previousMci.getManagedConnection() != null) {
                        this.next.getConnection(connectionInfo);
                        managedConnectionInfos.addUnshared(previousMci);
                        if (log.isTraceEnabled()) {
                            log.trace("Enlisting existing connection associated with connection handle with current tx  " + this.infoString(connectionInfo));
                        }
                    } else {
                        connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
                        if (log.isTraceEnabled()) {
                            log.trace("supplying connection from tx cache  " + this.infoString(connectionInfo));
                        }
                    }
                } else {
                    this.next.getConnection(connectionInfo);
                    managedConnectionInfos.setShared(connectionInfo.getManagedConnectionInfo());
                    if (log.isTraceEnabled()) {
                        log.trace("supplying connection from pool " + connectionInfo.getConnectionHandle() + " for managed connection " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " to tx caching interceptor " + this);
                    }
                }
            }
        } else {
            this.next.getConnection(connectionInfo);
        }
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionReturnAction == ConnectionReturnAction.DESTROY) {
            if (log.isTraceEnabled()) {
                log.trace("destroying connection " + this.infoString(connectionInfo));
            }
            this.next.returnConnection(connectionInfo, connectionReturnAction);
            return;
        }
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction != null) {
                if (TxUtil.isActive(transaction)) {
                    if (log.isTraceEnabled()) {
                        log.trace("tx active, not returning connection  " + this.infoString(connectionInfo));
                    }
                    return;
                }
                ManagedConnectionInfos managedConnectionInfos = ConnectorTransactionContext.get(transaction, this);
                managedConnectionInfos.remove(connectionInfo.getManagedConnectionInfo());
                if (log.isTraceEnabled()) {
                    log.trace("tx ended, return during synchronization afterCompletion " + this.infoString(connectionInfo));
                }
            }
        }
        catch (SystemException e) {
            // empty catch block
        }
        if (log.isTraceEnabled()) {
            log.trace("tx ended, returning connection " + this.infoString(connectionInfo));
        }
        this.internalReturn(connectionInfo, connectionReturnAction);
    }

    private void internalReturn(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionInfo.getManagedConnectionInfo().hasConnectionHandles()) {
            if (log.isTraceEnabled()) {
                log.trace("not returning connection from tx cache (has handles) " + this.infoString(connectionInfo));
            }
            return;
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
        if (log.isTraceEnabled()) {
            log.trace("completed return of connection through tx cache " + this.infoString(connectionInfo));
        }
    }

    public void destroy() {
        this.next.destroy();
    }

    public void afterCompletion(Object stuff) {
        ManagedConnectionInfos managedConnectionInfos = (ManagedConnectionInfos)stuff;
        ManagedConnectionInfo sharedMCI = managedConnectionInfos.getShared();
        if (sharedMCI != null) {
            if (log.isTraceEnabled()) {
                log.trace("Transaction completed, attempting to return shared connection MCI: " + this.infoString(sharedMCI));
            }
            this.returnHandle(sharedMCI);
        }
        for (ManagedConnectionInfo managedConnectionInfo : managedConnectionInfos.getUnshared()) {
            if (log.isTraceEnabled()) {
                log.trace("Transaction completed, attempting to return unshared connection MCI: " + this.infoString(managedConnectionInfo));
            }
            this.returnHandle(managedConnectionInfo);
        }
    }

    private void returnHandle(ManagedConnectionInfo managedConnectionInfo) {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
        this.internalReturn(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
    }

    private String infoString(Object connectionInfo) {
        return "for tx caching interceptor " + this + " " + connectionInfo;
    }

    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[transactionManager=").append(this.transactionManager).append("]\n");
        this.next.info(s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ManagedConnectionInfos {
        private ManagedConnectionInfo shared;
        private Set<ManagedConnectionInfo> unshared = new HashSet<ManagedConnectionInfo>(1);

        public ManagedConnectionInfo getShared() {
            return this.shared;
        }

        public void setShared(ManagedConnectionInfo shared) {
            this.shared = shared;
        }

        public Set<ManagedConnectionInfo> getUnshared() {
            return this.unshared;
        }

        public void addUnshared(ManagedConnectionInfo unsharedMCI) {
            this.unshared.add(unsharedMCI);
        }

        public boolean containsUnshared(ManagedConnectionInfo unsharedMCI) {
            return this.unshared.contains(unsharedMCI);
        }

        public void remove(ManagedConnectionInfo managedConnectionInfo) {
            if (this.shared == managedConnectionInfo) {
                this.shared = null;
            } else {
                this.unshared.remove(managedConnectionInfo);
            }
        }
    }
}

