/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.AbstractContextProvider;
import org.eclipse.jetty.osgi.boot.ServiceProvider;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceContextProvider
extends AbstractContextProvider
implements ServiceProvider {
    private static final Logger LOG = Log.getLogger(AbstractContextProvider.class);
    private Map<ServiceReference, App> _serviceMap = new HashMap<ServiceReference, App>();
    private ServiceRegistration _serviceRegForServices;

    public ServiceContextProvider(ServerInstanceWrapper wrapper) {
        super(wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean serviceAdded(ServiceReference serviceRef, ContextHandler context) {
        if (context == null || serviceRef == null) {
            return false;
        }
        String watermark = (String)serviceRef.getProperty("o.e.j.o.b.watermark");
        if (watermark != null && !"".equals(watermark)) {
            return false;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getServerInstanceWrapper().getParentClassLoaderForWebapps());
        try {
            String contextFile = (String)serviceRef.getProperty("Jetty-ContextFilePath");
            if (contextFile == null) {
                contextFile = (String)serviceRef.getProperty("contextFilePath");
            }
            String[] keys = serviceRef.getPropertyKeys();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            if (keys != null) {
                for (String key : keys) {
                    ((Dictionary)properties).put(key, serviceRef.getProperty(key));
                }
            }
            Bundle bundle = serviceRef.getBundle();
            String originId = bundle.getSymbolicName() + "-" + bundle.getVersion().toString() + "-" + contextFile;
            ServiceApp app = new ServiceApp(this.getDeploymentManager(), (AppProvider)this, bundle, properties, contextFile, originId);
            app.setHandler(context);
            this._serviceMap.put(serviceRef, app);
            this.getDeploymentManager().addApp((App)app);
            boolean bl = true;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public boolean serviceRemoved(ServiceReference serviceRef, ContextHandler context) {
        if (context == null || serviceRef == null) {
            return false;
        }
        String watermark = (String)serviceRef.getProperty("o.e.j.o.b.watermark");
        if (watermark != null && !"".equals(watermark)) {
            return false;
        }
        App app = this._serviceMap.remove(serviceRef);
        if (app != null) {
            this.getDeploymentManager().removeApp(app);
            return true;
        }
        return false;
    }

    protected void doStart() throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", this.getServerInstanceWrapper().getManagedServerName());
        this._serviceRegForServices = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(ServiceProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this._serviceRegForServices != null) {
            try {
                this._serviceRegForServices.unregister();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        super.doStop();
    }

    public class ServiceApp
    extends AbstractContextProvider.OSGiApp {
        public ServiceApp(DeploymentManager manager, AppProvider provider, Bundle bundle, Dictionary properties, String contextFile, String originId) {
            super(manager, provider, bundle, properties, contextFile, originId);
        }

        public ServiceApp(DeploymentManager manager, AppProvider provider, String originId, Bundle bundle, String contextFile) {
            super(manager, provider, originId, bundle, contextFile);
        }

        @Override
        public void registerAsOSGiService() throws Exception {
        }

        @Override
        protected void deregisterAsOSGiService() throws Exception {
        }
    }
}

