/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.LoggingFilterOutputStream;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.FileSystemAware;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.ForwardingFilter;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.session.ServerSession;

public class ChannelSession
extends AbstractServerChannel {
    protected String type;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected Command command;
    protected OutputStream shellIn;
    protected StandardEnvironment env = new StandardEnvironment();

    public CloseFuture close(boolean immediately) {
        return (CloseFuture)super.close(immediately).addListener(new SshFutureListener(){

            public void operationComplete(SshFuture sshFuture) {
                if (ChannelSession.this.command != null) {
                    ChannelSession.this.command.destroy();
                    ChannelSession.this.command = null;
                }
                ChannelSession.this.remoteWindow.notifyClosed();
                IoUtils.closeQuietly(ChannelSession.this.in, ChannelSession.this.out, ChannelSession.this.err, ChannelSession.this.shellIn);
            }
        });
    }

    public void handleEof() throws IOException {
        super.handleEof();
        this.shellIn.close();
    }

    public void handleRequest(Buffer buffer) throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_REQUEST on channel {}", (Object)this.id);
        String type = buffer.getString();
        this.log.info("Received channel request: {}", (Object)type);
        if (!this.handleRequest(type, buffer)) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        this.shellIn.write(data, off, len);
        this.shellIn.flush();
    }

    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Server channel does not support extended data");
    }

    protected boolean handleRequest(String type, Buffer buffer) throws IOException {
        if ("env".equals(type)) {
            return this.handleEnv(buffer);
        }
        if ("pty-req".equals(type)) {
            return this.handlePtyReq(buffer);
        }
        if ("window-change".equals(type)) {
            return this.handleWindowChange(buffer);
        }
        if ("signal".equals(type)) {
            return this.handleSignal(buffer);
        }
        if ("shell".equals(type)) {
            if (this.checkType(type)) {
                return this.handleShell(buffer);
            }
            return false;
        }
        if ("exec".equals(type)) {
            if (this.checkType(type)) {
                return this.handleExec(buffer);
            }
            return false;
        }
        if ("subsystem".equals(type)) {
            if (this.checkType(type)) {
                return this.handleSubsystem(buffer);
            }
            return false;
        }
        if ("auth-agent-req@openssh.com".equals(type)) {
            return this.handleAgentForwarding(buffer);
        }
        if ("x11-req".equals(type)) {
            return this.handleX11Forwarding(buffer);
        }
        return type != null && type.endsWith("@putty.projects.tartarus.org");
    }

    private boolean checkType(String type) {
        if (this.type == null) {
            this.type = type;
            return true;
        }
        return false;
    }

    protected boolean handleEnv(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String name = buffer.getString();
        String value = buffer.getString();
        this.addEnvVariable(name, value);
        this.log.debug("env for channel {}: {} = {}", new Object[]{this.id, name, value});
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handlePtyReq(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String term = buffer.getString();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        byte[] modes = buffer.getBytes();
        int i = 0;
        while (i < modes.length && modes[i] != 0) {
            PtyMode mode = PtyMode.fromInt(modes[i++]);
            int val = modes[i++] << 24 & 0xFF000000 | modes[i++] << 16 & 0xFF0000 | modes[i++] << 8 & 0xFF00 | modes[i++] & 0xFF;
            this.getEnvironment().getPtyModes().put(mode, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("pty for channel {}: term={}, size=({} - {}), pixels=({}, {}), modes=[{}]", new Object[]{this.id, term, tColumns, tRows, tWidth, tHeight, this.getEnvironment().getPtyModes()});
        }
        this.addEnvVariable("TERM", term);
        this.addEnvVariable("COLUMNS", Integer.toString(tColumns));
        this.addEnvVariable("LINES", Integer.toString(tRows));
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleWindowChange(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        this.log.debug("window-change for channel {}: ({} - {}), ({}, {})", new Object[]{this.id, tColumns, tRows, tWidth, tHeight});
        StandardEnvironment e = this.getEnvironment();
        e.set("COLUMNS", Integer.toString(tColumns));
        e.set("LINES", Integer.toString(tRows));
        e.signal(Signal.WINCH);
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleSignal(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String name = buffer.getString();
        this.log.debug("Signal received on channel {}: {}", (Object)this.id, (Object)name);
        Signal signal = Signal.get(name);
        if (signal != null) {
            this.getEnvironment().signal(signal);
        } else {
            this.log.warn("Unknown signal received: " + name);
        }
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleShell(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        if (((ServerSession)this.session).getServerFactoryManager().getShellFactory() == null) {
            return false;
        }
        this.command = ((ServerSession)this.session).getServerFactoryManager().getShellFactory().create();
        this.prepareCommand();
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        this.command.start(this.getEnvironment());
        return true;
    }

    protected boolean handleExec(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String commandLine = buffer.getString();
        if (((ServerSession)this.session).getServerFactoryManager().getCommandFactory() == null) {
            return false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Executing command: {}", (Object)commandLine);
        }
        try {
            this.command = ((ServerSession)this.session).getServerFactoryManager().getCommandFactory().createCommand(commandLine);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        this.prepareCommand();
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        this.command.start(this.getEnvironment());
        return true;
    }

    protected boolean handleSubsystem(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        String subsystem = buffer.getString();
        List factories = ((ServerSession)this.session).getServerFactoryManager().getSubsystemFactories();
        if (factories == null) {
            return false;
        }
        this.command = (Command)NamedFactory.Utils.create(factories, subsystem);
        if (this.command == null) {
            return false;
        }
        this.prepareCommand();
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        this.command.start(this.getEnvironment());
        return true;
    }

    protected void prepareCommand() {
        this.addEnvVariable("USER", ((ServerSession)this.session).getUsername());
        if (this.command instanceof SessionAware) {
            ((SessionAware)((Object)this.command)).setSession((ServerSession)this.session);
        }
        if (this.command instanceof FileSystemAware) {
            FileSystemFactory factory = ((ServerSession)this.session).getServerFactoryManager().getFileSystemFactory();
            ((FileSystemAware)((Object)this.command)).setFileSystemView(factory.createFileSystemView(((ServerSession)this.session).getUsername()));
        }
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        this.err = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_EXTENDED_DATA);
        this.in = new ChannelPipedInputStream(this.localWindow);
        this.shellIn = new ChannelPipedOutputStream((ChannelPipedInputStream)this.in);
        if (this.log != null && this.log.isTraceEnabled()) {
            this.out = new LoggingFilterOutputStream(this.out, "OUT:", this.log);
            this.err = new LoggingFilterOutputStream(this.err, "ERR:", this.log);
            this.shellIn = new LoggingFilterOutputStream(this.shellIn, "IN: ", this.log);
        }
        this.command.setInputStream(this.in);
        this.command.setOutputStream(this.out);
        this.command.setErrorStream(this.err);
        this.command.setExitCallback(new ExitCallback(){

            public void onExit(int exitValue) {
                try {
                    ChannelSession.this.closeShell(exitValue);
                }
                catch (IOException e) {
                    ChannelSession.this.log.info("Error closing shell", (Throwable)e);
                }
            }

            public void onExit(int exitValue, String exitMessage) {
                this.onExit(exitValue);
            }
        });
    }

    protected int getPtyModeValue(PtyMode mode) {
        Integer v = this.getEnvironment().getPtyModes().get((Object)mode);
        return v != null ? v : 0;
    }

    protected boolean handleAgentForwarding(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        ServerSession server = (ServerSession)this.session;
        ForwardingFilter filter = server.getServerFactoryManager().getForwardingFilter();
        if (filter == null || !filter.canForwardAgent(server)) {
            if (wantReply) {
                buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE, 0);
                buffer.putInt(this.recipient);
                this.session.writePacket(buffer);
            }
            return true;
        }
        String authSocket = ((ServerSession)this.session).initAgentForward();
        this.addEnvVariable("SSH_AUTH_SOCK", authSocket);
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected boolean handleX11Forwarding(Buffer buffer) throws IOException {
        boolean wantReply = buffer.getBoolean();
        ServerSession server = (ServerSession)this.session;
        ForwardingFilter filter = server.getServerFactoryManager().getForwardingFilter();
        if (filter == null || !filter.canForwardX11(server)) {
            if (wantReply) {
                buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE, 0);
                buffer.putInt(this.recipient);
                this.session.writePacket(buffer);
            }
            return true;
        }
        String display = ((ServerSession)this.session).createX11Display(buffer.getBoolean(), buffer.getString(), buffer.getString(), buffer.getInt());
        if (display == null) {
            if (wantReply) {
                buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE, 0);
                buffer.putInt(this.recipient);
                this.session.writePacket(buffer);
            }
            return true;
        }
        this.addEnvVariable("DISPLAY", display);
        if (wantReply) {
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_SUCCESS, 0);
            buffer.putInt(this.recipient);
            this.session.writePacket(buffer);
        }
        return true;
    }

    protected void addEnvVariable(String name, String value) {
        this.getEnvironment().set(name, value);
    }

    protected StandardEnvironment getEnvironment() {
        return this.env;
    }

    protected void closeShell(int exitValue) throws IOException {
        this.sendEof();
        this.sendExitStatus(exitValue);
        this.close(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "session";
        }

        @Override
        public Channel create() {
            return new ChannelSession();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StandardEnvironment
    implements Environment {
        private final Map<Signal, Set<SignalListener>> listeners = new ConcurrentHashMap<Signal, Set<SignalListener>>(3);
        private final Map<String, String> env = new ConcurrentHashMap<String, String>();
        private final Map<PtyMode, Integer> ptyModes = new ConcurrentHashMap<PtyMode, Integer>();

        @Override
        public void addSignalListener(SignalListener listener, Signal ... signals) {
            if (signals == null) {
                throw new IllegalArgumentException("signals may not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            for (Signal s : signals) {
                this.getSignalListeners(s, true).add(listener);
            }
        }

        @Override
        public void addSignalListener(SignalListener listener) {
            this.addSignalListener(listener, EnumSet.allOf(Signal.class));
        }

        @Override
        public void addSignalListener(SignalListener listener, EnumSet<Signal> signals) {
            if (signals == null) {
                throw new IllegalArgumentException("signals may not be null");
            }
            this.addSignalListener(listener, signals.toArray(new Signal[signals.size()]));
        }

        @Override
        public Map<String, String> getEnv() {
            return this.env;
        }

        @Override
        public Map<PtyMode, Integer> getPtyModes() {
            return this.ptyModes;
        }

        @Override
        public void removeSignalListener(SignalListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener may not be null");
            }
            for (Signal s : EnumSet.allOf(Signal.class)) {
                Set<SignalListener> ls = this.getSignalListeners(s, false);
                if (ls == null) continue;
                ls.remove(listener);
            }
        }

        public void signal(Signal signal) {
            Set<SignalListener> ls = this.getSignalListeners(signal, false);
            if (ls != null) {
                for (SignalListener l : ls) {
                    l.signal(signal);
                }
            }
        }

        public void set(String key, String value) {
            this.getEnv().put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set<SignalListener> getSignalListeners(Signal signal, boolean create) {
            Set<SignalListener> ls = this.listeners.get((Object)signal);
            if (ls == null && create) {
                Map<Signal, Set<SignalListener>> map = this.listeners;
                synchronized (map) {
                    ls = this.listeners.get((Object)signal);
                    if (ls == null) {
                        ls = new CopyOnWriteArraySet<SignalListener>();
                        this.listeners.put(signal, ls);
                    }
                }
            }
            return ls;
        }
    }
}

