/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.equinox;

import java.util.ArrayList;

class EquinoxBootDelegationHelper {
    private final String[] exactPackageNames;
    private final String[] startsWithPackageNames;
    private final boolean allPackagesAreBootDelegated;

    public EquinoxBootDelegationHelper(String bootDelegationProperty) {
        boolean delegateAllPackages = false;
        ArrayList<String> stemMatches = new ArrayList<String>();
        ArrayList<String> exactMatches = new ArrayList<String>();
        if (bootDelegationProperty != null && bootDelegationProperty.trim().length() > 0) {
            String[] components;
            String[] stringArray = components = bootDelegationProperty.split(",");
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                if ((component = component.trim()).equals("*")) {
                    delegateAllPackages = true;
                } else if (component.length() > 2 && component.endsWith(".*")) {
                    stemMatches.add(component.substring(0, component.length() - 2));
                } else {
                    exactMatches.add(component);
                }
                ++n2;
            }
        }
        this.exactPackageNames = exactMatches.toArray(new String[exactMatches.size()]);
        this.startsWithPackageNames = stemMatches.toArray(new String[stemMatches.size()]);
        this.allPackagesAreBootDelegated = delegateAllPackages;
    }

    public boolean isBootDelegated(String className) {
        if (this.allPackagesAreBootDelegated) {
            return true;
        }
        String[] stringArray = this.startsWithPackageNames;
        int n = this.startsWithPackageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageStem = stringArray[n2];
            if (className.startsWith(packageStem)) {
                return true;
            }
            ++n2;
        }
        String packageName = EquinoxBootDelegationHelper.determinePackageName(className);
        if (packageName != null) {
            String[] stringArray2 = this.exactPackageNames;
            int n3 = this.exactPackageNames.length;
            n = 0;
            while (n < n3) {
                String exactPackage = stringArray2[n];
                if (packageName.equals(exactPackage)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static String determinePackageName(String className) {
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex == -1 || dotIndex == 0) {
            return null;
        }
        return className.substring(0, dotIndex);
    }
}

