/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.core.AbortableSignal;
import org.eclipse.virgo.kernel.core.Signal;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.Tree;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstallArtifact
implements InstallArtifact {
    private final Logger logger;
    private final Object monitor;
    private final ArtifactIdentity identity;
    protected final ArtifactStorage artifactStorage;
    private final Map<String, String> properties;
    private final Map<String, String> deploymentProperties;
    private final ArtifactStateMonitor artifactStateMonitor;
    private final String repositoryName;
    protected final EventLogger eventLogger;
    private Tree<InstallArtifact> tree;
    private volatile boolean isRefreshing;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;

    protected AbstractInstallArtifact(@NonNull ArtifactIdentity identity, @NonNull ArtifactStorage artifactStorage, @NonNull ArtifactStateMonitor artifactStateMonitor, String repositoryName, EventLogger eventLogger) {
        ArtifactStateMonitor artifactStateMonitor2 = artifactStateMonitor;
        ArtifactStorage artifactStorage2 = artifactStorage;
        ArtifactIdentity artifactIdentity = identity;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifactIdentity);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)artifactStorage2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)artifactStateMonitor2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.monitor = new Object();
            this.properties = new ConcurrentHashMap<String, String>();
            this.deploymentProperties = new ConcurrentHashMap<String, String>();
            this.identity = identity;
            this.artifactStorage = artifactStorage;
            this.artifactStateMonitor = artifactStateMonitor;
            this.repositoryName = repositoryName;
            this.eventLogger = eventLogger;
            this.isRefreshing = false;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    final ArtifactIdentity getIdentity() {
        try {
            return this.identity;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public final boolean isRefreshing() {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                boolean bl = this.isRefreshing;
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return bl;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void beginInstall() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                try {
                    this.artifactStateMonitor.onInstalling(this);
                }
                catch (DeploymentException de) {
                    this.failInstall();
                    throw de;
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void failInstall() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                this.artifactStateMonitor.onInstallFailed(this);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void endInstall() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                this.artifactStateMonitor.onInstalled(this);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void beginResolve() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
                this.pushThreadContext();
                try {
                    this.artifactStateMonitor.onResolving(this);
                }
                finally {
                    this.popThreadContext();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void failResolve() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
                this.pushThreadContext();
                try {
                    this.artifactStateMonitor.onResolveFailed(this);
                }
                finally {
                    this.popThreadContext();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void endResolve() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
                this.pushThreadContext();
                try {
                    this.artifactStateMonitor.onResolved(this);
                }
                finally {
                    this.popThreadContext();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final String getType() {
        try {
            return this.identity.getType();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final String getName() {
        try {
            return this.identity.getName();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final Version getVersion() {
        try {
            return this.identity.getVersion();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final String getScopeName() {
        try {
            return this.identity.getScopeName();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public InstallArtifact.State getState() {
        try {
            return this.artifactStateMonitor.getState();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void start() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
                this.start(null);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void start(AbortableSignal signal) throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_8);
                if (this.getState().equals((Object)InstallArtifact.State.ACTIVE)) {
                    if (signal != null) {
                        signal.signalSuccessfulCompletion();
                    }
                } else {
                    this.pushThreadContext();
                    try {
                        boolean stateChanged = this.artifactStateMonitor.onStarting(this);
                        if (stateChanged || signal != null) {
                            this.driveDoStart(signal);
                        }
                    }
                    finally {
                        this.popThreadContext();
                    }
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_8);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected final void driveDoStart(AbortableSignal signal) throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
                AbortableSignal stateMonitorSignal = this.createStateMonitorSignal(signal);
                this.doStart(stateMonitorSignal);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected final AbortableSignal createStateMonitorSignal(AbortableSignal signal) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
                StateMonitorSignal stateMonitorSignal = new StateMonitorSignal(signal);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
                return stateMonitorSignal;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected static void signalSuccessfulCompletion(Signal signal) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
                if (signal != null) {
                    signal.signalSuccessfulCompletion();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected static void signalFailure(Signal signal, Throwable e) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
                if (signal != null) {
                    signal.signalFailure(e);
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected static void signalAbortion(AbortableSignal signal) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_13);
                if (signal != null) {
                    signal.signalAborted();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_13);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_13);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected abstract void doStart(AbortableSignal var1) throws DeploymentException;

    private final void asyncStartSucceeded() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_14);
                this.pushThreadContext();
                try {
                    this.artifactStateMonitor.onStarted(this);
                }
                finally {
                    this.popThreadContext();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_14);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_14);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private final void asyncStartFailed(Throwable cause) {
        try {
            try {
                block9: {
                    AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_15);
                    this.pushThreadContext();
                    try {
                        try {
                            this.artifactStateMonitor.onStartFailed(this, cause);
                        }
                        catch (DeploymentException e) {
                            this.logger.error(String.format("listener for %s threw DeploymentException", this), (Throwable)e);
                            this.popThreadContext();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.popThreadContext();
                        throw throwable;
                    }
                    this.popThreadContext();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_15);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_15);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private final void asyncStartAborted() {
        try {
            try {
                block9: {
                    AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_16);
                    this.pushThreadContext();
                    try {
                        try {
                            this.artifactStateMonitor.onStartAborted(this);
                        }
                        catch (DeploymentException e) {
                            this.logger.error(String.format("listener for %s threw DeploymentException", this), (Throwable)e);
                            this.popThreadContext();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.popThreadContext();
                        throw throwable;
                    }
                    this.popThreadContext();
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_16);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_16);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void stop() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_17);
                if (this.getState().equals((Object)InstallArtifact.State.ACTIVE) || this.getState().equals((Object)InstallArtifact.State.STARTING)) {
                    this.pushThreadContext();
                    try {
                        this.artifactStateMonitor.onStopping(this);
                        try {
                            this.doStop();
                            this.artifactStateMonitor.onStopped(this);
                        }
                        catch (DeploymentException e) {
                            this.artifactStateMonitor.onStopFailed(this, e);
                        }
                    }
                    finally {
                        this.popThreadContext();
                    }
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_17);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_17);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected abstract void doStop() throws DeploymentException;

    @Override
    public void uninstall() throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_18);
                if (this.getState().equals((Object)InstallArtifact.State.STARTING) || this.getState().equals((Object)InstallArtifact.State.ACTIVE) || this.getState().equals((Object)InstallArtifact.State.RESOLVED) || this.getState().equals((Object)InstallArtifact.State.INSTALLED)) {
                    this.pushThreadContext();
                    try {
                        if (this.getState().equals((Object)InstallArtifact.State.ACTIVE) || this.getState().equals((Object)InstallArtifact.State.STARTING)) {
                            this.stop();
                        }
                        this.artifactStateMonitor.onUninstalling(this);
                        try {
                            this.doUninstall();
                            this.artifactStateMonitor.onUninstalled(this);
                        }
                        catch (DeploymentException e) {
                            this.artifactStateMonitor.onUninstallFailed(this, e);
                        }
                    }
                    finally {
                        this.artifactStorage.delete();
                        this.popThreadContext();
                    }
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_18);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_18);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected abstract void doUninstall() throws DeploymentException;

    @Override
    public final ArtifactFS getArtifactFS() {
        try {
            return this.artifactStorage.getArtifactFS();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String toString() {
        try {
            return this.identity.toString();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void pushThreadContext() {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_19);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_19);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_19);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void popThreadContext() {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_20);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_20);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_20);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected final ArtifactStateMonitor getStateMonitor() {
        try {
            return this.artifactStateMonitor;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public boolean refresh() throws DeploymentException {
        try {
            try {
                boolean bl;
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_21);
                try {
                    this.isRefreshing = true;
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESHING, new Object[]{this.getType(), this.getName(), this.getVersion()});
                    this.artifactStorage.synchronize();
                    boolean refreshed = this.doRefresh();
                    if (refreshed) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESHED, new Object[]{this.getType(), this.getName(), this.getVersion()});
                    } else {
                        this.failRefresh();
                    }
                    boolean bl2 = refreshed;
                    bl = bl2;
                }
                catch (DeploymentException de) {
                    this.failRefresh(de);
                    throw de;
                }
                catch (RuntimeException re) {
                    this.failRefresh(re);
                    throw re;
                }
                finally {
                    this.isRefreshing = false;
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_21);
                return bl;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_21);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void failRefresh() {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_22);
                this.failRefresh(null);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_22);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_22);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void failRefresh(Exception ex) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_23);
                this.artifactStorage.rollBack();
                if (ex == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_FAILED, new Object[]{this.getType(), this.getName(), this.getVersion()});
                } else {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_FAILED, (Throwable)ex, new Object[]{this.getType(), this.getName(), this.getVersion()});
                }
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_23);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_23);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected abstract boolean doRefresh() throws DeploymentException;

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getProperty(@NonNull String string) {
        String string2 = string;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)string2);
        try {
            void name;
            return this.properties.get(name);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final Set<String> getPropertyNames() {
        try {
            HashSet<String> propertyNames = new HashSet<String>(this.properties.keySet());
            return Collections.unmodifiableSet(propertyNames);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String setProperty(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)string4);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)string3);
        try {
            void value;
            void name;
            return this.properties.put((String)name, (String)value);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public Map<String, String> getDeploymentProperties() {
        try {
            return this.deploymentProperties;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final String getRepositoryName() {
        try {
            return this.repositoryName;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTree(Tree<InstallArtifact> tree) throws DeploymentException {
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.tree = tree;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Tree<InstallArtifact> getTree() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.tree;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$0(AbstractInstallArtifact arg0) throws DeploymentException {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_24);
                arg0.asyncStartSucceeded();
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_24);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_24);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$1(AbstractInstallArtifact arg0, Throwable arg1) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_25);
                arg0.asyncStartFailed(arg1);
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_25);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_25);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Logger access$2(AbstractInstallArtifact arg0) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_26);
                Logger logger = arg0.logger;
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_26);
                return logger;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_26);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$3(AbstractInstallArtifact arg0) {
        try {
            try {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_27);
                arg0.asyncStartAborted();
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_27);
                return;
            }
            catch (Throwable throwable) {
                AbstractInstallArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_27);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("AbstractInstallArtifact.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "isRefreshing", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "", "boolean"), 95);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beginInstall", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 100);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "createStateMonitorSignal", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.core.AbortableSignal:", "signal:", "", "org.eclipse.virgo.kernel.core.AbortableSignal"), 213);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "signalSuccessfulCompletion", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.core.Signal:", "signal:", "", "void"), 265);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "signalFailure", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.core.Signal:java.lang.Throwable:", "signal:e:", "", "void"), 271);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c", "signalAbortion", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.core.AbortableSignal:", "signal:", "", "void"), 277);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "asyncStartSucceeded", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 292);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "asyncStartFailed", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "java.lang.Throwable:", "cause:", "", "void"), 301);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "asyncStartAborted", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "", "void"), 312);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 327);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uninstall", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 352);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pushThreadContext", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "", "void"), 399);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "failInstall", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 109);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "popThreadContext", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "", "void"), 406);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "boolean"), 417);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "failRefresh", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "", "void"), 442);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "failRefresh", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "java.lang.Exception:", "ex:", "", "void"), 446);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact:", "arg0:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 291);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact:java.lang.Throwable:", "arg0:arg1:", "", "void"), 300);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$2", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact:", "arg0:", "", "org.slf4j.Logger"), 47);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$3", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact:", "arg0:", "", "void"), 311);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "endInstall", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 113);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beginResolve", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 117);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "failResolve", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 126);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "endResolve", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 135);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 182);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.core.AbortableSignal:", "signal:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 190);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "driveDoStart", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact", "org.eclipse.virgo.kernel.core.AbortableSignal:", "signal:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 208);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact");
    }

    private final class StateMonitorSignal
    implements AbortableSignal {
        private final AbortableSignal signal;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public StateMonitorSignal(AbortableSignal signal) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.signal = signal;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void signalSuccessfulCompletion() {
            try {
                try {
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                    try {
                        AbstractInstallArtifact.access$0(AbstractInstallArtifact.this);
                        AbstractInstallArtifact.signalSuccessfulCompletion((Signal)this.signal);
                    }
                    catch (DeploymentException de) {
                        this.signalFailure(de);
                    }
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                    return;
                }
                catch (Throwable throwable) {
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void signalFailure(Throwable cause) {
            try {
                try {
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                    AbstractInstallArtifact.access$1(AbstractInstallArtifact.this, cause);
                    try {
                        AbstractInstallArtifact.this.stop();
                    }
                    catch (DeploymentException de) {
                        AbstractInstallArtifact.access$2(AbstractInstallArtifact.this).error("Stop failed", (Throwable)de);
                    }
                    AbstractInstallArtifact.signalFailure((Signal)this.signal, cause);
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                    return;
                }
                catch (Throwable throwable) {
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void signalAborted() {
            try {
                try {
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                    AbstractInstallArtifact.access$3(AbstractInstallArtifact.this);
                    try {
                        AbstractInstallArtifact.this.stop();
                    }
                    catch (DeploymentException de) {
                        AbstractInstallArtifact.access$2(AbstractInstallArtifact.this).error("Stop aborted", (Throwable)de);
                    }
                    AbstractInstallArtifact.signalAbortion(this.signal);
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                    return;
                }
                catch (Throwable throwable) {
                    StateMonitorSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("AbstractInstallArtifact.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact$StateMonitorSignal"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signalSuccessfulCompletion", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact$StateMonitorSignal", "", "", "", "void"), 229);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signalFailure", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact$StateMonitorSignal", "java.lang.Throwable:", "cause:", "", "void"), 240);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signalAborted", "org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact$StateMonitorSignal", "", "", "", "void"), 253);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact$StateMonitorSignal");
        }
    }
}

