/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public abstract class RequestFilterValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestFilterValve/1.0";
    protected Pattern allow = null;
    protected Pattern deny = null;

    public RequestFilterValve() {
        super(true);
    }

    public String getAllow() {
        if (this.allow == null) {
            return null;
        }
        return this.allow.toString();
    }

    public void setAllow(String allow) {
        this.allow = allow == null || allow.length() == 0 ? null : Pattern.compile(allow);
    }

    public String getDeny() {
        if (this.deny == null) {
            return null;
        }
        return this.deny.toString();
    }

    public void setDeny(String deny) {
        this.deny = deny == null || deny.length() == 0 ? null : Pattern.compile(deny);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public abstract void invoke(Request var1, Response var2) throws IOException, ServletException;

    protected void process(String property, Request request, Response response) throws IOException, ServletException {
        if (this.deny != null && this.deny.matcher(property).matches()) {
            response.sendError(403);
            return;
        }
        if (this.allow != null && this.allow.matcher(property).matches()) {
            this.getNext().invoke(request, response);
            return;
        }
        if (this.deny != null && this.allow == null) {
            this.getNext().invoke(request, response);
            return;
        }
        response.sendError(403);
    }
}

