/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogListener;

public class ExtendedLogReaderServiceImpl
implements ExtendedLogReaderService {
    private final ExtendedLogReaderServiceFactory factory;
    private final Bundle bundle;
    private Set listeners = new HashSet();

    ExtendedLogReaderServiceImpl(ExtendedLogReaderServiceFactory factory, Bundle bundle) {
        this.factory = factory;
        this.bundle = bundle;
    }

    public synchronized void addLogListener(LogListener listener, LogFilter filter) {
        this.checkShutdown();
        if (listener == null) {
            throw new IllegalArgumentException("LogListener must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("LogFilter must not be null");
        }
        this.listeners.add(listener);
        this.factory.addLogListener(listener, filter);
    }

    public void addLogListener(LogListener listener) {
        this.addLogListener(listener, ExtendedLogReaderServiceFactory.NULL_LOGGER_FILTER);
    }

    public Enumeration getLog() {
        this.checkShutdown();
        return this.factory.getLog();
    }

    public synchronized void removeLogListener(LogListener listener) {
        this.checkShutdown();
        if (listener == null) {
            throw new IllegalArgumentException("LogListener must not be null");
        }
        this.factory.removeLogListener(listener);
        this.listeners.remove(listener);
    }

    private synchronized void checkShutdown() {
        if (this.listeners == null) {
            throw new IllegalStateException("LogReaderService for " + this.bundle.getSymbolicName() + " (id=" + this.bundle.getBundleId() + ") is shutdown.");
        }
    }

    synchronized void shutdown() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            this.factory.removeLogListener((LogListener)it.next());
        }
        this.listeners = null;
    }
}

