/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.FatalDeploymentException;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.ScopeNameFactory;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.BundleInstallArtifactGatheringGraphVisitor;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.ScopedPlanIdentifyingDirectedAcyclicGraphVisitor;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.ScopedPlanInstallArtifactProcessor;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ImportBundle;
import org.osgi.framework.Version;

final class SyntheticContextBundleCreatingTransformer
implements Transformer,
ScopedPlanInstallArtifactProcessor {
    private static final int SYNTHETIC_BUNDLE_MANIFEST_VERSION = 2;
    private static final String SYNTHETIC_CONTEXT_SUFFIX = "-synthetic.context";
    private final InstallArtifactGraphFactory installArtifactGraphFactory;
    private final ArtifactStorageFactory artifactStorageFactory;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    SyntheticContextBundleCreatingTransformer(InstallArtifactGraphFactory installArtifactGraphFactory, ArtifactStorageFactory artifactStorageFactory) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.installArtifactGraphFactory = installArtifactGraphFactory;
            this.artifactStorageFactory = artifactStorageFactory;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void transform(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException {
        try {
            try {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new ScopedPlanIdentifyingDirectedAcyclicGraphVisitor(this));
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void processScopedPlanInstallArtifact(GraphNode<InstallArtifact> graph) throws DeploymentException {
        try {
            try {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                if (!this.syntheticContextExists(graph)) {
                    Set<BundleInstallArtifact> childBundles = this.getBundlesInScope(graph);
                    PlanInstallArtifact planArtifact = (PlanInstallArtifact)graph.getValue();
                    String scopeName = this.determineSyntheticContextScopeName(planArtifact);
                    String name = String.valueOf(scopeName) + SYNTHETIC_CONTEXT_SUFFIX;
                    Version version = planArtifact.getVersion();
                    ArtifactIdentity identity = new ArtifactIdentity("bundle", name, version, scopeName);
                    BundleManifest syntheticContextBundleManifest = this.createSyntheticContextBundleManifest(identity, childBundles);
                    ArtifactStorage artifactStorage = this.artifactStorageFactory.createDirectoryStorage(identity, String.valueOf(name) + ".jar");
                    this.writeSyntheticContextBundle(syntheticContextBundleManifest, artifactStorage.getArtifactFS());
                    GraphNode<InstallArtifact> syntheticContextBundle = this.installArtifactGraphFactory.constructInstallArtifactGraph(identity, artifactStorage, null, null);
                    graph.addChild(syntheticContextBundle);
                }
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean syntheticContextExists(GraphNode<InstallArtifact> plan) {
        try {
            try {
                boolean bl;
                block5: {
                    SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                    PlanInstallArtifact planInstallArtifact = (PlanInstallArtifact)plan.getValue();
                    String syntheticContextBundleSymbolicName = String.valueOf(this.determineSyntheticContextScopeName(planInstallArtifact)) + SYNTHETIC_CONTEXT_SUFFIX;
                    List children = plan.getChildren();
                    for (GraphNode child : children) {
                        if (!syntheticContextBundleSymbolicName.equals(((InstallArtifact)child.getValue()).getName())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return bl;
            }
            catch (Throwable throwable) {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Set<BundleInstallArtifact> getBundlesInScope(GraphNode<InstallArtifact> plan) {
        try {
            BundleInstallArtifactGatheringGraphVisitor visitor = new BundleInstallArtifactGatheringGraphVisitor();
            plan.visit((GraphNode.DirectedAcyclicGraphVisitor)visitor);
            return visitor.getChildBundles();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void writeSyntheticContextBundle(BundleManifest syntheticContextBundleManifest, ArtifactFS artifactFS) {
        try {
            try {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                ArtifactFSEntry entry = artifactFS.getEntry("META-INF/MANIFEST.MF");
                OutputStreamWriter manifestWriter = new OutputStreamWriter(entry.getOutputStream());
                try {
                    try {
                        syntheticContextBundleManifest.write((Writer)manifestWriter);
                    }
                    catch (IOException ioe) {
                        throw new FatalDeploymentException("Failed to write out synthetic context's manifest", (Throwable)ioe);
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)manifestWriter);
                }
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private BundleManifest createSyntheticContextBundleManifest(ArtifactIdentity identity, Set<BundleInstallArtifact> childBundles) {
        try {
            try {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                BundleManifest bundleManifest = BundleManifestFactory.createBundleManifest();
                bundleManifest.setBundleVersion(identity.getVersion());
                bundleManifest.setBundleManifestVersion(2);
                bundleManifest.getBundleSymbolicName().setSymbolicName(identity.getName());
                bundleManifest.setModuleScope(identity.getScopeName());
                this.addImportForEachChildBundle(bundleManifest, childBundles);
                BundleManifest bundleManifest2 = bundleManifest;
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return bundleManifest2;
            }
            catch (Throwable throwable) {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String determineSyntheticContextScopeName(PlanInstallArtifact plan) {
        try {
            try {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                String string = ScopeNameFactory.createScopeName(plan.getName(), plan.getVersion());
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return string;
            }
            catch (Throwable throwable) {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void addImportForEachChildBundle(BundleManifest bundleManifest, Set<BundleInstallArtifact> childBundles) {
        try {
            try {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                ImportBundle importBundle = bundleManifest.getImportBundle();
                for (BundleInstallArtifact bundle : childBundles) {
                    String symbolicName = bundle.getName();
                    importBundle.addImportedBundle(symbolicName);
                }
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                SyntheticContextBundleCreatingTransformer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("SyntheticContextBundleCreatingTransformer.java", Class.forName("org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transform", "org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer", "org.eclipse.virgo.util.common.GraphNode:org.eclipse.virgo.kernel.install.environment.InstallEnvironment:", "installGraph:installEnvironment:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "processScopedPlanInstallArtifact", "org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer", "org.eclipse.virgo.util.common.GraphNode:", "graph:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 82);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "syntheticContextExists", "org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer", "org.eclipse.virgo.util.common.GraphNode:", "plan:", "", "boolean"), 106);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "writeSyntheticContextBundle", "org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "syntheticContextBundleManifest:artifactFS:", "", "void"), 124);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createSyntheticContextBundleManifest", "org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:java.util.Set:", "identity:childBundles:", "", "org.eclipse.virgo.util.osgi.manifest.BundleManifest"), 136);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineSyntheticContextScopeName", "org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer", "org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact:", "plan:", "", "java.lang.String"), 151);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addImportForEachChildBundle", "org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:java.util.Set:", "bundleManifest:childBundles:", "", "void"), 155);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.pipeline.stage.transform.internal.SyntheticContextBundleCreatingTransformer");
    }
}

