/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource;

import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.XAResourceWrapper;

public class GeronimoTransactionManagerFactory {
    private static final byte[] DEFAULT_TM_ID = new byte[]{71, 84, 77, 73, 68};
    private static final int DEFAULT_BUFFER_SIZE = 32;

    public static GeronimoTransactionManager create(int defaultTransactionTimeoutSeconds, boolean txRecovery, byte[] tmId, String bufferClassName, int bufferSizeKb, boolean checksumEnabled, boolean adler32Checksum, int flushSleepTimeMilliseconds, String logFileDir, String logFileExt, String logFileName, int maxBlocksPerFile, int maxBuffers, int maxLogFiles, int minBuffers, int threadsWaitingForceThreshold) throws Exception {
        XidFactoryImpl xidFactory = null;
        HOWLLog txLog = null;
        if (txRecovery) {
            SystemInstance.get().setComponent(XAResourceWrapper.class, (Object)new GeronimoXAResourceWrapper());
            xidFactory = new XidFactoryImpl(tmId == null ? DEFAULT_TM_ID : tmId);
            txLog = new HOWLLog(bufferClassName == null ? "org.apache.howl.log.BlockLogBuffer" : bufferClassName, bufferSizeKb == 0 ? 32 : bufferSizeKb, checksumEnabled, adler32Checksum, flushSleepTimeMilliseconds, logFileDir, logFileExt, logFileName, maxBlocksPerFile, maxBuffers, maxLogFiles, minBuffers, threadsWaitingForceThreshold, (XidFactory)xidFactory, SystemInstance.get().getBase().getDirectory("."));
            txLog.doStart();
        }
        return new GeronimoTransactionManager(defaultTransactionTimeoutSeconds, xidFactory, txLog);
    }

    public static class GeronimoXAResourceWrapper
    implements XAResourceWrapper {
        @Override
        public XAResource wrap(XAResource xaResource, String name) {
            return new WrapperNamedXAResource(xaResource, name);
        }
    }
}

