/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DOMUnmarshaller
implements PlatformUnmarshaller {
    private XMLParser parser;
    private XMLUnmarshaller xmlUnmarshaller;
    private boolean isResultAlwaysXMLRoot;

    public DOMUnmarshaller(XMLUnmarshaller xmlUnmarshaller, Map<String, Boolean> parserFeatures) {
        this.parser = parserFeatures == null ? XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser() : XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser(parserFeatures);
        this.parser.setNamespaceAware(true);
        this.parser.setValidationMode(0);
        this.xmlUnmarshaller = xmlUnmarshaller;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    @Override
    public int getValidationMode() {
        return this.parser.getValidationMode();
    }

    @Override
    public void setValidationMode(int validationMode) {
        this.parser.setValidationMode(validationMode);
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.parser.setWhitespacePreserving(isWhitespacePreserving);
    }

    @Override
    public void setSchemas(Object[] schemas) {
        try {
            this.parser.setXMLSchemas(schemas);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.errorSettingSchemas(e, schemas);
        }
    }

    @Override
    public void setSchema(Schema schema) {
        this.parser.setXMLSchema(schema);
    }

    @Override
    public Schema getSchema() {
        Schema schema = null;
        try {
            schema = this.parser.getXMLSchema();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        return schema;
    }

    @Override
    public Object unmarshal(File file) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(file);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(File file, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(file);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Node node) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element));
    }

    @Override
    public Object unmarshal(Node node, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), clazz);
    }

    @Override
    public Object unmarshal(Reader reader) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(reader);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Reader reader, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(reader);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Source source) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(source);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Source source, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(source);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(URL url) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(url);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(URL url, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(url);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
            xmlReader.setContentHandler(saxDocumentBuilder);
            xmlReader.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(saxDocumentBuilder.getDocument()));
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource, Class clazz) {
        if (this.xmlUnmarshaller.getMediaType() != MediaType.APPLICATION_XML) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
            xmlReader.setContentHandler(saxDocumentBuilder);
            xmlReader.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(saxDocumentBuilder.getDocument()), clazz);
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    protected XMLDescriptor getDescriptor(DOMRecord xmlRecord) throws XMLMarshalException {
        QName rootQName;
        XMLDescriptor xmlDescriptor = null;
        XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
        String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (type != null) {
            XPathFragment typeFragment = new XPathFragment(type);
            String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
            typeFragment.setNamespaceURI(namespaceURI);
            xmlDescriptor = xmlContext.getDescriptorByGlobalType(typeFragment);
        }
        if (xmlDescriptor == null && (xmlDescriptor = xmlContext.getDescriptor(rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName()))) == null) {
            throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
        }
        return xmlDescriptor;
    }

    public Object xmlToObject(DOMRecord xmlRecord) throws XMLMarshalException {
        XMLDescriptor xmlDescriptor = this.getDescriptor(xmlRecord);
        return this.xmlToObject(xmlRecord, xmlDescriptor.getJavaClass());
    }

    public Object xmlToObject(DOMRecord xmlRow, Class referenceClass) throws XMLMarshalException {
        try {
            String xmlEncoding = "UTF-8";
            String xmlVersion = "1.0";
            try {
                Method getEncoding = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlEncoding", new Class[0], true);
                Method getVersion = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlVersion", new Class[0], true);
                xmlEncoding = (String)PrivilegedAccessHelper.invokeMethod(getEncoding, xmlRow.getDocument(), new Object[0]);
                xmlVersion = (String)PrivilegedAccessHelper.invokeMethod(getVersion, xmlRow.getDocument(), new Object[0]);
            }
            catch (Exception exception) {}
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (XMLConversionManager.getDefaultJavaTypes().get(referenceClass) != null || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(referenceClass) || ClassConstants.DURATION.isAssignableFrom(referenceClass)) {
                String nodeVal;
                try {
                    Text rootTxt = (Text)xmlRow.getDOM().getFirstChild();
                    nodeVal = rootTxt.getNodeValue();
                }
                catch (Exception exception) {
                    nodeVal = null;
                }
                Object obj = ((XMLConversionManager)xmlContext.getSession(0).getDatasourcePlatform().getConversionManager()).convertObject(nodeVal, referenceClass);
                XMLRoot xmlRoot = new XMLRoot();
                xmlRoot.setObject(obj);
                String lName = xmlRow.getDOM().getLocalName();
                if (lName == null) {
                    lName = xmlRow.getDOM().getNodeName();
                }
                xmlRoot.setLocalName(lName);
                xmlRoot.setNamespaceURI(xmlRow.getDOM().getNamespaceURI());
                xmlRoot.setEncoding(xmlEncoding);
                xmlRoot.setVersion(xmlVersion);
                XMLRoot xMLRoot = xmlRoot;
                return xMLRoot;
            }
            AbstractSession readSession = xmlContext.getReadSession(referenceClass);
            XMLDescriptor descriptor = (XMLDescriptor)readSession.getDescriptor(referenceClass);
            if (descriptor == null) {
                throw XMLMarshalException.descriptorNotFoundInProject(referenceClass.getName());
            }
            Object object = null;
            if (xmlRow.getDOM().getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "nil") == null) {
                xmlRow.setUnmarshaller(this.xmlUnmarshaller);
                xmlRow.setDocPresPolicy(xmlContext.getDocumentPreservationPolicy(readSession));
                XMLObjectBuilder objectBuilder = (XMLObjectBuilder)descriptor.getObjectBuilder();
                ReadObjectQuery query = new ReadObjectQuery();
                query.setReferenceClass(referenceClass);
                query.setSession(readSession);
                object = objectBuilder.buildObject(query, xmlRow, null);
                this.xmlUnmarshaller.resolveReferences(readSession);
            }
            String elementNamespaceUri = xmlRow.getDOM().getNamespaceURI();
            String elementLocalName = xmlRow.getDOM().getLocalName();
            if (elementLocalName == null) {
                elementLocalName = xmlRow.getDOM().getNodeName();
            }
            String elementPrefix = xmlRow.getDOM().getPrefix();
            Object object2 = descriptor.wrapObjectInXMLRoot(object, elementNamespaceUri, elementLocalName, elementPrefix, xmlEncoding, xmlVersion, this.isResultAlwaysXMLRoot, true);
            return object2;
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }

    @Override
    public void mediaTypeChanged() {
    }
}

