/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class TableElementList
extends QueryTreeNodeVector {
    private int numColumns;
    private TableDescriptor td;

    public void addTableElement(TableElementNode tableElementNode) {
        this.addElement(tableElementNode);
        if (tableElementNode instanceof ColumnDefinitionNode || tableElementNode.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    void setCollationTypesOnCharacterStringColumns(SchemaDescriptor schemaDescriptor) throws StandardException {
        int n = this.size();
        int n2 = schemaDescriptor.getCollationType();
        for (int i = 0; i < n; ++i) {
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(i);
            this.setCollationTypeOnCharacterStringColumn(schemaDescriptor, columnDefinitionNode);
        }
    }

    void setCollationTypeOnCharacterStringColumn(SchemaDescriptor schemaDescriptor, ColumnDefinitionNode columnDefinitionNode) throws StandardException {
        int n = schemaDescriptor.getCollationType();
        DataTypeDescriptor dataTypeDescriptor = columnDefinitionNode.getType();
        if (dataTypeDescriptor == null) {
            if (columnDefinitionNode.hasGenerationClause()) {
                return;
            }
            throw StandardException.newException("42XA9", columnDefinitionNode.getColumnName());
        }
        if (dataTypeDescriptor.getTypeId().isStringTypeId()) {
            columnDefinitionNode.setCollationType(n);
        }
    }

    void validate(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        this.td = tableDescriptor;
        int n = 0;
        int n2 = this.size();
        Hashtable hashtable = new Hashtable(n2 + 2, 0.999f);
        Hashtable hashtable2 = new Hashtable(n2 + 2, 0.999f);
        Vector<Object> vector = new Vector<Object>();
        if (tableDescriptor != null && (constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor)) != null) {
            for (int i = 0; i < constraintDescriptorList.size(); ++i) {
                ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
                if (constraintDescriptor.getConstraintType() != 2 && constraintDescriptor.getConstraintType() != 3) continue;
                vector.addElement(constraintDescriptor);
            }
        }
        int n3 = 0;
        if (dDLStatementNode instanceof CreateTableNode) {
            n3 = ((CreateTableNode)dDLStatementNode).tableType;
        }
        for (int i = 0; i < n2; ++i) {
            Object object;
            String string;
            Object object2;
            Object object3;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (tableElementNode instanceof ColumnDefinitionNode) {
                object3 = (ColumnDefinitionNode)this.elementAt(i);
                if (n3 == 3 && (((ColumnDefinitionNode)object3).getType().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)object3).getType().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)object3).getColumnName());
                }
                this.checkForDuplicateColumns(dDLStatementNode, hashtable, ((ColumnDefinitionNode)object3).getColumnName());
                ((ColumnDefinitionNode)object3).checkUserType(tableDescriptor);
                ((ColumnDefinitionNode)object3).bindAndValidateDefault(dataDictionary, tableDescriptor);
                ((ColumnDefinitionNode)object3).validateAutoincrement(dataDictionary, tableDescriptor, n3);
                if (tableElementNode instanceof ModifyColumnNode) {
                    object2 = (ModifyColumnNode)object3;
                    ((ModifyColumnNode)object2).checkExistingConstraints(tableDescriptor);
                    ((ModifyColumnNode)object2).useExistingCollation(tableDescriptor);
                } else if (((ColumnDefinitionNode)object3).isAutoincrementColumn()) {
                    ++n;
                }
            } else if (tableElementNode.getElementType() == 7) {
                object3 = tableElementNode.getName();
                if (tableDescriptor.getColumnDescriptor((String)object3) != null) break;
                throw StandardException.newException("42X14", object3, (Object)tableDescriptor.getQualifiedName());
            }
            if (!tableElementNode.hasConstraint()) continue;
            object3 = (ConstraintDefinitionNode)tableElementNode;
            ((ConstraintDefinitionNode)object3).bind(dDLStatementNode, dataDictionary);
            if (((ConstraintDefinitionNode)object3).getConstraintType() == 2 || ((ConstraintDefinitionNode)object3).getConstraintType() == 3) {
                string = null;
                object = null;
                for (int j = 0; j < vector.size(); ++j) {
                    Object object4;
                    object2 = vector.elementAt(j);
                    if (object2 instanceof ConstraintDefinitionNode) {
                        object4 = (ConstraintDefinitionNode)object2;
                        string = ((ConstraintDefinitionNode)object4).getConstraintMoniker();
                        object = ((ConstraintDefinitionNode)object4).getColumnList().getColumnNames();
                    } else if (object2 instanceof ConstraintDescriptor) {
                        object4 = (ConstraintDescriptor)object2;
                        string = ((ConstraintDescriptor)object4).getConstraintName();
                        object = ((ConstraintDescriptor)object4).getColumnDescriptors().getColumnNames();
                    }
                    if (!this.columnsMatch(((ConstraintDefinitionNode)object3).getColumnList().getColumnNames(), (String[])object)) continue;
                    throw StandardException.newException("42Z93", (Object)((ConstraintDefinitionNode)object3).getConstraintMoniker(), (Object)string);
                }
                vector.addElement(object3);
            }
            if (object3 instanceof ConstraintDefinitionNode) {
                this.checkForDuplicateConstraintNames(dDLStatementNode, hashtable2, ((ConstraintDefinitionNode)object3).getConstraintMoniker());
            }
            if (((ConstraintDefinitionNode)object3).getConstraintType() == 5 && (object2 = ((ConstraintDefinitionNode)object3).getConstraintMoniker()) != null) {
                string = ((ConstraintDefinitionNode)object3).getDropSchemaName();
                object = string == null ? tableDescriptor.getSchemaDescriptor() : this.getSchemaDescriptor(string);
                ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptorByName(tableDescriptor, (SchemaDescriptor)object, (String)object2, false);
                if (constraintDescriptor == null) {
                    throw StandardException.newException("42X86", (Object)(object.getSchemaName() + "." + (String)object2), (Object)tableDescriptor.getQualifiedName());
                }
                this.getCompilerContext().createDependency(constraintDescriptor);
            }
            if (((ConstraintDefinitionNode)object3).hasPrimaryKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
                continue;
            }
            if (((ConstraintDefinitionNode)object3).hasUniqueKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
                if (dataDictionary.checkVersion(160, null)) continue;
                this.checkForNullColumns((ConstraintDefinitionNode)object3, tableDescriptor);
                continue;
            }
            if (!((ConstraintDefinitionNode)object3).hasForeignKeyConstraint()) continue;
            this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
        }
        if (n > 1) {
            throw StandardException.newException("428C1");
        }
    }

    public void validatePrimaryKeyNullability() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!tableElementNode.hasConstraint() || !(constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).hasPrimaryKeyConstraint()) continue;
            if (this.td == null) {
                this.setColumnListToNotNull(constraintDefinitionNode);
                continue;
            }
            this.checkForNullColumns(constraintDefinitionNode, this.td);
        }
    }

    public int countConstraints(int n) {
        int n2 = 0;
        int n3 = this.size();
        for (int i = 0; i < n3; ++i) {
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || n != (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType()) continue;
            ++n2;
        }
        return n2;
    }

    public int countGenerationClauses() {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ColumnDefinitionNode columnDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !(columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).hasGenerationClause()) continue;
            ++n;
        }
        return n;
    }

    public int countNumberOfColumns() {
        return this.numColumns;
    }

    public int genColumnInfos(ColumnInfo[] columnInfoArray) throws StandardException {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Object object;
            if (((TableElementNode)this.elementAt(i)).getElementType() == 7) {
                object = ((TableElementNode)this.elementAt(i)).getName();
                columnInfoArray[i] = new ColumnInfo((String)object, this.td.getColumnDescriptor((String)object).getType(), null, null, null, null, null, 1, 0L, 0L, 0L);
                break;
            }
            if (!(this.elementAt(i) instanceof ColumnDefinitionNode)) {
                ++n;
                continue;
            }
            object = (ColumnDefinitionNode)this.elementAt(i);
            ProviderList providerList = null;
            ProviderInfo[] providerInfoArray = null;
            if (((ColumnDefinitionNode)object).hasGenerationClause()) {
                providerList = ((ColumnDefinitionNode)object).getGenerationClauseNode().getAuxiliaryProviderList();
            }
            if (providerList != null && providerList.size() > 0) {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
            }
            columnInfoArray[i - n] = new ColumnInfo(((ColumnDefinitionNode)object).getColumnName(), ((ColumnDefinitionNode)object).getType(), ((ColumnDefinitionNode)object).getDefaultValue(), ((ColumnDefinitionNode)object).getDefaultInfo(), providerInfoArray, null, ((ColumnDefinitionNode)object).getOldDefaultUUID(), ((ColumnDefinitionNode)object).getAction(), ((ColumnDefinitionNode)object).isAutoincrementColumn() ? ((ColumnDefinitionNode)object).getAutoincrementStart() : 0L, ((ColumnDefinitionNode)object).isAutoincrementColumn() ? ((ColumnDefinitionNode)object).getAutoincrementIncrement() : 0L, ((ColumnDefinitionNode)object).isAutoincrementColumn() ? ((ColumnDefinitionNode)object).getAutoinc_create_or_modify_Start_Increment() : -1L);
            if (!((TableElementNode)object).hasConstraint()) continue;
            ++n;
        }
        return n;
    }

    public void appendNewColumnsToRCL(FromBaseTable fromBaseTable) throws StandardException {
        int n = this.size();
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        TableName tableName = fromBaseTable.getTableName();
        for (int i = 0; i < n; ++i) {
            if (!(this.elementAt(i) instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(i);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, columnDefinitionNode.getColumnName(), tableName, columnDefinitionNode.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDefinitionNode.getType(), valueNode, this.getContextManager());
            resultColumn.setName(columnDefinitionNode.getColumnName());
            resultColumnList.addElement(resultColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        int n = this.size();
        CompilerContext compilerContext = this.getCompilerContext();
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            Object object;
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType() != 4) continue;
            ValueNode valueNode = constraintDefinitionNode.getCheckCondition();
            int n2 = compilerContext.getReliability();
            try {
                object = new ProviderList();
                ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
                compilerContext.setCurrentAuxiliaryProviderList((ProviderList)object);
                compilerContext.setReliability(18041);
                valueNode = valueNode.bindExpression(fromList, null, vector);
                if (vector.size() != 0) {
                    throw StandardException.newException("42Y01", constraintDefinitionNode.getConstraintText());
                }
                valueNode = valueNode.checkIsBoolean();
                constraintDefinitionNode.setCheckCondition(valueNode);
                if (((Hashtable)object).size() > 0) {
                    constraintDefinitionNode.setAuxiliaryProviderList((ProviderList)object);
                }
                compilerContext.setCurrentAuxiliaryProviderList(providerList);
            }
            finally {
                compilerContext.setReliability(n2);
            }
            object = fromBaseTable.getResultColumns();
            int n3 = ((ResultColumnList)object).countReferencedColumns();
            int[] nArray = new int[n3];
            ((ResultColumnList)object).recordColumnReferences(nArray, 1);
            constraintDefinitionNode.setCheckColumnReferences(nArray);
            ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            ((ResultColumnList)object).copyReferencedColumnsToNewList(resultColumnList);
            if (constraintDefinitionNode.getColumnList() != null) {
                String string = ((ResultColumn)constraintDefinitionNode.getColumnList().elementAt(0)).getName();
                if (n3 > 1 || !string.equals(((ResultColumn)resultColumnList.elementAt(0)).getName())) {
                    throw StandardException.newException("42621", string);
                }
            }
            constraintDefinitionNode.setColumnList(resultColumnList);
            ((ResultColumnList)object).clearColumnReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateGenerationClauses(SchemaDescriptor schemaDescriptor, FromList fromList, FormatableBitSet formatableBitSet, TableDescriptor tableDescriptor) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        int n = fromBaseTable.getResultColumns().size();
        int n2 = this.size();
        this.findIllegalGenerationReferences(fromList, tableDescriptor);
        formatableBitSet.grow(n + 1);
        CompilerContext compilerContext = this.getCompilerContext();
        Vector vector = new Vector();
        for (int i = 0; i < n2; ++i) {
            String[] stringArray;
            Object object;
            Object object2;
            ColumnDefinitionNode columnDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !(columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).hasGenerationClause()) continue;
            GenerationClauseNode generationClauseNode = columnDefinitionNode.getGenerationClauseNode();
            int n3 = compilerContext.getReliability();
            ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
            try {
                object2 = new ProviderList();
                compilerContext.setCurrentAuxiliaryProviderList((ProviderList)object2);
                compilerContext.setReliability(30329);
                ValueNode valueNode = generationClauseNode.bindExpression(fromList, null, vector);
                DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
                object = columnDefinitionNode.getType();
                if (object == null) {
                    columnDefinitionNode.setType(dataTypeDescriptor);
                    resultColumnList.getResultColumn(columnDefinitionNode.getColumnName(), false).setType(dataTypeDescriptor);
                    this.setCollationTypeOnCharacterStringColumn(schemaDescriptor, columnDefinitionNode);
                    columnDefinitionNode.checkUserType(fromBaseTable.getTableDescriptor());
                } else {
                    TypeId typeId = ((DataTypeDescriptor)object).getTypeId();
                    stringArray = dataTypeDescriptor.getTypeId();
                    if (!this.getTypeCompiler((TypeId)stringArray).convertible(typeId, false)) {
                        throw StandardException.newException("42XA0", (Object)columnDefinitionNode.getName(), (Object)stringArray.getSQLTypeName());
                    }
                }
                if (vector.size() != 0) {
                    throw StandardException.newException("42XA1", columnDefinitionNode.getName());
                }
                if (((Hashtable)object2).size() > 0) {
                    generationClauseNode.setAuxiliaryProviderList((ProviderList)object2);
                }
            }
            finally {
                compilerContext.setCurrentAuxiliaryProviderList(providerList);
                compilerContext.setReliability(n3);
            }
            object2 = fromBaseTable.getResultColumns();
            int n4 = ((ResultColumnList)object2).countReferencedColumns();
            object = new int[n4];
            int n5 = ((ResultColumnList)object2).getPosition(columnDefinitionNode.getColumnName(), 1);
            formatableBitSet.set(n5);
            ((ResultColumnList)object2).recordColumnReferences((int[])object, 1);
            stringArray = new String[n4];
            for (int j = 0; j < n4; ++j) {
                stringArray[j] = ((ResultColumn)((QueryTreeNodeVector)object2).elementAt((int)(object[j] - true))).getName();
            }
            String string = this.getLanguageConnectionContext().getCurrentSchemaName();
            DefaultInfoImpl defaultInfoImpl = new DefaultInfoImpl(generationClauseNode.getExpressionText(), stringArray, string);
            columnDefinitionNode.setDefaultInfo(defaultInfoImpl);
            ((ResultColumnList)object2).clearColumnReferences();
        }
    }

    void findIllegalGenerationReferences(FromList fromList, TableDescriptor tableDescriptor) throws StandardException {
        int n;
        int n2;
        ArrayList<ColumnDefinitionNode> arrayList = new ArrayList<ColumnDefinitionNode>();
        HashSet<String> hashSet = new HashSet<String>();
        int n3 = this.size();
        if (tableDescriptor != null) {
            ColumnDescriptorList columnDescriptorList = tableDescriptor.getGeneratedColumns();
            n2 = columnDescriptorList.size();
            for (int i = 0; i < n2; ++i) {
                hashSet.add(columnDescriptorList.elementAt(i).getColumnName());
            }
        }
        for (n = 0; n < n3; ++n) {
            ColumnDefinitionNode columnDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(n);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !(columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).hasGenerationClause()) continue;
            arrayList.add(columnDefinitionNode);
            hashSet.add(columnDefinitionNode.getColumnName());
        }
        n = arrayList.size();
        for (n2 = 0; n2 < n; ++n2) {
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)arrayList.get(n2);
            GenerationClauseNode generationClauseNode = columnDefinitionNode.getGenerationClauseNode();
            Vector vector = generationClauseNode.findReferencedColumns();
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                String string = ((ColumnReference)vector.elementAt(i)).getColumnName();
                if (string == null || !hashSet.contains(string)) continue;
                throw StandardException.newException("42XA4", columnDefinitionNode.getColumnName());
            }
        }
    }

    void validateForeignKeysOnGenerationClauses(FromList fromList, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet.getNumBitsSet() <= 0) {
            return;
        }
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof FKConstraintDefinitionNode)) continue;
            FKConstraintDefinitionNode fKConstraintDefinitionNode = (FKConstraintDefinitionNode)tableElementNode;
            ConstraintInfo constraintInfo = fKConstraintDefinitionNode.getReferencedConstraintInfo();
            int n2 = constraintInfo.getReferentialActionDeleteRule();
            int n3 = constraintInfo.getReferentialActionUpdateRule();
            if (n3 != 1 && n3 != 2) {
                throw StandardException.newException("XSCB3.S");
            }
            if (n2 != 3 && n2 != 4) continue;
            ResultColumnList resultColumnList2 = fKConstraintDefinitionNode.getColumnList();
            int n4 = resultColumnList2.size();
            for (int j = 0; j < n4; ++j) {
                ResultColumn resultColumn = (ResultColumn)resultColumnList2.elementAt(j);
                String string = resultColumn.getName();
                int n5 = resultColumnList.getPosition(string, 1);
                if (!formatableBitSet.isSet(n5)) continue;
                throw StandardException.newException("42XA6", string);
            }
        }
    }

    void genConstraintActions(boolean bl, ConstraintConstantAction[] constraintConstantActionArray, String string, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary) throws StandardException {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = null;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            IndexConstantAction indexConstantAction = null;
            if (!tableElementNode.hasConstraint() || tableElementNode instanceof ColumnDefinitionNode) continue;
            ConstraintDefinitionNode constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode;
            if (constraintDefinitionNode.getColumnList() != null) {
                stringArray = new String[constraintDefinitionNode.getColumnList().size()];
                constraintDefinitionNode.getColumnList().exportNames(stringArray);
            }
            int n3 = constraintDefinitionNode.getConstraintType();
            String string2 = constraintDefinitionNode.getConstraintText();
            String string3 = constraintDefinitionNode.getConstraintMoniker();
            if (constraintDefinitionNode.requiresBackingIndex()) {
                if (constraintDefinitionNode.constraintType == 3 && dataDictionary.checkVersion(160, null)) {
                    boolean bl2 = this.areColumnsNullable(constraintDefinitionNode, this.td);
                    boolean bl3 = !bl2;
                    boolean bl4 = bl2;
                    indexConstantAction = this.genIndexAction(bl, bl3, bl4, null, constraintDefinitionNode, stringArray, true, schemaDescriptor, string, n3, dataDictionary);
                } else {
                    indexConstantAction = this.genIndexAction(bl, constraintDefinitionNode.requiresUniqueIndex(), false, null, constraintDefinitionNode, stringArray, true, schemaDescriptor, string, n3, dataDictionary);
                }
            }
            if (n3 == 5) {
                constraintConstantActionArray[n2] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(string3, constraintDefinitionNode.getDropSchemaName(), string, this.td.getUUID(), schemaDescriptor.getSchemaName(), indexConstantAction, constraintDefinitionNode.getDropBehavior(), constraintDefinitionNode.getVerifyType());
                continue;
            }
            ProviderList providerList = constraintDefinitionNode.getAuxiliaryProviderList();
            ConstraintInfo constraintInfo = null;
            ProviderInfo[] providerInfoArray = null;
            if (constraintDefinitionNode instanceof FKConstraintDefinitionNode) {
                constraintInfo = ((FKConstraintDefinitionNode)constraintDefinitionNode).getReferencedConstraintInfo();
            }
            if (providerList != null && providerList.size() > 0) {
                DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
            } else {
                providerInfoArray = new ProviderInfo[]{};
            }
            constraintConstantActionArray[n2++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(string3, n3, bl, string, this.td != null ? this.td.getUUID() : (UUID)null, schemaDescriptor.getSchemaName(), stringArray, indexConstantAction, string2, true, constraintInfo, providerInfoArray);
        }
    }

    private boolean columnsMatch(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            bl = false;
            for (int j = 0; j < n2; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean bl, boolean bl2, boolean bl3, String string, ConstraintDefinitionNode constraintDefinitionNode, String[] stringArray, boolean bl4, SchemaDescriptor schemaDescriptor, String string2, int n, DataDictionary dataDictionary) throws StandardException {
        if (string == null) {
            string = constraintDefinitionNode.getBackingIndexName(dataDictionary);
        }
        if (n == 5) {
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, string, string2, schemaDescriptor.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
        }
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(bl, bl2, bl3, "BTREE", schemaDescriptor.getSchemaName(), string, string2, this.td != null ? this.td.getUUID() : (UUID)null, stringArray, blArray, bl4, constraintDefinitionNode.getBackingIndexUUID(), this.checkIndexPageSizeProperty(constraintDefinitionNode));
    }

    private Properties checkIndexPageSizeProperty(ConstraintDefinitionNode constraintDefinitionNode) throws StandardException {
        Properties properties = constraintDefinitionNode.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.get("derby.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") != null) {
            return properties;
        }
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = 0;
        for (int i = 0; i < resultColumnList.size(); ++i) {
            String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
            DataTypeDescriptor dataTypeDescriptor = this.td == null ? this.getColumnDataTypeDescriptor(string) : this.getColumnDataTypeDescriptor(string, this.td);
            if (dataTypeDescriptor == null) continue;
            n += dataTypeDescriptor.getTypeId().getApproximateLengthInBytes(dataTypeDescriptor);
        }
        if (n > 1024) {
            properties.put("derby.storage.pageSize", "32768");
        }
        return properties;
    }

    private void checkForDuplicateColumns(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X12", string);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        if (string == null) {
            return;
        }
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X91", string);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode dDLStatementNode, ConstraintDefinitionNode constraintDefinitionNode) throws StandardException {
        String string;
        if (dDLStatementNode instanceof CreateTableNode && (string = constraintDefinitionNode.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", (Object)dDLStatementNode.getRelativeName(), (Object)string);
        }
        string = constraintDefinitionNode.getColumnList().verifyUniqueNames(false);
        if (string != null) {
            throw StandardException.newException("42X92", string);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode constraintDefinitionNode) {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
            this.findColumnDefinition(string).setNullability(false);
        }
    }

    private boolean areColumnsNullable(ConstraintDefinitionNode constraintDefinitionNode, TableDescriptor tableDescriptor) {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
            DataTypeDescriptor dataTypeDescriptor = tableDescriptor == null ? this.getColumnDataTypeDescriptor(string) : this.getColumnDataTypeDescriptor(string, tableDescriptor);
            if (dataTypeDescriptor == null || !dataTypeDescriptor.isNullable()) continue;
            return true;
        }
        return false;
    }

    private void checkForNullColumns(ConstraintDefinitionNode constraintDefinitionNode, TableDescriptor tableDescriptor) throws StandardException {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
            DataTypeDescriptor dataTypeDescriptor = tableDescriptor == null ? this.getColumnDataTypeDescriptor(string) : this.getColumnDataTypeDescriptor(string, tableDescriptor);
            if (dataTypeDescriptor == null || !dataTypeDescriptor.isNullable()) continue;
            String string2 = this.getLanguageConnectionContext().getDataDictionary().checkVersion(160, null) ? "42831.S.1" : "42831";
            throw StandardException.newException(string2, string);
        }
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string) {
        ColumnDefinitionNode columnDefinitionNode = this.findColumnDefinition(string);
        if (columnDefinitionNode != null) {
            return columnDefinitionNode.getType();
        }
        return null;
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string, TableDescriptor tableDescriptor) {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor != null) {
            return columnDescriptor.getType();
        }
        return this.getColumnDataTypeDescriptor(string);
    }

    private ColumnDefinitionNode findColumnDefinition(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ColumnDefinitionNode columnDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(i);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !string.equals((columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).getName())) continue;
            return columnDefinitionNode;
        }
        return null;
    }

    public boolean containsColumnName(String string) {
        return this.findColumnDefinition(string) != null;
    }
}

