/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtractExpression
extends AbstractSingleEncapsulatedExpression {
    private String datePart;
    private String fromIdentifier;
    private boolean hasFrom;
    private boolean hasSpaceAfterDatePart;
    private boolean hasSpaceAfterFrom;

    public ExtractExpression(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.hasDatePart()) {
            children.add(this.buildStringExpression(this.datePart));
        }
        if (this.hasSpaceAfterDatePart) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasFrom) {
            children.add(this.buildStringExpression("FROM"));
        }
        if (this.hasSpaceAfterFrom) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    @Override
    public String encapsulatedExpressionBNF() {
        return "scalar_expression";
    }

    public String getActualFromIdentifier() {
        return this.fromIdentifier != null ? this.fromIdentifier : "";
    }

    public String getDatePart() {
        return this.datePart;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("extract_expression");
    }

    public boolean hasDatePart() {
        return ExpressionTools.stringIsNotEmpty(this.datePart);
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasDatePart() || this.hasFrom || this.hasExpression();
    }

    public boolean hasFrom() {
        return this.hasFrom;
    }

    public boolean hasSpaceAfterDatePart() {
        return this.hasSpaceAfterDatePart;
    }

    public boolean hasSpaceAfterFrom() {
        return this.hasSpaceAfterFrom;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("FROM") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, int whitespaceCount, boolean tolerant) {
        if (wordParser.isTail()) {
            this.datePart = "";
            return;
        }
        this.datePart = wordParser.word();
        if (tolerant && (this.isParsingComplete(wordParser, this.datePart, null) || this.datePart.indexOf(46) > -1 || this.datePart.charAt(0) == '\'' || this.datePart.charAt(0) == '\"' || Character.isDigit(this.datePart.charAt(0)))) {
            this.datePart = "";
            this.hasSpaceAfterDatePart = whitespaceCount > 0;
        } else {
            wordParser.moveForward(this.datePart);
            this.hasSpaceAfterDatePart = wordParser.skipLeadingWhitespace() > 0;
        }
        this.hasFrom = wordParser.startsWithIdentifier("FROM");
        if (this.hasFrom) {
            this.fromIdentifier = wordParser.moveForward("FROM");
            this.hasSpaceAfterFrom = wordParser.skipLeadingWhitespace() > 0;
        }
        super.parseEncapsulatedExpression(wordParser, whitespaceCount, tolerant);
    }

    @Override
    protected String parseIdentifier(WordParser wordParser) {
        return "EXTRACT";
    }

    @Override
    protected void removeEncapsulatedExpression() {
        super.removeEncapsulatedExpression();
        this.hasFrom = false;
        this.datePart = "";
        this.fromIdentifier = null;
        this.hasSpaceAfterFrom = false;
        this.hasSpaceAfterDatePart = false;
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        writer.append(this.datePart);
        if (this.hasSpaceAfterDatePart) {
            writer.append(' ');
        }
        if (this.hasFrom) {
            writer.append(actual ? this.fromIdentifier : "FROM");
        }
        if (this.hasSpaceAfterFrom) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, actual);
    }
}

