/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.nano.shim.scope.Scope;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceScopingStrategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScopeFactory scopeFactory;
    private ScopeServiceRepository scopeServiceRepository;

    public ServiceScopingStrategy(ScopeFactory scopeFactory, ScopeServiceRepository scopeServiceRepository) {
        this.scopeFactory = scopeFactory;
        this.scopeServiceRepository = scopeServiceRepository;
    }

    boolean isPotentiallyVisible(ServiceReference<?> serviceReference, BundleContext consumingBundleContext) {
        Scope bundleScope;
        boolean matchesScope = true;
        Scope serviceScope = this.getServiceScope(serviceReference);
        if (serviceScope != null && !serviceScope.isGlobal() && !(bundleScope = this.scopeFactory.getBundleScope(consumingBundleContext.getBundle())).equals(serviceScope)) {
            matchesScope = false;
        }
        return matchesScope;
    }

    void scopeReferences(Collection<ServiceReference<?>> references, BundleContext consumingBundleContext, String className, String filter) {
        Collection<ServiceReference<?>> scopedReferences;
        Bundle consumingBundle = consumingBundleContext.getBundle();
        Scope lookupScope = this.getLookupScope(consumingBundle, className, filter);
        Scope consumerScope = this.getBundleScope(consumingBundle);
        if (lookupScope.isGlobal() && !consumerScope.isGlobal() && !(scopedReferences = this.getScopedReferences(references, consumerScope)).isEmpty()) {
            this.removeAllExcept(references, scopedReferences);
            return;
        }
        this.restrictServicesToScope(references, lookupScope);
    }

    private void removeAllExcept(Collection<ServiceReference<?>> references, Collection<ServiceReference<?>> scopedReferences) {
        Iterator<ServiceReference<?>> iterator = references.iterator();
        while (iterator.hasNext()) {
            ServiceReference<?> ref = iterator.next();
            if (scopedReferences.contains(ref)) continue;
            iterator.remove();
        }
    }

    private Collection<ServiceReference<?>> getScopedReferences(Collection<ServiceReference<?>> references, Scope scope) {
        HashSet scopedReferences = new HashSet();
        this.logger.debug("References input to getScopedReferences: {}", (Object)references.size());
        for (ServiceReference<?> ref : references) {
            Scope serviceScope = this.getServiceScope(ref);
            if (!scope.equals(serviceScope)) continue;
            this.logger.debug("Adding {} ", ref);
            scopedReferences.add(ref);
        }
        this.logger.debug("References output from getScopedReferences: {}", (Object)scopedReferences.size());
        return scopedReferences;
    }

    private void restrictServicesToScope(Collection<ServiceReference<?>> references, Scope scope) {
        this.logger.debug("Before filtering: {}", (Object)references.size());
        Iterator<ServiceReference<?>> iterator = references.iterator();
        while (iterator.hasNext()) {
            ServiceReference<?> ref = iterator.next();
            Scope serviceScope = this.getServiceScope(ref);
            if (scope.equals(serviceScope)) continue;
            this.logger.debug("Removing {} ", ref);
            iterator.remove();
        }
        this.logger.debug("After filtering: {}", (Object)references.size());
    }

    private Scope getLookupScope(Bundle consumer, String name, String filter) {
        Scope consumerScope = this.getBundleScope(consumer);
        Scope lookupScope = !consumerScope.isGlobal() && !this.scopeHasMatchingService(consumerScope, name, filter) ? this.scopeFactory.getGlobalScope() : consumerScope;
        this.logger.debug("{} > {} [{}] ({})", new Object[]{lookupScope, name, filter, consumer});
        return lookupScope;
    }

    private Scope getBundleScope(Bundle consumer) {
        return this.scopeFactory.getBundleScope(consumer);
    }

    private boolean scopeHasMatchingService(Scope scope, String name, String filter) {
        try {
            return this.scopeServiceRepository.scopeHasMatchingService(scope.getScopeName(), name, filter);
        }
        catch (InvalidSyntaxException e) {
            this.logger.warn("Filter '{}' is not valid", (Object)e, (Object)filter);
            return false;
        }
    }

    private Scope getServiceScope(ServiceReference<?> ref) {
        try {
            return this.scopeFactory.getServiceScope(ref);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }
}

