/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.AbstractModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.parser.IModelParser;
import org.eclipse.vorto.core.ui.parser.ParseModelResult;

public class DatatypeModelElement
extends AbstractModelElement {
    private IFile modelFile;
    private Type model;
    private Collection<Resource.Diagnostic> diagnostics = Collections.emptyList();
    private ModelType[] possibleReferenceTypes = new ModelType[]{ModelType.Datatype};
    private IModelParser modelParser;

    public DatatypeModelElement(IModelProject modelProject, IFile modelFile, IModelParser modelParser) {
        super(modelProject);
        this.modelFile = modelFile;
        this.modelParser = modelParser;
        ParseModelResult<Type> parseResult = modelParser.parseModelWithError(modelFile, Type.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }

    @Override
    public IFile getModelFile() {
        return this.modelFile;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Collection<Resource.Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    protected String getImageURLAsString() {
        Model model = this.getModel();
        if (model instanceof Enum) {
            return "platform:/plugin/org.eclipse.vorto.core.ui/icons/enu-20x20.png";
        }
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/ent-20x20.png";
    }

    @Override
    protected String getErrorImageURLAsString() {
        Model model = this.getModel();
        if (model instanceof Enum) {
            return "platform:/plugin/org.eclipse.vorto.core.ui/icons/enu-error.png";
        }
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/ent-error.png";
    }

    @Override
    protected ModelType[] getPossibleReferenceTypes() {
        return this.possibleReferenceTypes;
    }

    @Override
    public void reload() {
        ParseModelResult<Type> parseResult = this.modelParser.parseModelWithError(this.modelFile, Type.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.modelFile == null ? 0 : this.modelFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatatypeModelElement other = (DatatypeModelElement)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.modelFile == null ? other.modelFile != null : !this.modelFile.equals((Object)other.modelFile));
    }
}

