/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.dnd.dropaction;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.api.repository.IModelRepository;
import org.eclipse.vorto.core.api.repository.ModelRepositoryFactory;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.core.api.repository.RepositoryException;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.vorto.core.ui.exception.ExceptionHandlerFactory;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.perspective.dnd.IDropAction;

public class RepositoryResourceDropAction
implements IDropAction<IModelProject, ModelResource> {
    private IModelRepository modelRepo = ModelRepositoryFactory.getModelRepository();
    private ResourceAttributes readOnlyAttribute = new ResourceAttributes();

    public RepositoryResourceDropAction() {
        this.readOnlyAttribute.setReadOnly(false);
    }

    @Override
    public IModelElement performDrop(IModelProject receivingModelElement, ModelResource modelResource) {
        Objects.requireNonNull(receivingModelElement, "receivingModelElement shouldn't be null.");
        Objects.requireNonNull(modelResource, "droppedObject shouldn't be null.");
        return this.downloadAndSaveModel(receivingModelElement, modelResource.getId());
    }

    private IModelElement downloadAndSaveModel(IModelProject modelProject, ModelId modelId) {
        IModelElement modelElement = null;
        try {
            ModelResource model = this.modelRepo.getModel(modelId);
            if (model != null) {
                if (!modelProject.exists(modelId)) {
                    for (ModelId reference : model.getReferences()) {
                        this.downloadAndSaveModel(modelProject, reference);
                    }
                    this.downloadMappings(modelProject, model.getReferencedBy());
                    MessageDisplayFactory.getMessageDisplay().display("Downloading " + modelId.toString());
                    byte[] modelContent = this.modelRepo.downloadContent(model.getId());
                    modelElement = this.saveToProject(modelProject, modelContent, model.getId());
                } else {
                    modelElement = modelProject.getModelElementById(modelId);
                }
            } else {
                MessageDisplayFactory.getMessageDisplay().displayError("Model " + modelId.toString() + " not found in repository.");
            }
        }
        catch (RepositoryException e) {
            ExceptionHandlerFactory.getHandler().handle((Throwable)e);
        }
        return modelElement;
    }

    private void downloadMappings(IModelProject modelProject, List<ModelId> referencedBy) {
        for (ModelId modelId : referencedBy) {
            ModelResource model = this.modelRepo.getModel(modelId);
            if (model == null || model.getId().getModelType() != ModelType.Mapping) continue;
            MessageDisplayFactory.getMessageDisplay().display("Downloading " + modelId.toString());
            byte[] modelContent = this.modelRepo.downloadContent(model.getId());
            this.saveToProject(modelProject, modelContent, model.getId());
        }
    }

    private IModelElement saveToProject(IModelProject project, byte[] modelContent, ModelId modelId) {
        return project.addModelElement(modelId, (InputStream)new ByteArrayInputStream(modelContent));
    }
}

