/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.view;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.ui.handler.CodeGenerationHelper;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.repository.Attachment;
import org.eclipse.vorto.core.api.repository.GeneratorResource;
import org.eclipse.vorto.core.api.repository.IModelRepository;
import org.eclipse.vorto.core.api.repository.ModelRepositoryFactory;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.core.ui.exception.ExceptionHandlerFactory;

public class GeneratorItem
extends Composite {
    private final Label lblGenerated = new Label((Composite)this, 0);

    public GeneratorItem(Composite parent, int style, final ModelResource model, final GeneratorResource codegen) {
        super(parent, 526336);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setSize(500, 120);
        Label lblIcon = new Label((Composite)this, 0);
        lblIcon.setBackground(Display.getCurrent().getSystemColor(1));
        lblIcon.setAlignment(0x1000000);
        lblIcon.setBounds(27, 21, 36, 36);
        ImageDescriptor generatorImage = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(codegen.getImage32x32().getBytes()))));
        lblIcon.setImage(generatorImage.createImage());
        Label lblName = new Label((Composite)this, 0);
        lblName.setAlignment(0x1000000);
        lblName.setBounds(10, 63, 70, 15);
        lblName.setText(codegen.getName());
        lblName.setBackground(Display.getCurrent().getSystemColor(1));
        StyledText txtDescription = new StyledText((Composite)this, 72);
        txtDescription.setBounds(96, 10, 390, 75);
        txtDescription.setText(codegen.getDescription());
        txtDescription.setBackground(Display.getCurrent().getSystemColor(1));
        Label lblCreatedBy = new Label((Composite)this, 0);
        lblCreatedBy.setBounds(96, 91, 60, 15);
        lblCreatedBy.setText("Created by ");
        lblCreatedBy.setBackground(Display.getCurrent().getSystemColor(1));
        Label lblAuthor = new Label((Composite)this, 0);
        lblAuthor.setBounds(157, 91, 131, 15);
        lblAuthor.setText(codegen.getCreator());
        lblAuthor.setBackground(Display.getCurrent().getSystemColor(1));
        Label lblStarImage = new Label((Composite)this, 0);
        lblStarImage.setAlignment(0x1000000);
        lblStarImage.setBounds(10, 83, 70, 23);
        lblStarImage.setText("Rating: " + this.formatRating(codegen.getRating()));
        lblStarImage.setBackground(Display.getCurrent().getSystemColor(1));
        this.lblGenerated.setBounds(320, 91, 85, 15);
        this.lblGenerated.setText("");
        this.lblGenerated.setAlignment(131072);
        this.lblGenerated.setBackground(Display.getCurrent().getSystemColor(1));
        final Button btnGenerate = new Button((Composite)this, 0);
        btnGenerate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorItem.this.lblGenerated.setText("Generating...");
                try {
                    IModelRepository modelRepo = ModelRepositoryFactory.getModelRepository();
                    Attachment attachment = modelRepo.generateCode(model.getId(), codegen.getKey());
                    CodeGenerationHelper.createEclipseProject((ModelId)model.getId(), (String)codegen.getKey(), (IGenerationResult)GeneratorItem.this.toGenerationResult(attachment));
                    GeneratorItem.this.lblGenerated.setText("Generated.");
                    btnGenerate.setEnabled(false);
                }
                catch (Exception e1) {
                    ExceptionHandlerFactory.getHandler().handle((Throwable)e1);
                }
            }
        });
        btnGenerate.setBounds(411, 86, 75, 25);
        btnGenerate.setText("Generate");
    }

    private IGenerationResult toGenerationResult(final Attachment attachment) {
        return new IGenerationResult(){

            public String getMediatype() {
                return attachment.getType();
            }

            public String getFileName() {
                return attachment.getFilename();
            }

            public byte[] getContent() {
                return attachment.getContent();
            }
        };
    }

    private String formatRating(String rating) {
        if (rating.equalsIgnoreCase("fair")) {
            return "*";
        }
        if (rating.equalsIgnoreCase("good")) {
            return "**";
        }
        if (rating.equalsIgnoreCase("very_good")) {
            return "***";
        }
        if (rating.equalsIgnoreCase("excellent")) {
            return "****";
        }
        return "n/a";
    }
}

