/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.mapping.tests.formatter;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.impl.MappingPackageImpl;
import org.eclipse.vorto.editor.mapping.MappingInjectorProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.junit4.AbstractXtextTests;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=MappingInjectorProvider.class)
public class MappingModelFormatterTest
extends AbstractXtextTests {
    @Inject
    @Extension
    private ParseHelper<MappingModel> parserHelper;
    @Inject
    @Extension
    private INodeModelFormatter formatter;

    @BeforeClass
    public static void initializeModel() {
        MappingPackageImpl.init();
    }

    @Test
    public void testFormatFunctionBlockMapping() {
        String expectedText = this.getFunctionBlockMappingFormatted();
        String rawText = this.getFunctionBlockMappingUnformatted();
        this.assertFormattedAs(rawText, expectedText);
    }

    public void assertFormattedAs(CharSequence input, CharSequence expected) {
        try {
            String expectedText = expected.toString();
            MappingModel _parse = (MappingModel)this.parserHelper.parse(input);
            Resource _eResource = _parse.eResource();
            IParseResult _parseResult = ((XtextResource)_eResource).getParseResult();
            ICompositeNode _rootNode = _parseResult.getRootNode();
            int _length = input.length();
            INodeModelFormatter.IFormattedRegion _format = this.formatter.format(_rootNode, 0, _length);
            String formattedText = _format.getFormattedText();
            Assert.assertEquals((Object)expectedText, (Object)formattedText);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getFunctionBlockMappingUnformatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace com.mycompany.map");
        _builder.newLine();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"Color Mapping \"");
        _builder.newLine();
        _builder.append((Object)"description \"Mapping for Color\"");
        _builder.newLine();
        _builder.append((Object)"category demo");
        _builder.newLine();
        _builder.append((Object)"using com.mycompany.fb.NewFunctionBlock ; 1.0.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"functionblockmapping FunctionBlock_Property { \ttargetplatform mym2m");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.status.isOn");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"to TargetStatus");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"from NewFunctionBlock.configuration.configEntityA");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to TargetConfiguration");
        _builder.newLine();
        _builder.append((Object)"from NewFunctionBlock.fault.faultCode");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to MyFaultCode");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.event.Ready to TargetReadyEvent");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.event.Ready.entityA");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"TargetReadyEvent with { default : \"NotReady\" }");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.operation.on,");
        _builder.newLine();
        _builder.append((Object)"NewFunctionBlock.operation.off");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to TargetOperations");
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder.toString();
    }

    private String getFunctionBlockMappingFormatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace com.mycompany.map");
        _builder.newLine();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"Color Mapping \"");
        _builder.newLine();
        _builder.append((Object)"description \"Mapping for Color\"");
        _builder.newLine();
        _builder.append((Object)"category demo");
        _builder.newLine();
        _builder.append((Object)"using com.mycompany.fb.NewFunctionBlock ; 1.0.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"functionblockmapping FunctionBlock_Property {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"targetplatform mym2m");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.status.isOn");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to TargetStatus");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.configuration.configEntityA");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to TargetConfiguration");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.fault.faultCode");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to MyFaultCode");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.event.Ready");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to TargetReadyEvent");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.event.Ready.entityA");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to TargetReadyEvent with { default : \"NotReady\" }");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"from NewFunctionBlock.operation.on, NewFunctionBlock.operation.off");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"to TargetOperations");
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder.toString();
    }
}

