/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard.mapping;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.handler.ModelGenerationTask;
import org.eclipse.vorto.codegen.ui.tasks.ProjectFileOutputter;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelProjectFactory;
import org.eclipse.vorto.wizard.AbstractVortoWizard;
import org.eclipse.vorto.wizard.mapping.MappingModelTemplateFileContent;
import org.eclipse.vorto.wizard.mapping.MappingModellWizardPage;

public class MappingModelWizard
extends AbstractVortoWizard
implements INewWizard {
    private MappingModellWizardPage iotWizardPage;
    private String modelFolder = "mappings/";
    private IModelProject modelProject;
    private ModelId modelId;

    public MappingModelWizard(IModelProject modelProject, ModelId modelId) {
        this.modelProject = modelProject;
        this.modelId = modelId;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.iotWizardPage = new MappingModellWizardPage("Mapping Model Wizard", this.modelProject);
        this.iotWizardPage.setTitle("Create Mapping Model");
        this.iotWizardPage.setDescription("Please enter the details for creating mapping model.");
        this.addPage((IWizardPage)this.iotWizardPage);
    }

    public boolean performFinish() {
        new ModelGenerationTask(ModelType.Mapping.getExtension(), (ITemplate)new MappingModelTemplateFileContent(this.modelId), this.modelFolder).generate((Object)this.iotWizardPage, InvocationContext.simpleInvocationContext(), (IGeneratedWriter)new ProjectFileOutputter(this.modelProject.getProject()));
        this.openModelWithDefaultEditor();
        return true;
    }

    private void openModelWithDefaultEditor() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.iotWizardPage.getProjectName());
        IModelProject modelProject = ModelProjectFactory.getInstance().getProject(project);
        final IFile modelFile = modelProject.getModelElementById(this.iotWizardPage.getModelId()).getModelFile();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null && (page = activeWindow.getActivePage()) != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    public MappingModellWizardPage getIotWizardPage() {
        return this.iotWizardPage;
    }

    public void setIotWizardPage(MappingModellWizardPage iotWizardPage) {
        this.iotWizardPage = iotWizardPage;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }
}

