/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.vorto.core.api.model.datatype.DatatypeFactory;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockFactory;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelFactory;
import org.eclipse.vorto.core.api.model.mapping.Attribute;
import org.eclipse.vorto.core.api.model.mapping.MappingFactory;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.MappingRule;
import org.eclipse.vorto.core.api.model.mapping.Source;
import org.eclipse.vorto.core.api.model.mapping.StereoTypeTarget;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.VortoLangVersion;

public abstract class BuilderUtils {
    public static Property createProperty(String name, Type type) {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        prop.setName(name);
        prop.setType(BuilderUtils.createObjectType(type));
        return prop;
    }

    public static ObjectPropertyType createObjectType(Type type) {
        ObjectPropertyType typeObj = DatatypeFactory.eINSTANCE.createObjectPropertyType();
        typeObj.setType(type);
        return typeObj;
    }

    public static Property createProperty(String name, PrimitiveType type) {
        Property prop = DatatypeFactory.eINSTANCE.createProperty();
        prop.setName(name);
        prop.setType(BuilderUtils.createPrimitiveType(type));
        return prop;
    }

    private static PrimitivePropertyType createPrimitiveType(PrimitiveType type) {
        PrimitivePropertyType typeObj = DatatypeFactory.eINSTANCE.createPrimitivePropertyType();
        typeObj.setType(type);
        return typeObj;
    }

    public static FunctionblockBuilder newFunctionblock(ModelId modelId) {
        return (FunctionblockBuilder)new FunctionblockBuilder().withId(modelId);
    }

    public static InformationModelBuilder newInformationModel(ModelId modelId) {
        return (InformationModelBuilder)new InformationModelBuilder().withId(modelId);
    }

    public static EntityBuilder newEntity(ModelId modelId) {
        return (EntityBuilder)new EntityBuilder().withId(modelId);
    }

    public static MappingBuilder newMapping(ModelId modelId, String targetPlatformKey) {
        return (MappingBuilder)new MappingBuilder().withTargetPlatformKey(targetPlatformKey).withId(modelId);
    }

    public static EventBuilder newEvent(String name) {
        return new EventBuilder(name);
    }

    public static EnumBuilder newEnum(ModelId modelId) {
        return (EnumBuilder)new EnumBuilder().withId(modelId);
    }

    public static class EntityBuilder
    extends ModelBuilder<Entity> {
        public EntityBuilder() {
            super(DatatypeFactory.eINSTANCE.createEntity());
        }

        public EntityBuilder withProperty(Property property) {
            ((Entity)this.model).getProperties().add((Object)property);
            return this;
        }

        public EntityBuilder withProperty(String name, PrimitiveType type) {
            ((Entity)this.model).getProperties().add((Object)BuilderUtils.createProperty(name, type));
            return this;
        }

        public EntityBuilder withProperty(String name, Type objectType) {
            ((Entity)this.model).getProperties().add((Object)BuilderUtils.createProperty(name, objectType));
            return this;
        }
    }

    public static class EnumBuilder
    extends ModelBuilder<Enum> {
        public EnumBuilder() {
            super(DatatypeFactory.eINSTANCE.createEnum());
        }

        public EnumBuilder withLiterals(String ... values) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                EnumLiteral literal = DatatypeFactory.eINSTANCE.createEnumLiteral();
                literal.setName(value);
                ((Enum)this.model).getEnums().add((Object)literal);
                ++n2;
            }
            return this;
        }

        public EnumBuilder withLiteral(String value, String description) {
            EnumLiteral literal = DatatypeFactory.eINSTANCE.createEnumLiteral();
            literal.setName(value);
            literal.setDescription(description);
            ((Enum)this.model).getEnums().add((Object)literal);
            return this;
        }
    }

    public static class EventBuilder {
        private Event event = FunctionblockFactory.eINSTANCE.createEvent();

        public EventBuilder(String name) {
            this.event.setName(name);
        }

        public EventBuilder withProperty(Property property) {
            this.event.getProperties().add((Object)property);
            return this;
        }

        public EventBuilder withProperty(String name, PrimitiveType type) {
            this.event.getProperties().add((Object)BuilderUtils.createProperty(name, type));
            return this;
        }

        public EventBuilder withProperty(String name, Type objectType) {
            this.event.getProperties().add((Object)BuilderUtils.createProperty(name, objectType));
            return this;
        }

        public Event build() {
            return this.event;
        }
    }

    public static class FunctionblockBuilder
    extends ModelBuilder<FunctionblockModel> {
        private FunctionBlock fb = FunctionblockFactory.eINSTANCE.createFunctionBlock();

        public FunctionblockBuilder() {
            super(FunctionblockFactory.eINSTANCE.createFunctionblockModel());
            ((FunctionblockModel)this.model).setFunctionblock(this.fb);
        }

        public FunctionblockBuilder withStatusProperty(String name, PrimitiveType type) {
            if (this.fb.getStatus() == null) {
                Status status = FunctionblockFactory.eINSTANCE.createStatus();
                this.fb.setStatus(status);
            }
            this.fb.getStatus().getProperties().add((Object)BuilderUtils.createProperty(name, type));
            return this;
        }

        public FunctionblockBuilder withStatusProperty(String name, Type type) {
            if (this.fb.getStatus() == null) {
                Status status = FunctionblockFactory.eINSTANCE.createStatus();
                this.fb.setStatus(status);
            }
            this.fb.getStatus().getProperties().add((Object)BuilderUtils.createProperty(name, type));
            return this;
        }

        public FunctionblockBuilder withStatusProperty(Property property) {
            if (this.fb.getStatus() == null) {
                Status status = FunctionblockFactory.eINSTANCE.createStatus();
                this.fb.setStatus(status);
            }
            this.fb.getStatus().getProperties().add((Object)property);
            return this;
        }

        public FunctionblockBuilder withConfiguration(Property property) {
            if (this.fb.getConfiguration() == null) {
                Configuration configuration = FunctionblockFactory.eINSTANCE.createConfiguration();
                this.fb.setConfiguration(configuration);
            }
            this.fb.getConfiguration().getProperties().add((Object)property);
            return this;
        }

        public FunctionblockBuilder withConfiguration(String name, PrimitiveType type) {
            if (this.fb.getConfiguration() == null) {
                Configuration configuration = FunctionblockFactory.eINSTANCE.createConfiguration();
                this.fb.setConfiguration(configuration);
            }
            this.fb.getConfiguration().getProperties().add((Object)BuilderUtils.createProperty(name, type));
            return this;
        }

        public FunctionblockBuilder withConfiguration(String name, Type type) {
            if (this.fb.getConfiguration() == null) {
                Configuration configuration = FunctionblockFactory.eINSTANCE.createConfiguration();
                this.fb.setConfiguration(configuration);
            }
            this.fb.getConfiguration().getProperties().add((Object)BuilderUtils.createProperty(name, type));
            return this;
        }

        public FunctionblockBuilder withEvent(Event event) {
            this.fb.getEvents().add((Object)event);
            return this;
        }

        public FunctionblockBuilder withOperation(String operationName, ReturnType returnType, String description, boolean breakable, Param ... params) {
            Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
            operation.setName(operationName);
            operation.setDescription(description);
            operation.setBreakable(breakable);
            operation.setReturnType(returnType);
            if (params != null && params.length > 0) {
                operation.getParams().addAll(Arrays.asList(params));
            }
            this.fb.getOperations().add((Object)operation);
            return this;
        }
    }

    public static class InformationModelBuilder
    extends ModelBuilder<InformationModel> {
        public InformationModelBuilder() {
            super(InformationModelFactory.eINSTANCE.createInformationModel());
        }

        public InformationModelBuilder withFunctionBlock(FunctionblockModel fbm, String propertyName, String description, boolean isMultiple) {
            FunctionblockProperty property = InformationModelFactory.eINSTANCE.createFunctionblockProperty();
            property.setName(propertyName);
            property.setDescription(description);
            property.setMultiplicity(isMultiple);
            property.setType(fbm);
            ((InformationModel)this.model).getProperties().add((Object)property);
            return this;
        }
    }

    public static class MappingBuilder
    extends ModelBuilder<MappingModel> {
        public MappingBuilder() {
            super(MappingFactory.eINSTANCE.createMappingModel());
        }

        public MappingBuilder withTargetPlatformKey(String targetPlatformKey) {
            ((MappingModel)this.model).setTargetPlatform(targetPlatformKey);
            return this;
        }

        public MappingBuilder addRule(MappingRule rule) {
            ((MappingModel)this.model).getRules().add((Object)rule);
            return this;
        }
    }

    public static class MappingRuleBuilder {
        private MappingRule rule = MappingFactory.eINSTANCE.createMappingRule();

        public MappingRuleBuilder withSource(Source source) {
            this.rule.getSources().add((Object)source);
            return this;
        }

        public MappingRuleBuilder withStereotypeTarget(String name, Map<String, String> attributes) {
            StereoTypeTarget target = MappingFactory.eINSTANCE.createStereoTypeTarget();
            target.setName(name);
            for (String key : attributes.keySet()) {
                String value = attributes.get(key);
                Attribute attribute = MappingFactory.eINSTANCE.createAttribute();
                attribute.setName(key);
                attribute.setValue(value);
                target.getAttributes().add((Object)attribute);
            }
            this.rule.setTarget(target);
            return this;
        }

        public MappingRule build() {
            return this.rule;
        }
    }

    public static abstract class ModelBuilder<T extends Model> {
        protected T model;

        public ModelBuilder(T model) {
            this.model = model;
        }

        public ModelBuilder<T> withId(ModelId id) {
            this.model.setName(id.getName());
            this.model.setNamespace(id.getNamespace());
            this.model.setVersion(id.getVersion());
            this.model.setDisplayname(id.getName());
            return this;
        }

        public ModelBuilder<T> withDescription(String description) {
            this.model.setDescription(description);
            return this;
        }

        public ModelBuilder<T> withDisplayName(String displayName) {
            this.model.setDisplayname(displayName);
            return this;
        }

        public ModelBuilder<T> withCategory(String category) {
            this.model.setCategory(category);
            return this;
        }

        public ModelBuilder<T> withVortolang(String lang) {
            if ("1.0".equals(lang)) {
                this.model.setLang(VortoLangVersion.VERSION1);
            }
            return this;
        }

        public ModelBuilder<T> withReferences(List<ModelId> references) {
            for (ModelId id : references) {
                this.model.getReferences().add((Object)id.asModelReference());
            }
            return this;
        }

        public ModelBuilder<T> withReference(ModelId references) {
            ModelReference referenceToBeAdded = references.asModelReference();
            if (!this.model.getReferences().stream().filter(ref -> ref.getImportedNamespace().equals(referenceToBeAdded.getImportedNamespace()) && ref.getVersion().equals(referenceToBeAdded.getVersion())).findAny().isPresent()) {
                this.model.getReferences().add((Object)referenceToBeAdded);
            }
            return this;
        }

        public T build() {
            return this.model;
        }
    }
}

