/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.DatatypeModelElement;
import org.eclipse.vorto.core.ui.model.FunctionblockModelElement;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.InformationModelElement;
import org.eclipse.vorto.core.ui.model.MappingModelElement;
import org.eclipse.vorto.core.ui.model.ModelNotFoundException;
import org.eclipse.vorto.core.ui.parser.IModelParser;

public class VortoModelProject
implements IModelProject {
    protected IProject project;
    private static final String FOLDER_DATATYPES = "datatypes";
    private static final String FOLDER_FUNCTIONBLOCKS = "functionblocks";
    private static final String FOLDER_INFOMODELS = "infomodels";
    private static final String FOLDER_MAPPINGS = "mappings";
    private IModelParser modelParser;

    public VortoModelProject(IProject project, IModelParser modelParser) {
        this.project = project;
        this.modelParser = modelParser;
    }

    public static boolean isVortoModelProject(IProject project) {
        try {
            return project.getNature("org.eclipse.vorto.vortonature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        try {
            this.project.refreshLocal(2, monitor);
        }
        catch (CoreException coreException) {}
    }

    @Override
    public List<IModelElement> getModelElements() {
        return Collections.emptyList();
    }

    @Override
    public List<IModelElement> getModelElementsByType(ModelType modelType) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = this.getFolderByType(modelType).members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                result.add(this.createModelElement(modelType, (IFile)member));
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new ModelNotFoundException("Invalid model file found", e, this.project);
        }
        return result;
    }

    private IModelElement createModelElement(ModelType modelType, IFile member) {
        if (modelType == ModelType.Datatype) {
            return new DatatypeModelElement(this, member, this.modelParser);
        }
        if (modelType == ModelType.Functionblock) {
            return new FunctionblockModelElement(this, member, this.modelParser);
        }
        if (modelType == ModelType.InformationModel) {
            return new InformationModelElement(this, member, this.modelParser);
        }
        return new MappingModelElement(this, member, this.modelParser);
    }

    private IFolder getFolderByType(ModelType modelType) {
        if (modelType == ModelType.Datatype) {
            return this.project.getFolder(FOLDER_DATATYPES);
        }
        if (modelType == ModelType.Functionblock) {
            return this.project.getFolder(FOLDER_FUNCTIONBLOCKS);
        }
        if (modelType == ModelType.InformationModel) {
            return this.project.getFolder(FOLDER_INFOMODELS);
        }
        if (modelType == ModelType.Mapping) {
            return this.project.getFolder(FOLDER_MAPPINGS);
        }
        throw new UnsupportedOperationException(modelType + " cannot be resolved to a folder in the project");
    }

    @Override
    public IModelElement getModelElementById(ModelId modelId) {
        for (IModelElement modelElement : this.getModelElementsByType(modelId.getModelType())) {
            if (!modelElement.getId().equals((Object)modelId)) continue;
            return modelElement;
        }
        return null;
    }

    @Override
    public List<MappingModel> getMapping(String targetPlatform) {
        ArrayList<MappingModel> mappingModels = new ArrayList<MappingModel>();
        for (IModelElement modelElement : this.getModelElementsByType(ModelType.Mapping)) {
            if (!((MappingModel)modelElement.getModel()).getTargetPlatform().equalsIgnoreCase(targetPlatform)) continue;
            mappingModels.add((MappingModel)modelElement.getModel());
        }
        return mappingModels;
    }

    @Override
    public IModelElement addModelElement(ModelId modelId, InputStream inputStream) {
        try {
            ModelType modelType = modelId.getModelType();
            IFolder folder = this.getFolderByType(modelId.getModelType());
            IFile file = folder.getFile(modelId.getFileName());
            if (file.exists()) {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            file.create(inputStream, true, (IProgressMonitor)new NullProgressMonitor());
            if (modelType == ModelType.InformationModel) {
                return new InformationModelElement(this, file, this.modelParser);
            }
            if (modelType == ModelType.Functionblock) {
                return new FunctionblockModelElement(this, file, this.modelParser);
            }
            if (modelType == ModelType.Datatype) {
                return new DatatypeModelElement(this, file, this.modelParser);
            }
            if (modelType == ModelType.Mapping) {
                return new MappingModelElement(this, file, this.modelParser);
            }
            throw new UnsupportedOperationException("Modeltype is not supported");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean exists(ModelId modelId) {
        return this.getModelElementById(modelId) != null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VortoModelProject other = (VortoModelProject)obj;
        return !(this.project == null ? other.project != null : !this.project.equals((Object)other.project));
    }
}

