/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelAttribute implements Enumerator
{
    NAME(0, "name", "name"),
    NAMESPACE(1, "namespace", "namespace"),
    VERSION(2, "version", "version"),
    DISPLAYNAME(3, "displayname", "displayname"),
    DESCRIPTION(4, "description", "description"),
    CATEGORY(5, "category", "category");

    public static final int NAME_VALUE = 0;
    public static final int NAMESPACE_VALUE = 1;
    public static final int VERSION_VALUE = 2;
    public static final int DISPLAYNAME_VALUE = 3;
    public static final int DESCRIPTION_VALUE = 4;
    public static final int CATEGORY_VALUE = 5;
    private static final ModelAttribute[] VALUES_ARRAY;
    public static final List<ModelAttribute> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelAttribute[]{NAME, NAMESPACE, VERSION, DISPLAYNAME, DESCRIPTION, CATEGORY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelAttribute get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelAttribute result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelAttribute getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelAttribute result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelAttribute get(int value) {
        switch (value) {
            case 0: {
                return NAME;
            }
            case 1: {
                return NAMESPACE;
            }
            case 2: {
                return VERSION;
            }
            case 3: {
                return DISPLAYNAME;
            }
            case 4: {
                return DESCRIPTION;
            }
            case 5: {
                return CATEGORY;
            }
        }
        return null;
    }

    private ModelAttribute(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

